!= Module HistoryFileIO_3d
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: historyfileio_3d.f90,v 1.8 2009-02-28 08:19:09 sugiyama Exp $ 
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!ե. Ĺ֥ƥåפͤ.
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!

module HistoryFileIO_3d
  !
  !ե. Ĺ֥ƥåפͤ.
  !

  !⥸塼ɤ߹
  use dc_types, only: DP
  use gtool_history, only: HistoryCreate, HistoryPut, HistoryAddVariable, &
    &                    HistoryClose, gt_history
  use dc_message,     only: MessageNotify

  use gridset_3d,only: x_X,              &!X ɸ(顼ʻ)
    &                 y_Y,               &!Z ɸ(顼ʻ)
    &                 z_Z,               &!Z ɸ(顼ʻ)
    &                 FileNX,            &!X γʻ(ե)
    &                 FileNY,            &!Y γʻ(ե)
    &                 FileNZ,            &!Z γʻ(ե)
    &                 FileXMin,          &!X β(ե)
    &                 FileXMax,          &!X ξ(ե)
    &                 FileYMin,          &!Y β(ե)
    &                 FileYMax,          &!Y ξ(ե)
    &                 FileZMin,          &!Z β(ե)
    &                 FileZMax,          &!Z ξ(ե)
    &                 DimXMin,           &!X β
    &                 DimXMax,           &!X ξ
    &                 DimYMin,           &!Y β
    &                 DimYMax,           &!Y ξ
    &                 DimZMin,           &!Z β
    &                 DimZMax,           &!Z ξ
    &                 SpcNum              !Žʬο
  use basicset_3d, only: xyz_ExnerBasicZ,    &!ܾΥʡؿ
    &                 xyz_DensBasicZ,     &!ܾ̩
    &                 xyz_PotTempBasicZ,  &!ܾβ
    &                 xyz_VelSoundBasicZ, &!ܾβ®
    &                 xyz_PressBasicZ,    &!ܾΰ
    &                 xyz_TempBasicZ,     &!ܾβ
    &                 xyza_MixRtBasicZ,   &!ܾκ
    &                 xyz_EffMolWtBasicZ, &!ܾʬ̸
    &                 SpcWetSymbol        !ʬβؼ̾
  use fileset_3d, only: HistoryFile,       &!ҥȥե̾
    &                 exptitle,          &!ǡɽ
    &                 expsrc,            &!ǡ
    &                 expinst,           &!ǽѹԡȿ
    &                 FileNum,           &!ҥȥեο
    &                 gt_hist             !gt_history ¤ѿ
  use StorePotTemp_3d, only: StorePotTempMeanXY, &
    &                 z_Adv, z_Turb, z_Disp, z_Diff, &
    &                 z_Rad, z_Cond, z_Flux,z_Damp 

  use StoreMixRt_3d,  only: StoreMixRtMeanXY, &
    &                     za_Adv, za_Turb, za_Diff, za_Flux, &
    &                     za_Rain, za_Fill1, za_Fill2, za_Cond
  use StoreBuoy_3d,   only: StoreBuoyMeanXY, z_BuoyTemp, z_BuoyMolWt, z_BuoyDrag
  use StoreStab_3d,   only: StoreStabMeanXY, z_StabTemp, z_StabMolWt


  !ۤηػ
  implicit none
  
  !°λ
  private

  !ؿ public ˻
  public HistoryFile_Open
  public HistoryFile_OutPut
  public HistoryFile_Close

contains 

!!!------------------------------------------------------------------------
  subroutine HistoryFile_Open( )
    !
    !ҥȥե
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    integer :: s ! 롼ź

    !-----------------------------------------------------------
    ! ҥȥ꡼
    !-----------------------------------------------------------

    call MessageNotify ( "M", &
      &                  "HistoryFile_Open", &
      &                  "HistoryCreate" )

    do s = 1, FileNum
      call HistoryCreate(                              &
        & file = HistoryFile(s),                       &
        & title = exptitle,                            &
        & source = expsrc,                             &
        & institution = expinst,                       &
        & dims=(/'x','y','z','t'/),                    &
        & dimsizes=(/FileNX, FileNY, FileNZ, 0/),      &
        & longnames=(/'X-coordinate',                  &
        &             'Y-coordinate',                  &
        &             'Z-coordinate',                  &
        &             'Time        '/),                &
        & units=(/'m','m','m','s'/), origin=0.0,       &
        & xtypes=(/'double', 'double', 'double', 'double'/), &
        & interval=0.0,                                &
        & history=gt_hist(s) )

      call HistoryPut('x', x_X( FileXMin: FileXMax ), gt_hist(s) )
      call HistoryPut('y', y_Y( FileYMin: FileYMax ), gt_hist(s) )
      call HistoryPut('z', z_Z( FileZMin: FileZMax ), gt_hist(s) )

    end do

    !-----------------------------------------------------------  
    ! ͽѿν
    !-----------------------------------------------------------  

    call MessageNotify ( "M", &
      &                  "HistoryFile_Open", &
      &                  "HistoryAddVariable" )


    !̵Ϥξ
    call HistoryAddVariable(  &
      & varname='Exner',      &  
      & dims=(/'x','y','z','t'/), &
      & longname='disturbunce of nondimensional pressure', &
      & units=' ',            &        
      & xtype='double',       &
      & history=gt_hist(1) )
    
    !̤ξ
    call HistoryAddVariable(  &
      & varname='PotTemp',    &
      & dims=(/'x','y','z','t'/), &
      & longname='disturbunce of potential temperature',  &
      & units='K',            &
      & xtype='double',       &
      & history=gt_hist(2) )

    !ʿ®
    call HistoryAddVariable(  &
      & varname='VelX',       &
      & dims=(/'x','y','z','t'/), &
      & longname='zonal velocity', &
      & units='m.s-1',      &
      & xtype='double',       &
      & history=gt_hist(3) )

    !ʿ®
    call HistoryAddVariable(  &
      & varname='VelY',       &
      & dims=(/'x','y','z','t'/), &
      & longname='meridional velocity', &
      & units='m.s-1',      &
      & xtype='double',       &
      & history=gt_hist(4) )

    !ľ®
    call HistoryAddVariable(  &
      & varname='VelZ',       &
      & dims=(/'x','y','z','t'/), &
      & longname='vertical velocity', &
      & units='m.s-1',      &
      & xtype='double',       &
      & history=gt_hist(5) )

    !Ǵ(ư)
    call HistoryAddVariable(  &
      & varname='Km',         &
      & dims=(/'x','y','z','t'/), &
      & longname='turbulet diffusion coefficient', &
      & units='m2.s-1',           &
      & xtype='double',       &
      & history=gt_hist(6) )
  
    !Ǵ(Ǯ)
    call HistoryAddVariable(  &
      & varname='Kh',         &
      & dims=(/'x','y','z','t'/), &
      & longname='turbulet diffusion coefficient for heat', &
      & units='m2.s-1',          &
      & xtype='double',       &
      & history=gt_hist(7) )

    call HistoryAddVariable(  &
      & varname='VorX',       &
      & dims=(/'x','y','z','t'/), &
      & longname='vorticity', &
      & units='m.s-1',      &
      & xtype='double',       &
      & history=gt_hist(10) )

    call HistoryAddVariable(  &
      & varname='VorY',       &
      & dims=(/'x','y','z','t'/), &
      & longname='vorticity', &
      & units='m.s-1',      &
      & xtype='double',       &
      & history=gt_hist(11) )

    call HistoryAddVariable(  &
      & varname='VorZ',       &
      & dims=(/'x','y','z','t'/), &
      & longname='vorticity', &
      & units='m.s-1',      &
      & xtype='double',       &
      & history=gt_hist(12) )

 
    !----------------------------------------------------------------
    ! Stored Mixing Ratio
    !----------------------------------------------------------------
    do s = 1, SpcNum
      call HistoryAddVariable(                               &
        & varname=trim(SpcWetSymbol(s))//'_Mean',            &
        & dims=(/'z','t'/),                                  &
        & longname='Horiizontal Mean of '                    &
        &          //trim(SpcWetSymbol(s))//' Mixing Ratio', &
        & units='kg.kg-1',                                 &
        & xtype='double',                                    &
        & history=gt_hist(12+s) ) 
    end do

    !----------------------------------------------------------------
    ! Ū
    !----------------------------------------------------------------
    call HistoryAddVariable(  &
      & varname='Stab',       &
      & dims=(/'z','t'/),     &
      & longname='Static Stability', &
      & units='s-2',        &
      & xtype='double',       &
      & history=gt_hist(9) ) 

    call HistoryAddVariable(  &
      & varname='StabTemp',   &
      & dims=(/'z','t'/),     &
      & longname='Static Stability contributed by temperature', &
      & units='s-2',        &
      & xtype='double',       &
      & history=gt_hist(9) ) 

    call HistoryAddVariable(  &
      & varname='StabMolWt',  &
      & dims=(/'z','t'/),     &
      & longname='Static Stability contributed by Molecular Weight',&
      & units='s-2',        &
      & xtype='double',       &
      & history=gt_hist(9) ) 

    !----------------------------------------------------------------
    ! ̤λѲ
    !----------------------------------------------------------------
    call HistoryAddVariable(  &
      & varname='PotTempAdv', &
      & dims=(/'z','t'/),     &
      & longname='Advection term of potential temperature',  &
      & units='K.s-1',    &
      & xtype='double',       &
      & history=gt_hist(9) ) 

    call HistoryAddVariable(  &
      & varname='PotTempTurb',&
      & dims=(/'z','t'/),     &
      & longname='Turbulence term of potential temperature', &
      & units='K.s-1',    &
      & xtype='double',       &
      & history=gt_hist(9) ) 

    call HistoryAddVariable(  &
      & varname='PotTempDisp',&
      & dims=(/'z','t'/),     &
      & longname='Dissipation term of potential temperature', &
      & units='K.s-1',    &
      & xtype='double',       &
      & history=gt_hist(9) ) 

    call HistoryAddVariable(  &
      & varname='PotTempRad', &
      & dims=(/'z','t'/),     &
      & longname='Radiation term of potential temperature', &
      & units='K.s-1',    &
      & xtype='double',       &
      & history=gt_hist(9) ) 
    
    call HistoryAddVariable(  &
      & varname='PotTempDiff',&
      & dims=(/'z','t'/),     &
      & longname='Numerical diffusion term of potential temperature',&
      & units='K.s-1',    &
      & xtype='double',       &
      & history=gt_hist(9) ) 
    
    call HistoryAddVariable(  &
      & varname='PotTempCond',&
      & dims=(/'z','t'/),     &
      & longname='Latent heat term of potential temperature', &
      & units='K.s-1',    &
      & xtype='double',       &
      & history=gt_hist(9) ) 

    call HistoryAddVariable(  &
      & varname='PotTempFlux',&
      & dims=(/'z','t'/),     &
      & longname='Surface Flux term of potential temperature', &
      & units='K.s-1',    &
      & xtype='double',       &
      & history=gt_hist(9) ) 

    call HistoryAddVariable(  &
      & varname='PotTempDamp',&
      & dims=(/'z','t'/),     &
      & longname='Newtonian Cooling term of potential temperature',  &
      & units='K.s-1',    &
      & xtype='double',       &
      & history=gt_hist(9) ) 

    !----------------------------------------------------------------
    ! Mixing Ratio time change
    !----------------------------------------------------------------
    do s = 1, SpcNum
      call HistoryAddVariable(  &
        & varname=trim(SpcWetSymbol(s))//'_Adv', &
        & dims=(/'z','t'/),     &
        & longname='Advection term of '          &
        &           //trim(SpcWetSymbol(s))//' mixing ratio',  &
        & units='kg.kg-1.s-1',    &
        & xtype='double',       &
        & history=gt_hist(9) ) 
      
      call HistoryAddVariable(  &
        & varname=trim(SpcWetSymbol(s))//'_Turb', & 
        & dims=(/'z','t'/),     &
        & longname='Turbulence term of '          &
        &           //trim(SpcWetSymbol(s))//' mixing ratio',  &
        & units='kg.kg-1.s-1',    &
        & xtype='double',       &
        & history=gt_hist(9) ) 
     
      call HistoryAddVariable(  &
        & varname=trim(SpcWetSymbol(s))//'_Diff', & 
        & dims=(/'z','t'/),     &
        & longname='Diffusion term of '          &
        &           //trim(SpcWetSymbol(s))//' mixing ratio',  &
        & units='kg.kg-1.s-1',    &
        & xtype='double',       &
        & history=gt_hist(9) ) 
      
      call HistoryAddVariable(  &
        & varname=trim(SpcWetSymbol(s))//'_Flux', & 
        & dims=(/'z','t'/),     &
        & longname='Surface Flux term of '          &
        &           //trim(SpcWetSymbol(s))//' mixing ratio',  &
        & units='kg.kg-1.s-1',    &
        & xtype='double',       &
        & history=gt_hist(9) ) 
    
      call HistoryAddVariable(  &
        & varname=trim(SpcWetSymbol(s))//'_Rain', & 
        & dims=(/'z','t'/),     &
        & longname='Fall Rain term of '          &
       &           //trim(SpcWetSymbol(s))//' mixing ratio',  &
         & units='kg.kg-1.s-1',    &
        & xtype='double',       &
        & history=gt_hist(9) ) 
    
      call HistoryAddVariable(  &
        & varname=trim(SpcWetSymbol(s))//'_Fill1', & 
        & dims=(/'z','t'/),     &
        & longname='Filling Negative term 1 of '          &
        &           //trim(SpcWetSymbol(s))//' mixing ratio',  &
        & units='kg.kg-1.s-1',    &
        & xtype='double',       &
        & history=gt_hist(9) ) 
   
      call HistoryAddVariable(  &
        & varname=trim(SpcWetSymbol(s))//'_Fill2', & 
        & dims=(/'z','t'/),     &
        & longname='Filling Negative term 2 of '          &
        &           //trim(SpcWetSymbol(s))//' mixing ratio',  &
        & units='kg.kg-1.s-1',    &
        & xtype='double',       &
        & history=gt_hist(9) ) 
    
      call HistoryAddVariable(  &
        & varname=trim(SpcWetSymbol(s))//'_Cond', & 
        & dims=(/'z','t'/),     &
        & longname='Condensation term of '          &
        &           //trim(SpcWetSymbol(s))//' mixing ratio',  &
        & units='kg.kg-1.s-1',    &
        & xtype='double',       &
        & history=gt_hist(9) ) 
    
      call HistoryAddVariable(  &
        & varname=trim(SpcWetSymbol(s))//'_Asln', & 
        & dims=(/'z','t'/),     &
        & longname='Asselin time filter term of '          &
        &           //trim(SpcWetSymbol(s))//' mixing ratio',  &
        & units='kg.kg-1.s-1',    &
        & xtype='double',       &
        & history=gt_hist(9) ) 
    
    end do

    !-----------------------------------------------------------  
    ! ܾν
    !-----------------------------------------------------------  
    !̵Ϥδܾ
    call HistoryAddVariable(  &
      & varname='ExnerBasicZ',&
      & dims=(/'x','y','z'/),     &
      & longname='nondimensional pressure', units='1',&
      & xtype='double',       &
      & history=gt_hist(8) ) 
    
    !̤δܾ
    call HistoryAddVariable(  &
      & varname='PotTempBasicZ',&
      & dims=(/'x','y','z'/),     &
      & longname='potential temperature', &
      & units='K',            &
      & xtype='double',       &
      & history=gt_hist(8) ) 
    
    !̤δܾ
    call HistoryAddVariable(  &
      & varname='VPotTempBasicZ',&
      & dims=(/'x','y','z'/),     &
      & longname='vertial potential temperature', &
      & units='K',            &
      & xtype='double',       &
      & history=gt_hist(8) ) 
    
    !̩٤δܾ
    call HistoryAddVariable(  &
      & varname='DensBasicZ', &
      & dims=(/'x','y','z'/),     &
      & longname='density',   &
      & units='Kg.m-3',       &
      & xtype='double',       &
      & history=gt_hist(8) ) 
    
    !®٤δܾ
    call HistoryAddVariable(  &
      & varname='VelSoundBasicZ',&
      & dims=(/'x','y','z'/),     &
      & longname='sound velocity',&
      & units='m.s-2',        &
      & xtype='double',       &
      & history=gt_hist(8) ) 
    
    !٤δܾ
    call HistoryAddVariable(  &
      & varname='TempBasicZ', &
      & dims=(/'x','y','z'/),     &
      & longname='Temperature of basic state', &
      & units='K',            &
      & xtype='double',       &
      & history=gt_hist(8) ) 
    
    !Ϥδܾ
    call HistoryAddVariable(  &
      & varname='PressBasicZ',&
      & dims=(/'x','y','z'/),     &
      & longname='Pressure of basic state', &
      & units='Pa',           &
      & xtype='double',       &
      & history=gt_hist(8) ) 
    
    !δܾ
    do s = 1, SpcNum
      call HistoryAddVariable(  &
        & varname=trim(SpcWetSymbol(s))//'BasicZ',&
        & dims=(/'x','y','z'/), &
        & longname=trim(SpcWetSymbol(s))//' Mixing Ratio of basic state', &
        & units='kg.kg-1',        &
        & xtype='double',       &
        & history=gt_hist(8) ) 
    end do

    !ʬ̸
    call HistoryAddVariable(  &
      & varname='EffMolWtBasicZ', &
      & dims=(/'x','y','z'/),     &
      & longname='Effect of Mole Weight', &
      & units='1',            &
      & xtype='double',       &
      & history=gt_hist(8) ) 

    !-------------------------------------------------------------
    ! ܾΥե
    !-------------------------------------------------------------

    call MessageNotify ( "M", &
      &                  "HistoryFile_Open", &
      &                  "HistoryPut (BasicZ)" )

    call HistoryPut(   &
      & 'DensBasicZ',  &
      & xyz_DensBasicZ(FileXMin:FileXMax,FileYMin:FileYMax,FileZMin:FileZMax), &
      & gt_hist(8) )

    call HistoryPut(   &
      & 'ExnerBasicZ', &
      & xyz_ExnerBasicZ(FileXMin:FileXMax,FileYMin:FileYMax,FileZMin:FileZMax), &
      & gt_hist(8) )

    call HistoryPut(   &
      & 'PotTempBasicZ',&
      & xyz_PotTempBasicZ(FileXMin:FileXMax,FileYMin:FileYMax,FileZMin:FileZMax), &
      & gt_hist(8) )

    call HistoryPut(   &
      & 'VPotTempBasicZ',&
      & xyz_PotTempBasicZ(FileXMin:FileXMax,FileYMin:FileYMax,FileZMin:FileZMax)    &
      & / xyz_EffMolWtBasicZ(FileXMin:FileXMax,FileYMin:FileYMax,FileZMin:FileZMax),&
      & gt_hist(8) )

    call HistoryPut(   &
      & 'VelSoundBasicZ', &
      & xyz_VelSoundBasicZ(FileXMin:FileXMax,FileYMin:FileYMax,FileZMin:FileZMax), &
      & gt_hist(8) )

    call HistoryPut(   &
      & 'TempBasicZ',  &
      & xyz_TempBasicZ(FileXMin:FileXMax,FileYMin:FileYMax,FileZMin:FileZMax), &
      & gt_hist(8) )

    call HistoryPut(   &
      & 'PressBasicZ', &
      & xyz_PressBasicZ(FileXMin:FileXMax,FileYMin:FileYMax,FileZMin:FileZMax), &
      & gt_hist(8) )

    do s = 1, SpcNum
      call HistoryPut( &
        & trim(SpcWetSymbol(s))//'BasicZ',    &
        & xyza_MixRtBasicZ(FileXMin:FileXMax,FileYMin:FileYMax,FileZMin:FileZMax, s), &
        & gt_hist(8) )
    end do

    call HistoryPut(   &
      & 'EffMolWtBasicZ', &
      & xyz_EffMolWtBasicZ(FileXMin:FileXMax,FileYMin:FileYMax,FileZMin:FileZMax), &
      & gt_hist(8) )
    
  end subroutine HistoryFile_Open


!!!---------------------------------------------------------------------------
  subroutine HistoryFile_OutPut(   &
    & Time,                        &
    & xyz_PotTemp,                  &
    & xyz_Exner,                    &   
    & pyz_VelX,                     &
    & xqz_VelY,                     &
    & xyr_VelZ,                     &
    & xyza_MixRt,                   &
    & xyz_Km,                       &
    & xyz_Kh                        &
    )
    !
    !ͽѿΥҥȥեؤν. ϻˤȾʻΰ֤ǥץå. 
    !
    
    !⥸塼ɤ߹
    use xyz_module,   only: xyz_avr_pyz, xyz_avr_xqz, xyz_avr_xyr, &
      &                     xyz_avr_xqr, xyz_avr_pyr, xyz_avr_pqz

    use xyz_deriv_module, only : xqr_dy_xyr, xqr_dz_xqz, &
      &                          pyr_dz_pyz, pyr_dx_xyr, &
      &                          pqz_dx_xqz, pqz_dy_pyz  

    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in) :: Time
    real(DP), intent(in) :: pyz_VelX(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(in) :: xqz_VelY(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(in) :: xyr_VelZ(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(in) :: xyz_Exner(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(in) :: xyz_PotTemp(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(in) :: xyz_Km(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(in) :: xyz_Kh(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(in) :: xyza_MixRt(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)

    real(DP)             :: xyz_VelX(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP)             :: xyz_VelY(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP)             :: xyz_VelZ(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)

    real(DP)             :: xyz_VorX(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP)             :: xyz_VorY(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP)             :: xyz_VorZ(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    integer             :: s

    !----------------------------------------------------------------
    ! ʻ֤Ѵ
    !----------------------------------------------------------------
    xyz_VelX = xyz_avr_pyz( pyz_VelX )
    xyz_VelY = xyz_avr_xqz( xqz_VelY )
    xyz_VelZ = xyz_avr_xyr( xyr_VelZ )

    xyz_VorX = xyz_avr_xqr(xqr_dy_xyr( xyr_VelZ ) - xqr_dz_xqz( xqz_VelY ))
    xyz_VorY = xyz_avr_pyr(pyr_dz_pyz( pyz_VelX ) - pyr_dx_xyr( xyr_VelZ ))
    xyz_VorZ = xyz_avr_pqz(pqz_dx_xqz( xqz_VelY ) - pqz_dy_pyz( pyz_VelX ))

    !----------------------------------------------------------------
    ! ͤ
    !----------------------------------------------------------------

    do s = 1, 12 + SpcNum
      call HistoryPut( 't', Time, gt_hist(s) )
    end do
    
    call HistoryPut(  &
      & 'Exner',      &
      & xyz_Exner(FileXMin:FileXMax,FileYMin:FileYMax,FileZMin:FileZMax), &
      & gt_hist(1) )

    call HistoryPut(  &
      & 'PotTemp',    &
      & xyz_PotTemp(FileXMin:FileXMax,FileYMin:FileYMax,FileZMin:FileZMax), &
      & gt_hist(2) )

    call HistoryPut(  &
      & 'VelX',       &
      & xyz_VelX(FileXMin:FileXMax,FileYMin:FileYMax,FileZMin:FileZMax),    &
      & gt_hist(3) )

    call HistoryPut(  &
      & 'VelY',       &
      & xyz_VelY(FileXMin:FileXMax,FileYMin:FileYMax,FileZMin:FileZMax),    &
      & gt_hist(4) )
    
    call HistoryPut(  &
      & 'VelZ',       &
      & xyz_VelZ(FileXMin:FileXMax,FileYMin:FileYMax,FileZMin:FileZMax),    &
      & gt_hist(5) )

    call HistoryPut(  &
      & 'Km',         &
      & xyz_Km(FileXMin:FileXMax,FileYMin:FileYMax,FileZMin:FileZMax),      &
      & gt_hist(6) )
    
    call HistoryPut(  &
      & 'Kh',         &
      & xyz_Kh(FileXMin:FileXMax,FileYMin:FileYMax,FileZMin:FileZMax),      &
      & gt_hist(7) )

    call HistoryPut(  &
      & 'VorX',       &
      & xyz_VorX(FileXMin:FileXMax,FileYMin:FileYMax,FileZMin:FileZMax),    &
      & gt_hist(10) )

    call HistoryPut(  &
      & 'VorY',       &
      & xyz_VorY(FileXMin:FileXMax,FileYMin:FileYMax,FileZMin:FileZMax),    &
      & gt_hist(11) )
    
    call HistoryPut(  &
      & 'VorZ',       &
      & xyz_VorZ(FileXMin:FileXMax,FileYMin:FileYMax,FileZMin:FileZMax),    &
      & gt_hist(12) )
    
    do s = 1, SpcNum
      call HistoryPut(     &
        & trim(SpcWetSymbol(s)), &
        & xyza_MixRt(FileXMin:FileXMax,FileYMin:FileYMax,FileZMin:FileZMax, s), &
        & gt_hist(12+s) )
    end do

    !----------------------------------------------------------------
    ! ͤ
    !----------------------------------------------------------------
    call StorePotTempMeanXY()
    call StoreMixRtMeanXY()
    call StoreBuoyMeanXY()
    call StoreStabMeanXY()

    call HistoryPut(   &
      & 'BuoyTemp',  &
      & z_BuoyTemp(FileZMin:FileZMax), &
      & gt_hist(9) )

    call HistoryPut(   &
      & 'BuoyMolWt',  &
      & z_BuoyMolWt(FileZMin:FileZMax), &
      & gt_hist(9) )

    call HistoryPut(   &
      & 'BuoyDrag',  &
      & z_BuoyDrag(FileZMin:FileZMax), &
      & gt_hist(9) )

    call HistoryPut(   &
      & 'StabTemp',  &
      & z_StabTemp(FileZMin:FileZMax), &
      & gt_hist(9) )

    call HistoryPut(   &
      & 'StabMolWt',  &
      & z_StabMolWt(FileZMin:FileZMax), &
      & gt_hist(9) )

    call HistoryPut(   &
      & 'PotTempAdv',  &
      & z_Adv(FileZMin:FileZMax), &
      & gt_hist(9) )

    call HistoryPut(   &
      & 'PotTempTurb', &
      & z_Turb(FileZMin:FileZMax), &
      & gt_hist(9) )

    call HistoryPut(   &
      & 'PotTempDisp', &
      & z_Disp(FileZMin:FileZMax), &
      & gt_hist(9) )

    call HistoryPut(   &
      & 'PotTempDiff', &
      & z_Diff(FileZMin:FileZMax),&
      & gt_hist(9) )

    call HistoryPut(   &
      & 'PotTempRad',  &
      & z_Rad(FileZMin:FileZMax), &
      & gt_hist(9) )

    call HistoryPut(   &
      & 'PotTempCond', &
      & z_Cond(FileZMin:FileZMax), &
      & gt_hist(9) )

    call HistoryPut(   &
      & 'PotTempFlux', &
      & z_Flux(FileZMin:FileZMax), &
      & gt_hist(9) )

    call HistoryPut(   &
      & 'PotTempDamp', &
      & z_Damp(FileZMin:FileZMax), &
      & gt_hist(9) )

    call HistoryPut(   &
      & 'StabTemp',    &
      & z_StabTemp(FileZMin:FileZMax), &
      & gt_hist(9) )

    call HistoryPut(   &
      & 'StabMolWt',   &
      & z_StabMolWt(FileZMin:FileZMax), &
      & gt_hist(9) )

    do s = 1, SpcNum
      call HistoryPut(                      &
        & trim(SpcWetSymbol(s))//'_Adv',    &
        & za_Adv(FileZMin:FileZMax, s),   &
        & gt_hist(9) )

      call HistoryPut(                      &
        & trim(SpcWetSymbol(s))//'_Turb',    &
        & za_Turb(FileZMin:FileZMax, s),   &
        & gt_hist(9) )

      call HistoryPut(                      &
        & trim(SpcWetSymbol(s))//'_Diff',    &
        & za_Diff(FileZMin:FileZMax, s),   &
        & gt_hist(9) )

      call HistoryPut(                      &
        & trim(SpcWetSymbol(s))//'_Flux',    &
        & za_Flux(FileZMin:FileZMax, s),   &
        & gt_hist(9) )

      call HistoryPut(                      &
        & trim(SpcWetSymbol(s))//'_Rain',    &
        & za_Rain(FileZMin:FileZMax, s),   &
        & gt_hist(9) )

      call HistoryPut(                      &
        & trim(SpcWetSymbol(s))//'_Fill1',    &
        & za_Fill1(FileZMin:FileZMax, s),   &
        & gt_hist(9) )

      call HistoryPut(                      &
        & trim(SpcWetSymbol(s))//'_Fill2',    &
        & za_Fill2(FileZMin:FileZMax, s),   &
        & gt_hist(9) )

      call HistoryPut(                      &
        & trim(SpcWetSymbol(s))//'_Cond',    &
        & za_cond(FileZMin:FileZMax, s),   &
        & gt_hist(9) )

!      call HistoryPut(                      &
!        & trim(SpcWetSymbol(s))//'_Asln',    &
!        & za_Asln(FileZMin:FileZMax, s),   &
!        & gt_hist(9) )

    end do

  end subroutine HistoryFile_OutPut


!!!--------------------------------------------------------------------------
  subroutine HistoryFile_Close
    !
    !ҥȥեΥ
    !
    
    !ۤηػ
    implicit none

    !ѿ
    integer :: s ! 롼ź

    !եĤ
    do s = 1, FileNum
      call HistoryClose(gt_hist(s))
    end do

  end subroutine HistoryFile_Close


end module HistoryFileIO_3d
