!= Module StoreStab
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: storestab.f90,v 1.1 2009-03-05 05:39:43 yamasita Exp $ 
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!Ϥ˴ؤѻͤݴɤ뤿ѿ⥸塼
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!

module StoreStab
  !
  !Ϥѻͤݴɤ뤿ѿ⥸塼.
  !

  !⥸塼ɤ߹
  use gridset, only:   DimXMin,     & ! x β
    &                  DimXMax,     & ! x ξ
    &                  DimZMin,     & ! z β
    &                  DimZMax,     & ! z ξ
    &                  RegXMin,     & ! x ʪΰβ
    &                  RegXMax        ! x ʪΰξ
  use TimeSet, only:   TimeDisp,    & ! ϻֳִ
    &                  DelTimeLong    ! Ĺ֥ƥå

  !ۤηػ
  implicit none

  !°λ
  private

  !
  public StoreStab_Init, StoreStabMeanX, StoreStabClean
  public z_StabTemp, z_StabMolWt
  public StoreStabTemp, StoreStabMolWt

  !ѿ
  real(8), allocatable :: z_StabTemp(:)
  real(8), allocatable :: z_StabMolWt(:)
  real(8), allocatable :: xz_StabTemp(:,:)
  real(8), allocatable :: xz_StabMolWt(:,:)

  save z_StabTemp,  z_StabMolWt
  save xz_StabTemp, xz_StabMolWt

contains

  subroutine StoreStab_Init( )
    !롼

    allocate(     &
      & z_StabTemp(DimZMin:DimZMax),   & 
      & z_StabMolWt(DimZMin:DimZMax),  &
      & xz_StabTemp(DimXMin:DimXMax, DimZMin:DimZMax),  & 
      & xz_StabMolWt(DimXMin:DimXMax, DimZMin:DimZMax)  &
      &  )
    
    call StoreStabClean()

  end subroutine StoreStab_Init


  subroutine StoreStabClean( )
    !ݴɤͤΥꥢ
    
    z_StabTemp   = 0.0d0
    z_StabMolWt  = 0.0d0
    xz_StabTemp  = 0.0d0
    xz_StabMolWt = 0.0d0
    
  end subroutine StoreStabClean


  subroutine StoreStabMeanX( )
    !ݴɤͤοʿʿ
 
    real(8) :: CalNum

    CalNum = TimeDisp / DelTimeLong
   
    z_StabTemp  = a_MeanX_aa( xz_StabTemp  ) / CalNum
    z_StabMolWt = a_MeanX_aa( xz_StabMolWt ) / CalNum

  end subroutine StoreStabMeanX
  

  subroutine StoreStabTemp( xz_Work )
    !٤δͿݴ

    implicit none

    real(8), intent(in)  :: xz_Work(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: xz_Work2(DimXMin:DimXMax, DimZMin:DimZMax)
    
    xz_Work2    = xz_StabTemp + xz_Work
    xz_StabTemp = xz_Work2

  end subroutine StoreStabTemp


  subroutine StoreStabMolWt( xz_Work )
    !ʬ̤δͿݴ

    implicit none

    real(8), intent(in)  :: xz_Work(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: xz_Work2(DimXMin:DimXMax, DimZMin:DimZMax)

    xz_Work2     = xz_StabMolWt + xz_Work
    xz_StabMolWt = xz_Work2
    
  end subroutine StoreStabMolWt

  function a_MeanX_aa( var ) 
    !
    ! ʿʿͤη׻
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in)  :: var(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʿѱ黻оݤȤʤѿ
    real(8)              :: a_MeanX_aa(DimZMin:DimZMax)
                                     !ʿʿ
    
    a_MeanX_aa = sum( var(RegXMin+1:RegXMax,:), 1 ) &
      &           / real(RegXMax - RegXMin, 8) 
    
  end function a_MeanX_aa
  
  
end module StoreStab
