#!/bin/sh

vbrfix -always -makevbr "debian/tests/data/test-broken.mp3" "$AUTOPKGTEST_TMP/vbrfix-output.mp3"

# Checks if the output file contains the VBR TOC header (Xing or Info)
# This is the expected signature of a properly fixed VBR file
if grep -a -q -m1 'Xing\|Info' "$AUTOPKGTEST_TMP/vbrfix-output.mp3"; then
    echo "VBR TOC OK"
    exit 0
else
    echo "Expected VBR TOC (Xing/Info) in $AUTOPKGTEST_TMP/vbrfix-output.mp3"
    exit 1
fi
