% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg-plots.R
\docType{data}
\name{ggally_count}
\alias{ggally_count}
\alias{stat_ggally_count}
\alias{StatGGallyCount}
\alias{ggally_countDiag}
\title{Display counts of observations}
\usage{
ggally_count(data, mapping, ...)

ggally_countDiag(data, mapping, ...)
}
\arguments{
\item{data}{data set using}

\item{mapping}{aesthetics being used}

\item{...}{other arguments passed to \code{\link[ggplot2]{geom_tile}(...)}}
}
\description{
Plot the number of observations by using rectangles
with proportional areas.
}
\details{
You can adjust the size of rectangles with the \code{x.width} argument.
}
\examples{
# Small function to display plots only if it's interactive
p_ <- GGally::print_if_interactive

data(tips)
p_(ggally_count(tips, mapping = ggplot2::aes(x = smoker, y = sex)))
p_(ggally_count(tips, mapping = ggplot2::aes(x = smoker, y = sex, fill = day)))

p_(ggally_count(
  as.data.frame(Titanic),
  mapping = ggplot2::aes(x = Class, y = Survived, weight = Freq)
))
p_(ggally_count(
  as.data.frame(Titanic),
  mapping = ggplot2::aes(x = Class, y = Survived, weight = Freq),
  x.width = 0.5
))
# Small function to display plots only if it's interactive
p_ <- GGally::print_if_interactive

p_(ggally_countDiag(tips, mapping = ggplot2::aes(x = smoker)))
p_(ggally_countDiag(tips, mapping = ggplot2::aes(x = smoker, fill = sex)))
}
\author{
Joseph Larmarange
}
\keyword{datasets}
\keyword{hplot}
