% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_cauchy.R
\name{dist_cauchy}
\alias{dist_cauchy}
\title{The Cauchy distribution}
\usage{
dist_cauchy(location, scale)
}
\arguments{
\item{location, scale}{location and scale parameters.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The Cauchy distribution is the student's t distribution with one degree of
freedom. The Cauchy distribution does not have a well defined mean or
variance. Cauchy distributions often appear as priors in Bayesian contexts
due to their heavy tails.
}
\details{
We recommend reading this documentation on \href{https://pkg.mitchelloharawild.com/distributional/reference/dist_cauchy.html}{pkgdown} which renders math nicely.
\url{https://pkg.mitchelloharawild.com/distributional/reference/dist_cauchy.html}

In the following, let \eqn{X} be a Cauchy variable with mean
\verb{location =} \eqn{x_0} and \code{scale} = \eqn{\gamma}.

\strong{Support}: \eqn{R}, the set of all real numbers

\strong{Mean}: Undefined.

\strong{Variance}: Undefined.

\strong{Probability density function (p.d.f)}:

\deqn{
    f(x) = \frac{1}{\pi \gamma \left[1 + \left(\frac{x - x_0}{\gamma} \right)^2 \right]}
  }{
    f(x) = 1 / (\pi \gamma (1 + ((x - x_0) / \gamma)^2)
  }

\strong{Cumulative distribution function (c.d.f)}:

\deqn{
    F(t) = \frac{1}{\pi} \arctan \left( \frac{t - x_0}{\gamma} \right) +
      \frac{1}{2}
  }{
    F(t) = arctan((t - x_0) / \gamma) / \pi + 1/2
  }

\strong{Moment generating function (m.g.f)}:

Does not exist.
}
\examples{
dist <- dist_cauchy(location = c(0, 0, 0, -2), scale = c(0.5, 1, 2, 1))

dist
mean(dist)
variance(dist)
skewness(dist)
kurtosis(dist)

generate(dist, 10)

density(dist, 2)
density(dist, 2, log = TRUE)

cdf(dist, 4)

quantile(dist, 0.7)

}
\seealso{
\link[stats:Cauchy]{stats::Cauchy}
}
