# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.recoveryservices import RecoveryServicesClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestRecoveryServicesDeletedVaultsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(RecoveryServicesClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_deleted_vaults_list_by_subscription_id(self, resource_group):
        response = self.client.deleted_vaults.list_by_subscription_id(
            location="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_deleted_vaults_get(self, resource_group):
        response = self.client.deleted_vaults.get(
            location="str",
            deleted_vault_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_deleted_vaults_begin_undelete(self, resource_group):
        response = self.client.deleted_vaults.begin_undelete(
            location="str",
            deleted_vault_name="str",
            body={"properties": {"recoveryResourceGroupId": "str"}},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_deleted_vaults_get_operation_status(self, resource_group):
        response = self.client.deleted_vaults.get_operation_status(
            location="str",
            deleted_vault_name="str",
            operation_id="str",
        )

        # please add some check logic here by yourself
        # ...
