// SPDX-License-Identifier: Apache-2.0
// Copyright Contributors to the OpenTimelineIO project
//
// This document is automatically generated by running the `make version-map`
// make target.  It is part of the unit tests suite and should be updated
// whenever schema versions change.  If it needs to be updated, run: `make
// version-map-update` and this file should be regenerated.
//
// This maps a "Label" to a map of Schema name to Schema version. The intent is
// that these sets of schemas can be used for compatibility with future
// versions of OTIO, so that a newer version of OTIO can target a compatibility
// version of an older library.
#include "opentimelineio/typeRegistry.h"

namespace opentimelineio { namespace OPENTIMELINEIO_VERSION {

const label_to_schema_version_map CORE_VERSION_MAP{
    { "0.14.0",
      {
          { "Adapter", 1 },
          { "Clip", 1 },
          { "Composable", 1 },
          { "Composition", 1 },
          { "Effect", 1 },
          { "ExternalReference", 1 },
          { "FreezeFrame", 1 },
          { "Gap", 1 },
          { "GeneratorReference", 1 },
          { "HookScript", 1 },
          { "ImageSequenceReference", 1 },
          { "Item", 1 },
          { "LinearTimeWarp", 1 },
          { "Marker", 2 },
          { "MediaLinker", 1 },
          { "MediaReference", 1 },
          { "MissingReference", 1 },
          { "PluginManifest", 1 },
          { "SchemaDef", 1 },
          { "SerializableCollection", 1 },
          { "SerializableObject", 1 },
          { "SerializableObjectWithMetadata", 1 },
          { "Stack", 1 },
          { "TimeEffect", 1 },
          { "Timeline", 1 },
          { "Track", 1 },
          { "Transition", 1 },
          { "UnknownSchema", 1 },
      } },
    { "0.15.0",
      {
          { "Adapter", 1 },
          { "Clip", 2 },
          { "Composable", 1 },
          { "Composition", 1 },
          { "Effect", 1 },
          { "ExternalReference", 1 },
          { "FreezeFrame", 1 },
          { "Gap", 1 },
          { "GeneratorReference", 1 },
          { "HookScript", 1 },
          { "ImageSequenceReference", 1 },
          { "Item", 1 },
          { "LinearTimeWarp", 1 },
          { "Marker", 2 },
          { "MediaLinker", 1 },
          { "MediaReference", 1 },
          { "MissingReference", 1 },
          { "PluginManifest", 1 },
          { "SchemaDef", 1 },
          { "SerializableCollection", 1 },
          { "SerializableObject", 1 },
          { "SerializableObjectWithMetadata", 1 },
          { "Stack", 1 },
          { "Test", 1 },
          { "TimeEffect", 1 },
          { "Timeline", 1 },
          { "Track", 1 },
          { "Transition", 1 },
          { "UnknownSchema", 1 },
      } },
    { "0.16.0",
      {
          { "Adapter", 1 },
          { "Clip", 2 },
          { "Composable", 1 },
          { "Composition", 1 },
          { "Effect", 1 },
          { "ExternalReference", 1 },
          { "FreezeFrame", 1 },
          { "Gap", 1 },
          { "GeneratorReference", 1 },
          { "HookScript", 1 },
          { "ImageSequenceReference", 1 },
          { "Item", 1 },
          { "LinearTimeWarp", 1 },
          { "Marker", 2 },
          { "MediaLinker", 1 },
          { "MediaReference", 1 },
          { "MissingReference", 1 },
          { "PluginManifest", 1 },
          { "SchemaDef", 1 },
          { "SerializableCollection", 1 },
          { "SerializableObject", 1 },
          { "SerializableObjectWithMetadata", 1 },
          { "Stack", 1 },
          { "Test", 1 },
          { "TimeEffect", 1 },
          { "Timeline", 1 },
          { "Track", 1 },
          { "Transition", 1 },
          { "UnknownSchema", 1 },
      } },
    { "0.17.0",
      {
          { "Adapter", 1 },
          { "Clip", 2 },
          { "Composable", 1 },
          { "Composition", 1 },
          { "Effect", 1 },
          { "ExternalReference", 1 },
          { "FreezeFrame", 1 },
          { "Gap", 1 },
          { "GeneratorReference", 1 },
          { "HookScript", 1 },
          { "ImageSequenceReference", 1 },
          { "Item", 1 },
          { "LinearTimeWarp", 1 },
          { "Marker", 2 },
          { "MediaLinker", 1 },
          { "MediaReference", 1 },
          { "MissingReference", 1 },
          { "PluginManifest", 1 },
          { "SchemaDef", 1 },
          { "SerializableCollection", 1 },
          { "SerializableObject", 1 },
          { "SerializableObjectWithMetadata", 1 },
          { "Stack", 1 },
          { "Test", 1 },
          { "TimeEffect", 1 },
          { "Timeline", 1 },
          { "Track", 1 },
          { "Transition", 1 },
          { "UnknownSchema", 1 },
      } },
    { "0.18.0",
      {
          { "Adapter", 1 },
          { "Clip", 2 },
          { "Composable", 1 },
          { "Composition", 1 },
          { "Effect", 1 },
          { "ExternalReference", 1 },
          { "FreezeFrame", 1 },
          { "Gap", 1 },
          { "GeneratorReference", 1 },
          { "HookScript", 1 },
          { "ImageSequenceReference", 1 },
          { "Item", 1 },
          { "LinearTimeWarp", 1 },
          { "Marker", 2 },
          { "MediaLinker", 1 },
          { "MediaReference", 1 },
          { "MissingReference", 1 },
          { "PluginManifest", 1 },
          { "SchemaDef", 1 },
          { "SerializableCollection", 1 },
          { "SerializableObject", 1 },
          { "SerializableObjectWithMetadata", 1 },
          { "Stack", 1 },
          { "Test", 1 },
          { "TimeEffect", 1 },
          { "Timeline", 1 },
          { "Track", 1 },
          { "Transition", 1 },
          { "UnknownSchema", 1 },
      } },
    // {next}
};

}} // namespace opentimelineio::OPENTIMELINEIO_VERSION
