-- This file is automatically generated using maintenance/generateSchemaSql.php.
-- Source: db_patches/tables.json
-- Do not modify this file directly.
-- See https://www.mediawiki.org/wiki/Manual:Schema_changes
CREATE TABLE /*_*/abuse_filter (
  af_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
  af_pattern BLOB NOT NULL,
  af_actor BIGINT UNSIGNED NOT NULL,
  af_timestamp BLOB NOT NULL,
  af_enabled SMALLINT DEFAULT 1 NOT NULL,
  af_comments BLOB DEFAULT NULL,
  af_public_comments BLOB DEFAULT NULL,
  af_hidden SMALLINT DEFAULT 0 NOT NULL,
  af_hit_count BIGINT DEFAULT 0 NOT NULL,
  af_throttled SMALLINT DEFAULT 0 NOT NULL,
  af_deleted SMALLINT DEFAULT 0 NOT NULL,
  af_actions VARCHAR(255) DEFAULT '' NOT NULL,
  af_global SMALLINT DEFAULT 0 NOT NULL,
  af_group BLOB DEFAULT 'default' NOT NULL
);

CREATE INDEX af_actor ON /*_*/abuse_filter (af_actor);

CREATE INDEX af_group_enabled ON /*_*/abuse_filter (af_group, af_enabled, af_id);


CREATE TABLE /*_*/abuse_filter_action (
  afa_filter BIGINT UNSIGNED NOT NULL,
  afa_consequence VARCHAR(255) NOT NULL,
  afa_parameters BLOB NOT NULL,
  PRIMARY KEY(afa_filter, afa_consequence)
);

CREATE INDEX afa_consequence ON /*_*/abuse_filter_action (afa_consequence);


CREATE TABLE /*_*/abuse_filter_log (
  afl_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
  afl_global SMALLINT NOT NULL,
  afl_filter_id BIGINT UNSIGNED NOT NULL,
  afl_user BIGINT UNSIGNED NOT NULL,
  afl_user_text BLOB NOT NULL,
  afl_ip VARCHAR(255) NOT NULL,
  afl_action BLOB NOT NULL,
  afl_actions BLOB NOT NULL,
  afl_var_dump BLOB NOT NULL,
  afl_timestamp BLOB NOT NULL,
  afl_namespace INTEGER NOT NULL,
  afl_title BLOB NOT NULL,
  afl_wiki BLOB DEFAULT NULL,
  afl_deleted SMALLINT DEFAULT 0 NOT NULL,
  afl_patrolled_by INTEGER UNSIGNED DEFAULT 0 NOT NULL,
  afl_rev_id INTEGER UNSIGNED DEFAULT NULL
);

CREATE INDEX afl_filter_timestamp_full ON /*_*/abuse_filter_log (
  afl_global, afl_filter_id, afl_timestamp
);

CREATE INDEX afl_user_timestamp ON /*_*/abuse_filter_log (
  afl_user, afl_user_text, afl_timestamp
);

CREATE INDEX afl_timestamp ON /*_*/abuse_filter_log (afl_timestamp);

CREATE INDEX afl_page_timestamp ON /*_*/abuse_filter_log (
  afl_namespace, afl_title, afl_timestamp
);

CREATE INDEX afl_ip_timestamp ON /*_*/abuse_filter_log (afl_ip, afl_timestamp);

CREATE INDEX afl_rev_id ON /*_*/abuse_filter_log (afl_rev_id);

CREATE INDEX afl_wiki_timestamp ON /*_*/abuse_filter_log (afl_wiki, afl_timestamp);


CREATE TABLE /*_*/abuse_filter_history (
  afh_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
  afh_filter BIGINT UNSIGNED NOT NULL,
  afh_actor BIGINT UNSIGNED NOT NULL,
  afh_timestamp BLOB NOT NULL,
  afh_pattern BLOB NOT NULL,
  afh_comments BLOB NOT NULL,
  afh_flags BLOB NOT NULL,
  afh_public_comments BLOB DEFAULT NULL,
  afh_actions BLOB DEFAULT NULL,
  afh_deleted SMALLINT DEFAULT 0 NOT NULL,
  afh_changed_fields VARCHAR(255) DEFAULT '' NOT NULL,
  afh_group BLOB DEFAULT NULL
);

CREATE INDEX afh_filter ON /*_*/abuse_filter_history (afh_filter);

CREATE INDEX afh_actor ON /*_*/abuse_filter_history (afh_actor);

CREATE INDEX afh_timestamp ON /*_*/abuse_filter_history (afh_timestamp);
