# Copyright © The Debusine Developers
# See the AUTHORS file at the top-level directory of this distribution
#
# This file is part of Debusine. It is subject to the license terms
# in the LICENSE file found in the top-level directory of this
# distribution. No part of Debusine, including this file, may be copied,
# modified, propagated, or distributed except according to the terms
# contained in the LICENSE file.

"""Debusine CLI commands."""

from debusine.client.commands.base import Command

# Commandss need to be imported in order to be available to cli.py
# They are registered via Command.__init_subclass__.
#
# Command groups are shown in command line help in the order they have been
# registered, so header sorting is disabled here.

# isort: off
import debusine.client.commands.setup  # noqa: F401
import debusine.client.commands.workspaces  # noqa: F401
import debusine.client.commands.collections  # noqa: F401
import debusine.client.commands.workflow_templates  # noqa: F401
import debusine.client.commands.workflows  # noqa: F401
import debusine.client.commands.work_requests  # noqa: F401
import debusine.client.commands.artifacts  # noqa: F401
import debusine.client.commands.assets  # noqa: F401
import debusine.client.commands.task_config  # noqa: F401
import debusine.client.commands.archives  # noqa: F401

# isort: on

__all__ = ["Command"]
