set(PLATFORM_LINUX FALSE)
set(PLATFORM_MAC FALSE)
set(PLATFORM_WIN FALSE)
set(PLATFORM_ANDROID FALSE)
set(PLATFORM_IPHONE FALSE)
set(PLATFORM_DESKTOP FALSE)

if ("${CMAKE_SYSTEM_NAME}" STREQUAL "Linux")
  set(PLATFORM_LINUX TRUE)
  set(PLATFORM_DESKTOP TRUE)
elseif ("${CMAKE_SYSTEM_NAME}" STREQUAL "Darwin")
  set(PLATFORM_MAC TRUE)
  set(PLATFORM_DESKTOP TRUE)
elseif ("${CMAKE_SYSTEM_NAME}" STREQUAL "Windows")
  set(PLATFORM_WIN TRUE)
  set(PLATFORM_DESKTOP TRUE)
elseif ("${CMAKE_SYSTEM_NAME}" STREQUAL "Android")
  set(PLATFORM_ANDROID TRUE)
elseif ("${CMAKE_SYSTEM_NAME}" STREQUAL "iOS")
  set(PLATFORM_IPHONE TRUE)
else ()
  message(FATAL_ERROR "Unsupported platform: ${CMAKE_SYSTEM_NAME}")
endif ()
