Author: Andreas Beckmann <anbe@debian.org>
Description: fix LLVMSPIRVOpts.h/LLVMSPIRVExtensions.inc inclusion

--- a/options.h
+++ b/options.h
@@ -27,7 +27,11 @@ Copyright (c) Intel Corporation (2009-20
 #include "llvm/Option/ArgList.h"
 #include "llvm/Option/Option.h"
 #include "clang/Basic/OpenCLOptions.h"
+#ifdef USE_PREBUILT_LLVM
+#include "LLVMSPIRVLib/LLVMSPIRVOpts.h"
+#else // USE_PREBUILT_LLVM
 #include "LLVMSPIRVOpts.h"
+#endif // USE_PREBUILT_LLVM
 
 #include <list>
 
--- a/options_compile.cpp
+++ b/options_compile.cpp
@@ -71,7 +71,11 @@ static int parseSPVExtOption(
 #define _STRINGIFY(X) #X
 #define STRINGIFY(X) _STRINGIFY(X)
 #define EXT(X) ExtensionNamesMap[STRINGIFY(X)] = SPIRV::ExtensionID::X;
+#ifdef USE_PREBUILT_LLVM
+#include "LLVMSPIRVLib/LLVMSPIRVExtensions.inc"
+#else // USE_PREBUILT_LLVM
 #include "LLVMSPIRVExtensions.inc"
+#endif // USE_PREBUILT_LLVM
 #undef EXT
 #undef STRINGIFY
 #undef _STRINGIFY
