const tests = [
  [-0x8000000000000000n, 0n, 1n],
  [-0x7fffffffffffffffn, 0n, 1n],
  [-0x7ffffffffffffffen, 0n, 1n],
  [-0x100000001n, 0n, 1n],
  [-0x100000000n, 0n, 1n],
  [-0xffffffffn, 0n, 1n],
  [-0xfffffffen, 0n, 1n],
  [-0x80000001n, 0n, 1n],
  [-0x80000000n, 0n, 1n],
  [-0x7fffffffn, 0n, 1n],
  [-0x7ffffffen, 0n, 1n],
  [-9n, 0n, 1n],
  [-8n, 0n, 1n],
  [-7n, 0n, 1n],
  [-6n, 0n, 1n],
  [-5n, 0n, 1n],
  [-4n, 0n, 1n],
  [-3n, 0n, 1n],
  [-2n, 0n, 1n],
  [-1n, 0n, 1n],
  [0n, 0n, 1n],
  [1n, 0n, 1n],
  [2n, 0n, 1n],
  [3n, 0n, 1n],
  [4n, 0n, 1n],
  [5n, 0n, 1n],
  [6n, 0n, 1n],
  [7n, 0n, 1n],
  [8n, 0n, 1n],
  [9n, 0n, 1n],
  [0x7ffffffen, 0n, 1n],
  [0x7fffffffn, 0n, 1n],
  [0x80000000n, 0n, 1n],
  [0x80000001n, 0n, 1n],
  [0xfffffffen, 0n, 1n],
  [0xffffffffn, 0n, 1n],
  [0x100000000n, 0n, 1n],
  [0x100000001n, 0n, 1n],
  [0x7ffffffffffffffen, 0n, 1n],
  [0x7fffffffffffffffn, 0n, 1n],
  [-0x8000000000000000n, 1n, -0x8000000000000000n],
  [-0x7fffffffffffffffn, 1n, -0x7fffffffffffffffn],
  [-0x7ffffffffffffffen, 1n, -0x7ffffffffffffffen],
  [-0x100000001n, 1n, -0x100000001n],
  [-0x100000000n, 1n, -0x100000000n],
  [-0xffffffffn, 1n, -0xffffffffn],
  [-0xfffffffen, 1n, -0xfffffffen],
  [-0x80000001n, 1n, -0x80000001n],
  [-0x80000000n, 1n, -0x80000000n],
  [-0x7fffffffn, 1n, -0x7fffffffn],
  [-0x7ffffffen, 1n, -0x7ffffffen],
  [-9n, 1n, -9n],
  [-8n, 1n, -8n],
  [-7n, 1n, -7n],
  [-6n, 1n, -6n],
  [-5n, 1n, -5n],
  [-4n, 1n, -4n],
  [-3n, 1n, -3n],
  [-2n, 1n, -2n],
  [-1n, 1n, -1n],
  [0n, 1n, 0n],
  [1n, 1n, 1n],
  [2n, 1n, 2n],
  [3n, 1n, 3n],
  [4n, 1n, 4n],
  [5n, 1n, 5n],
  [6n, 1n, 6n],
  [7n, 1n, 7n],
  [8n, 1n, 8n],
  [9n, 1n, 9n],
  [0x7ffffffen, 1n, 0x7ffffffen],
  [0x7fffffffn, 1n, 0x7fffffffn],
  [0x80000000n, 1n, 0x80000000n],
  [0x80000001n, 1n, 0x80000001n],
  [0xfffffffen, 1n, 0xfffffffen],
  [0xffffffffn, 1n, 0xffffffffn],
  [0x100000000n, 1n, 0x100000000n],
  [0x100000001n, 1n, 0x100000001n],
  [0x7ffffffffffffffen, 1n, 0x7ffffffffffffffen],
  [0x7fffffffffffffffn, 1n, 0x7fffffffffffffffn],
  [-0x80000001n, 2n, 0x4000000100000001n],
  [-0x80000000n, 2n, 0x4000000000000000n],
  [-0x7fffffffn, 2n, 0x3fffffff00000001n],
  [-0x7ffffffen, 2n, 0x3ffffffe00000004n],
  [-9n, 2n, 0x51n],
  [-8n, 2n, 0x40n],
  [-7n, 2n, 0x31n],
  [-6n, 2n, 0x24n],
  [-5n, 2n, 0x19n],
  [-4n, 2n, 0x10n],
  [-3n, 2n, 9n],
  [-2n, 2n, 4n],
  [-1n, 2n, 1n],
  [0n, 2n, 0n],
  [1n, 2n, 1n],
  [2n, 2n, 4n],
  [3n, 2n, 9n],
  [4n, 2n, 0x10n],
  [5n, 2n, 0x19n],
  [6n, 2n, 0x24n],
  [7n, 2n, 0x31n],
  [8n, 2n, 0x40n],
  [9n, 2n, 0x51n],
  [0x7ffffffen, 2n, 0x3ffffffe00000004n],
  [0x7fffffffn, 2n, 0x3fffffff00000001n],
  [0x80000000n, 2n, 0x4000000000000000n],
  [0x80000001n, 2n, 0x4000000100000001n],
  [-9n, 3n, -0x2d9n],
  [-8n, 3n, -0x200n],
  [-7n, 3n, -0x157n],
  [-6n, 3n, -0xd8n],
  [-5n, 3n, -0x7dn],
  [-4n, 3n, -0x40n],
  [-3n, 3n, -0x1bn],
  [-2n, 3n, -8n],
  [-1n, 3n, -1n],
  [0n, 3n, 0n],
  [1n, 3n, 1n],
  [2n, 3n, 8n],
  [3n, 3n, 0x1bn],
  [4n, 3n, 0x40n],
  [5n, 3n, 0x7dn],
  [6n, 3n, 0xd8n],
  [7n, 3n, 0x157n],
  [8n, 3n, 0x200n],
  [9n, 3n, 0x2d9n],
  [-9n, 4n, 0x19a1n],
  [-8n, 4n, 0x1000n],
  [-7n, 4n, 0x961n],
  [-6n, 4n, 0x510n],
  [-5n, 4n, 0x271n],
  [-4n, 4n, 0x100n],
  [-3n, 4n, 0x51n],
  [-2n, 4n, 0x10n],
  [-1n, 4n, 1n],
  [0n, 4n, 0n],
  [1n, 4n, 1n],
  [2n, 4n, 0x10n],
  [3n, 4n, 0x51n],
  [4n, 4n, 0x100n],
  [5n, 4n, 0x271n],
  [6n, 4n, 0x510n],
  [7n, 4n, 0x961n],
  [8n, 4n, 0x1000n],
  [9n, 4n, 0x19a1n],
  [-4n, 0x1fn, -0x4000000000000000n],
  [-3n, 0x1fn, -0x231c54b5f6a2bn],
  [-2n, 0x1fn, -0x80000000n],
  [-1n, 0x1fn, -1n],
  [0n, 0x1fn, 0n],
  [1n, 0x1fn, 1n],
  [2n, 0x1fn, 0x80000000n],
  [3n, 0x1fn, 0x231c54b5f6a2bn],
  [4n, 0x1fn, 0x4000000000000000n],
  [-3n, 0x20n, 0x6954fe21e3e81n],
  [-2n, 0x20n, 0x100000000n],
  [-1n, 0x20n, 1n],
  [0n, 0x20n, 0n],
  [1n, 0x20n, 1n],
  [2n, 0x20n, 0x100000000n],
  [3n, 0x20n, 0x6954fe21e3e81n],
  [-2n, 0x3fn, -0x8000000000000000n],
  [-1n, 0x3fn, -1n],
  [0n, 0x3fn, 0n],
  [1n, 0x3fn, 1n],
  [-1n, 0x40n, 1n],
  [0n, 0x40n, 0n],
  [1n, 0x40n, 1n],
];

// Cases not covered above.
tests.push(
  // 0 ** (2**31)
  // 0 ** (2**32)
  // 0 ** (2**63)
  // 0 ** (2**64)
  [0n, 0x7fffffffn, 0n],
  [0n, 0x80000000n, 0n],
  [0n, 0x80000001n, 0n],
  [0n, 0xffffffffn, 0n],
  [0n, 0x100000000n, 0n],
  [0n, 0x100000001n, 0n],
  [0n, 0x7fffffffffffffffn, 0n],

  // 1 ** (2**31)
  // 1 ** (2**32)
  // 1 ** (2**63)
  // 1 ** (2**64)
  [1n, 0x7fffffffn, 1n],
  [1n, 0x80000000n, 1n],
  [1n, 0x80000001n, 1n],
  [1n, 0xffffffffn, 1n],
  [1n, 0x100000000n, 1n],
  [1n, 0x100000001n, 1n],
  [1n, 0x7fffffffffffffffn, 1n],

  // -1 ** (2**31)
  // -1 ** (2**32)
  // -1 ** (2**63)
  // -1 ** (2**64)
  [-1n, 0x7fffffffn, -1n],
  [-1n, 0x80000000n, 1n],
  [-1n, 0x80000001n, -1n],
  [-1n, 0xffffffffn, -1n],
  [-1n, 0x100000000n, 1n],
  [-1n, 0x100000001n, -1n],
  [-1n, 0x7fffffffffffffffn, -1n],
);

function f(tests) {
  for (let test of tests) {
    let lhs = test[0], rhs = test[1], expected = test[2];
    assertEq(BigInt.asIntN(64, lhs), lhs);
    assertEq(BigInt.asIntN(64, rhs), rhs);
    assertEq(BigInt.asIntN(64, expected), expected);

    assertEq(lhs ** rhs, expected);
  }
}

for (let i = 0; i < 10; ++i) {
  f(tests);
}
