//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
	"net/http"
	"net/url"
	"regexp"
)

// WorkspaceSettingsServer is a fake server for instances of the armsecurity.WorkspaceSettingsClient type.
type WorkspaceSettingsServer struct {
	// Create is the fake for method WorkspaceSettingsClient.Create
	// HTTP status codes to indicate success: http.StatusOK
	Create func(ctx context.Context, workspaceSettingName string, workspaceSetting armsecurity.WorkspaceSetting, options *armsecurity.WorkspaceSettingsClientCreateOptions) (resp azfake.Responder[armsecurity.WorkspaceSettingsClientCreateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method WorkspaceSettingsClient.Delete
	// HTTP status codes to indicate success: http.StatusNoContent
	Delete func(ctx context.Context, workspaceSettingName string, options *armsecurity.WorkspaceSettingsClientDeleteOptions) (resp azfake.Responder[armsecurity.WorkspaceSettingsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method WorkspaceSettingsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, workspaceSettingName string, options *armsecurity.WorkspaceSettingsClientGetOptions) (resp azfake.Responder[armsecurity.WorkspaceSettingsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method WorkspaceSettingsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armsecurity.WorkspaceSettingsClientListOptions) (resp azfake.PagerResponder[armsecurity.WorkspaceSettingsClientListResponse])

	// Update is the fake for method WorkspaceSettingsClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, workspaceSettingName string, workspaceSetting armsecurity.WorkspaceSetting, options *armsecurity.WorkspaceSettingsClientUpdateOptions) (resp azfake.Responder[armsecurity.WorkspaceSettingsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewWorkspaceSettingsServerTransport creates a new instance of WorkspaceSettingsServerTransport with the provided implementation.
// The returned WorkspaceSettingsServerTransport instance is connected to an instance of armsecurity.WorkspaceSettingsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewWorkspaceSettingsServerTransport(srv *WorkspaceSettingsServer) *WorkspaceSettingsServerTransport {
	return &WorkspaceSettingsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armsecurity.WorkspaceSettingsClientListResponse]](),
	}
}

// WorkspaceSettingsServerTransport connects instances of armsecurity.WorkspaceSettingsClient to instances of WorkspaceSettingsServer.
// Don't use this type directly, use NewWorkspaceSettingsServerTransport instead.
type WorkspaceSettingsServerTransport struct {
	srv          *WorkspaceSettingsServer
	newListPager *tracker[azfake.PagerResponder[armsecurity.WorkspaceSettingsClientListResponse]]
}

// Do implements the policy.Transporter interface for WorkspaceSettingsServerTransport.
func (w *WorkspaceSettingsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "WorkspaceSettingsClient.Create":
		resp, err = w.dispatchCreate(req)
	case "WorkspaceSettingsClient.Delete":
		resp, err = w.dispatchDelete(req)
	case "WorkspaceSettingsClient.Get":
		resp, err = w.dispatchGet(req)
	case "WorkspaceSettingsClient.NewListPager":
		resp, err = w.dispatchNewListPager(req)
	case "WorkspaceSettingsClient.Update":
		resp, err = w.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (w *WorkspaceSettingsServerTransport) dispatchCreate(req *http.Request) (*http.Response, error) {
	if w.srv.Create == nil {
		return nil, &nonRetriableError{errors.New("fake for method Create not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/workspaceSettings/(?P<workspaceSettingName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armsecurity.WorkspaceSetting](req)
	if err != nil {
		return nil, err
	}
	workspaceSettingNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceSettingName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.Create(req.Context(), workspaceSettingNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WorkspaceSetting, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WorkspaceSettingsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if w.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/workspaceSettings/(?P<workspaceSettingName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	workspaceSettingNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceSettingName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.Delete(req.Context(), workspaceSettingNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WorkspaceSettingsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if w.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/workspaceSettings/(?P<workspaceSettingName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	workspaceSettingNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceSettingName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.Get(req.Context(), workspaceSettingNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WorkspaceSetting, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WorkspaceSettingsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := w.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/workspaceSettings`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := w.srv.NewListPager(nil)
		newListPager = &resp
		w.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armsecurity.WorkspaceSettingsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		w.newListPager.remove(req)
	}
	return resp, nil
}

func (w *WorkspaceSettingsServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if w.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/workspaceSettings/(?P<workspaceSettingName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armsecurity.WorkspaceSetting](req)
	if err != nil {
		return nil, err
	}
	workspaceSettingNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceSettingName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.Update(req.Context(), workspaceSettingNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WorkspaceSetting, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
