//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsecurity_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e716082ac474f182e2220e4f38f1d6191e7636cf/specification/security/resource-manager/Microsoft.Security/preview/2020-01-01-preview/examples/Connectors/GetListConnectorSubscription_example.json
func ExampleAccountConnectorsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAccountConnectorsClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ConnectorSettingList = armsecurity.ConnectorSettingList{
		// 	Value: []*armsecurity.ConnectorSetting{
		// 		{
		// 			Name: to.Ptr("aws_dev1"),
		// 			Type: to.Ptr("Microsoft.Security/connectors"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/connectors/aws_dev1"),
		// 			Properties: &armsecurity.ConnectorSettingProperties{
		// 				AuthenticationDetails: &armsecurity.AwsCredsAuthenticationDetailsProperties{
		// 					AuthenticationProvisioningState: to.Ptr(armsecurity.AuthenticationProvisioningStateValid),
		// 					AuthenticationType: to.Ptr(armsecurity.AuthenticationTypeAwsCreds),
		// 					GrantedPermissions: []*armsecurity.PermissionProperty{
		// 						to.Ptr(armsecurity.PermissionPropertyAWSAWSSecurityHubReadOnlyAccess),
		// 						to.Ptr(armsecurity.PermissionPropertyAWSSecurityAudit),
		// 						to.Ptr(armsecurity.PermissionPropertyAWSAmazonSSMAutomationRole)},
		// 						AccountID: to.Ptr("922315681122"),
		// 						AwsAccessKeyID: to.Ptr(""),
		// 						AwsSecretAccessKey: to.Ptr(""),
		// 					},
		// 					HybridComputeSettings: &armsecurity.HybridComputeSettingsProperties{
		// 						AutoProvision: to.Ptr(armsecurity.AutoProvisionOn),
		// 						HybridComputeProvisioningState: to.Ptr(armsecurity.HybridComputeProvisioningStateValid),
		// 						ProxyServer: &armsecurity.ProxyServerProperties{
		// 							IP: to.Ptr("287.221.107.152"),
		// 							Port: to.Ptr("34"),
		// 						},
		// 						Region: to.Ptr("West US 2"),
		// 						ResourceGroupName: to.Ptr("AwsConnectorRG"),
		// 						ServicePrincipal: &armsecurity.ServicePrincipalProperties{
		// 							ApplicationID: to.Ptr("ad9bcd79-be9c-45ab-abd8-80ca1654a7d1"),
		// 						},
		// 					},
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("aws_dev2"),
		// 				Type: to.Ptr("Microsoft.Security/connectors"),
		// 				ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/connectors/aws_dev2"),
		// 				Properties: &armsecurity.ConnectorSettingProperties{
		// 					AuthenticationDetails: &armsecurity.AwAssumeRoleAuthenticationDetailsProperties{
		// 						AuthenticationProvisioningState: to.Ptr(armsecurity.AuthenticationProvisioningStateValid),
		// 						AuthenticationType: to.Ptr(armsecurity.AuthenticationTypeAwsAssumeRole),
		// 						GrantedPermissions: []*armsecurity.PermissionProperty{
		// 							to.Ptr(armsecurity.PermissionPropertyAWSAWSSecurityHubReadOnlyAccess),
		// 							to.Ptr(armsecurity.PermissionPropertyAWSSecurityAudit),
		// 							to.Ptr(armsecurity.PermissionPropertyAWSAmazonSSMAutomationRole)},
		// 							AccountID: to.Ptr("81231569658"),
		// 							AwsAssumeRoleArn: to.Ptr("arn:aws:iam::81231569658:role/AscConnector"),
		// 							AwsExternalID: to.Ptr("20ff7fc3-e762-44dd-bd96-b71116dcdc23"),
		// 						},
		// 						HybridComputeSettings: &armsecurity.HybridComputeSettingsProperties{
		// 							AutoProvision: to.Ptr(armsecurity.AutoProvisionOn),
		// 							HybridComputeProvisioningState: to.Ptr(armsecurity.HybridComputeProvisioningStateValid),
		// 							ProxyServer: &armsecurity.ProxyServerProperties{
		// 								IP: to.Ptr("167.210.187.160"),
		// 								Port: to.Ptr("34"),
		// 							},
		// 							Region: to.Ptr("West US 2"),
		// 							ResourceGroupName: to.Ptr("AwsConnectorRG"),
		// 							ServicePrincipal: &armsecurity.ServicePrincipalProperties{
		// 								ApplicationID: to.Ptr("ad9bcd79-be9c-45ab-abd8-80ca1654a7d1"),
		// 							},
		// 						},
		// 					},
		// 				},
		// 				{
		// 					Name: to.Ptr("gcp_dev"),
		// 					Type: to.Ptr("Microsoft.Security/connectors"),
		// 					ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/connectors/gcp_dev"),
		// 					Properties: &armsecurity.ConnectorSettingProperties{
		// 						AuthenticationDetails: &armsecurity.GcpCredentialsDetailsProperties{
		// 							AuthenticationProvisioningState: to.Ptr(armsecurity.AuthenticationProvisioningStateValid),
		// 							AuthenticationType: to.Ptr(armsecurity.AuthenticationTypeGcpCredentials),
		// 							GrantedPermissions: []*armsecurity.PermissionProperty{
		// 								to.Ptr(armsecurity.PermissionPropertyGCPSecurityCenterAdminViewer)},
		// 								Type: to.Ptr(""),
		// 								AuthProviderX509CertURL: to.Ptr(""),
		// 								AuthURI: to.Ptr(""),
		// 								ClientEmail: to.Ptr(""),
		// 								ClientID: to.Ptr(""),
		// 								ClientX509CertURL: to.Ptr(""),
		// 								OrganizationID: to.Ptr("AscDemoOrg"),
		// 								PrivateKey: to.Ptr(""),
		// 								PrivateKeyID: to.Ptr(""),
		// 								ProjectID: to.Ptr(""),
		// 								TokenURI: to.Ptr(""),
		// 							},
		// 							HybridComputeSettings: &armsecurity.HybridComputeSettingsProperties{
		// 								AutoProvision: to.Ptr(armsecurity.AutoProvisionOff),
		// 								HybridComputeProvisioningState: to.Ptr(armsecurity.HybridComputeProvisioningStateInvalid),
		// 								Region: to.Ptr(""),
		// 								ResourceGroupName: to.Ptr(""),
		// 							},
		// 						},
		// 				}},
		// 			}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e716082ac474f182e2220e4f38f1d6191e7636cf/specification/security/resource-manager/Microsoft.Security/preview/2020-01-01-preview/examples/Connectors/GetConnectorSubscription_example.json
func ExampleAccountConnectorsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountConnectorsClient().Get(ctx, "aws_dev1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ConnectorSetting = armsecurity.ConnectorSetting{
	// 	Name: to.Ptr("aws_dev1"),
	// 	Type: to.Ptr("Microsoft.Security/connectors"),
	// 	ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/connectors/aws_dev1"),
	// 	Properties: &armsecurity.ConnectorSettingProperties{
	// 		AuthenticationDetails: &armsecurity.AwsCredsAuthenticationDetailsProperties{
	// 			AuthenticationProvisioningState: to.Ptr(armsecurity.AuthenticationProvisioningStateValid),
	// 			AuthenticationType: to.Ptr(armsecurity.AuthenticationTypeAwsCreds),
	// 			GrantedPermissions: []*armsecurity.PermissionProperty{
	// 				to.Ptr(armsecurity.PermissionPropertyAWSAWSSecurityHubReadOnlyAccess),
	// 				to.Ptr(armsecurity.PermissionPropertyAWSSecurityAudit),
	// 				to.Ptr(armsecurity.PermissionPropertyAWSAmazonSSMAutomationRole)},
	// 				AccountID: to.Ptr("922315681122"),
	// 				AwsAccessKeyID: to.Ptr(""),
	// 				AwsSecretAccessKey: to.Ptr(""),
	// 			},
	// 			HybridComputeSettings: &armsecurity.HybridComputeSettingsProperties{
	// 				AutoProvision: to.Ptr(armsecurity.AutoProvisionOn),
	// 				HybridComputeProvisioningState: to.Ptr(armsecurity.HybridComputeProvisioningStateValid),
	// 				ProxyServer: &armsecurity.ProxyServerProperties{
	// 					IP: to.Ptr("287.221.107.152"),
	// 					Port: to.Ptr("34"),
	// 				},
	// 				Region: to.Ptr("West US 2"),
	// 				ResourceGroupName: to.Ptr("AwsConnectorRG"),
	// 				ServicePrincipal: &armsecurity.ServicePrincipalProperties{
	// 					ApplicationID: to.Ptr("ad9bcd79-be9c-45ab-abd8-80ca1654a7d1"),
	// 				},
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e716082ac474f182e2220e4f38f1d6191e7636cf/specification/security/resource-manager/Microsoft.Security/preview/2020-01-01-preview/examples/Connectors/CreateUpdateAwsAssumeRoleConnectorSubscription_example.json
func ExampleAccountConnectorsClient_CreateOrUpdate_awsAssumeRoleCreateACloudAccountConnectorForASubscription() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountConnectorsClient().CreateOrUpdate(ctx, "aws_dev2", armsecurity.ConnectorSetting{
		Properties: &armsecurity.ConnectorSettingProperties{
			AuthenticationDetails: &armsecurity.AwAssumeRoleAuthenticationDetailsProperties{
				AuthenticationType: to.Ptr(armsecurity.AuthenticationTypeAwsAssumeRole),
				AwsAssumeRoleArn:   to.Ptr("arn:aws:iam::81231569658:role/AscConnector"),
				AwsExternalID:      to.Ptr("20ff7fc3-e762-44dd-bd96-b71116dcdc23"),
			},
			HybridComputeSettings: &armsecurity.HybridComputeSettingsProperties{
				AutoProvision: to.Ptr(armsecurity.AutoProvisionOn),
				ProxyServer: &armsecurity.ProxyServerProperties{
					IP:   to.Ptr("167.220.197.140"),
					Port: to.Ptr("34"),
				},
				Region:            to.Ptr("West US 2"),
				ResourceGroupName: to.Ptr("AwsConnectorRG"),
				ServicePrincipal: &armsecurity.ServicePrincipalProperties{
					ApplicationID: to.Ptr("ad9bcd79-be9c-45ab-abd8-80ca1654a7d1"),
					Secret:        to.Ptr("<secret>"),
				},
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ConnectorSetting = armsecurity.ConnectorSetting{
	// 	Name: to.Ptr("aws_dev2"),
	// 	Type: to.Ptr("Microsoft.Security/connectors"),
	// 	ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/connectors/aws_dev2"),
	// 	Properties: &armsecurity.ConnectorSettingProperties{
	// 		AuthenticationDetails: &armsecurity.AwAssumeRoleAuthenticationDetailsProperties{
	// 			AuthenticationProvisioningState: to.Ptr(armsecurity.AuthenticationProvisioningStateValid),
	// 			AuthenticationType: to.Ptr(armsecurity.AuthenticationTypeAwsAssumeRole),
	// 			GrantedPermissions: []*armsecurity.PermissionProperty{
	// 				to.Ptr(armsecurity.PermissionPropertyAWSAWSSecurityHubReadOnlyAccess),
	// 				to.Ptr(armsecurity.PermissionPropertyAWSSecurityAudit),
	// 				to.Ptr(armsecurity.PermissionPropertyAWSAmazonSSMAutomationRole)},
	// 				AccountID: to.Ptr("81231569658"),
	// 				AwsAssumeRoleArn: to.Ptr("arn:aws:iam::81231569658:role/AscConnector"),
	// 				AwsExternalID: to.Ptr("20ff7fc3-e762-44dd-bd96-b71116dcdc23"),
	// 			},
	// 			HybridComputeSettings: &armsecurity.HybridComputeSettingsProperties{
	// 				AutoProvision: to.Ptr(armsecurity.AutoProvisionOn),
	// 				HybridComputeProvisioningState: to.Ptr(armsecurity.HybridComputeProvisioningStateValid),
	// 				ProxyServer: &armsecurity.ProxyServerProperties{
	// 					IP: to.Ptr("167.220.197.140"),
	// 					Port: to.Ptr("34"),
	// 				},
	// 				Region: to.Ptr("West US 2"),
	// 				ResourceGroupName: to.Ptr("AwsConnectorRG"),
	// 				ServicePrincipal: &armsecurity.ServicePrincipalProperties{
	// 					ApplicationID: to.Ptr("ad9bcd79-be9c-45ab-abd8-80ca1654a7d1"),
	// 				},
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e716082ac474f182e2220e4f38f1d6191e7636cf/specification/security/resource-manager/Microsoft.Security/preview/2020-01-01-preview/examples/Connectors/CreateUpdateAwsCredConnectorSubscription_example.json
func ExampleAccountConnectorsClient_CreateOrUpdate_awsCredCreateACloudAccountConnectorForASubscription() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountConnectorsClient().CreateOrUpdate(ctx, "aws_dev1", armsecurity.ConnectorSetting{
		Properties: &armsecurity.ConnectorSettingProperties{
			AuthenticationDetails: &armsecurity.AwsCredsAuthenticationDetailsProperties{
				AuthenticationType: to.Ptr(armsecurity.AuthenticationTypeAwsCreds),
				AwsAccessKeyID:     to.Ptr("AKIARPZCNODDNAEQFSOE"),
				AwsSecretAccessKey: to.Ptr("<awsSecretAccessKey>"),
			},
			HybridComputeSettings: &armsecurity.HybridComputeSettingsProperties{
				AutoProvision: to.Ptr(armsecurity.AutoProvisionOn),
				ProxyServer: &armsecurity.ProxyServerProperties{
					IP:   to.Ptr("167.220.197.140"),
					Port: to.Ptr("34"),
				},
				Region:            to.Ptr("West US 2"),
				ResourceGroupName: to.Ptr("AwsConnectorRG"),
				ServicePrincipal: &armsecurity.ServicePrincipalProperties{
					ApplicationID: to.Ptr("ad9bcd79-be9c-45ab-abd8-80ca1654a7d1"),
					Secret:        to.Ptr("<secret>"),
				},
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ConnectorSetting = armsecurity.ConnectorSetting{
	// 	Name: to.Ptr("aws_dev1"),
	// 	Type: to.Ptr("Microsoft.Security/connectors"),
	// 	ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/connectors/aws_dev1"),
	// 	Properties: &armsecurity.ConnectorSettingProperties{
	// 		AuthenticationDetails: &armsecurity.AwsCredsAuthenticationDetailsProperties{
	// 			AuthenticationProvisioningState: to.Ptr(armsecurity.AuthenticationProvisioningStateValid),
	// 			AuthenticationType: to.Ptr(armsecurity.AuthenticationTypeAwsCreds),
	// 			GrantedPermissions: []*armsecurity.PermissionProperty{
	// 				to.Ptr(armsecurity.PermissionPropertyAWSAWSSecurityHubReadOnlyAccess),
	// 				to.Ptr(armsecurity.PermissionPropertyAWSSecurityAudit),
	// 				to.Ptr(armsecurity.PermissionPropertyAWSAmazonSSMAutomationRole)},
	// 				AccountID: to.Ptr("922315681122"),
	// 				AwsAccessKeyID: to.Ptr(""),
	// 				AwsSecretAccessKey: to.Ptr(""),
	// 			},
	// 			HybridComputeSettings: &armsecurity.HybridComputeSettingsProperties{
	// 				AutoProvision: to.Ptr(armsecurity.AutoProvisionOn),
	// 				HybridComputeProvisioningState: to.Ptr(armsecurity.HybridComputeProvisioningStateValid),
	// 				ProxyServer: &armsecurity.ProxyServerProperties{
	// 					IP: to.Ptr("287.221.107.152"),
	// 					Port: to.Ptr("34"),
	// 				},
	// 				Region: to.Ptr("West US 2"),
	// 				ResourceGroupName: to.Ptr("AwsConnectorRG"),
	// 				ServicePrincipal: &armsecurity.ServicePrincipalProperties{
	// 					ApplicationID: to.Ptr("ad9bcd79-be9c-45ab-abd8-80ca1654a7d1"),
	// 				},
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e716082ac474f182e2220e4f38f1d6191e7636cf/specification/security/resource-manager/Microsoft.Security/preview/2020-01-01-preview/examples/Connectors/CreateUpdateGcpCredentialsConnectorSubscription_example.json
func ExampleAccountConnectorsClient_CreateOrUpdate_gcpCredentialsCreateACloudAccountConnectorForASubscription() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountConnectorsClient().CreateOrUpdate(ctx, "gcp_dev", armsecurity.ConnectorSetting{
		Properties: &armsecurity.ConnectorSettingProperties{
			AuthenticationDetails: &armsecurity.GcpCredentialsDetailsProperties{
				AuthenticationType:      to.Ptr(armsecurity.AuthenticationTypeGcpCredentials),
				Type:                    to.Ptr("service_account"),
				AuthProviderX509CertURL: to.Ptr("https://www.googleapis.com/oauth2/v1/certs"),
				AuthURI:                 to.Ptr("https://accounts.google.com/o/oauth2/auth"),
				ClientEmail:             to.Ptr("asc-135@asc-project-1234.iam.gserviceaccount.com"),
				ClientID:                to.Ptr("105889053725632919854"),
				ClientX509CertURL:       to.Ptr("https://www.googleapis.com/robot/v1/metadata/x509/asc-135%40asc-project-1234.iam.gserviceaccount.com"),
				OrganizationID:          to.Ptr("AscDemoOrg"),
				PrivateKey:              to.Ptr("******"),
				PrivateKeyID:            to.Ptr("6efg587hra2568as34d22326b044cc20dc2af"),
				ProjectID:               to.Ptr("asc-project-1234"),
				TokenURI:                to.Ptr("https://oauth2.googleapis.com/token"),
			},
			HybridComputeSettings: &armsecurity.HybridComputeSettingsProperties{
				AutoProvision: to.Ptr(armsecurity.AutoProvisionOff),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ConnectorSetting = armsecurity.ConnectorSetting{
	// 	Name: to.Ptr("gcp_dev"),
	// 	Type: to.Ptr("Microsoft.Security/connectors"),
	// 	ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/connectors/gcp_dev"),
	// 	Properties: &armsecurity.ConnectorSettingProperties{
	// 		AuthenticationDetails: &armsecurity.GcpCredentialsDetailsProperties{
	// 			AuthenticationProvisioningState: to.Ptr(armsecurity.AuthenticationProvisioningStateValid),
	// 			AuthenticationType: to.Ptr(armsecurity.AuthenticationTypeGcpCredentials),
	// 			GrantedPermissions: []*armsecurity.PermissionProperty{
	// 				to.Ptr(armsecurity.PermissionPropertyGCPSecurityCenterAdminViewer)},
	// 				Type: to.Ptr(""),
	// 				AuthProviderX509CertURL: to.Ptr(""),
	// 				AuthURI: to.Ptr(""),
	// 				ClientEmail: to.Ptr(""),
	// 				ClientID: to.Ptr(""),
	// 				ClientX509CertURL: to.Ptr(""),
	// 				OrganizationID: to.Ptr("AscDemoOrg"),
	// 				PrivateKey: to.Ptr(""),
	// 				PrivateKeyID: to.Ptr(""),
	// 				ProjectID: to.Ptr(""),
	// 				TokenURI: to.Ptr(""),
	// 			},
	// 			HybridComputeSettings: &armsecurity.HybridComputeSettingsProperties{
	// 				AutoProvision: to.Ptr(armsecurity.AutoProvisionOff),
	// 				HybridComputeProvisioningState: to.Ptr(armsecurity.HybridComputeProvisioningStateInvalid),
	// 				Region: to.Ptr(""),
	// 				ResourceGroupName: to.Ptr(""),
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e716082ac474f182e2220e4f38f1d6191e7636cf/specification/security/resource-manager/Microsoft.Security/preview/2020-01-01-preview/examples/Connectors/DeleteConnectorSubscription_example.json
func ExampleAccountConnectorsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewAccountConnectorsClient().Delete(ctx, "aws_dev1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}
