#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2024 Fabien Givors <captnfab@debian-facile.org>
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2025 BetaRays <array@dotslashplay.it>
set -o errexit

###
# The Planet Crafter
# send your bug reports to bugs@dotslashplay.it
###

script_version=20251021.1

PLAYIT_COMPATIBILITY_LEVEL='2.31'

GAME_ID='the-planet-crafter'
GAME_NAME='The Planet Crafter'

ARCHIVE_BASE_4_NAME='setup_the_planet_crafter_v1.526-patched_(85593).exe'
ARCHIVE_BASE_4_MD5='cc90f9a4d4e95b69b6689238c7c43d27'
ARCHIVE_BASE_4_TYPE='innosetup'
ARCHIVE_BASE_4_PART1_NAME='setup_the_planet_crafter_v1.526-patched_(85593)-1.bin'
ARCHIVE_BASE_4_PART1_MD5='8972c93594ef6e7d54251a5f734f8f21'
ARCHIVE_BASE_4_SIZE='5008383'
ARCHIVE_BASE_4_VERSION='1.526-patched-gog85593'
ARCHIVE_BASE_4_URL='https://www.gog.com/game/the_planet_crafter'

ARCHIVE_BASE_3_NAME='setup_the_planet_crafter_v1.526_(82806).exe'
ARCHIVE_BASE_3_MD5='541aa5a29a0e2ad63553fd584f9a9559'
ARCHIVE_BASE_3_TYPE='innosetup'
ARCHIVE_BASE_3_PART1_NAME='setup_the_planet_crafter_v1.526_(82806)-1.bin'
ARCHIVE_BASE_3_PART1_MD5='c70496e52d29f6f0441882be26b3ba00'
ARCHIVE_BASE_3_SIZE='5007444'
ARCHIVE_BASE_3_VERSION='1.526-gog82806'
ARCHIVE_BASE_3_URL='https://www.gog.com/game/the_planet_crafter'

ARCHIVE_BASE_2_NAME='setup_the_planet_crafter_v1.518.1_(82237).exe'
ARCHIVE_BASE_2_MD5='5547f8cebf7a1e8c9e9d28e5c7e1bba4'
ARCHIVE_BASE_2_TYPE='innosetup'
ARCHIVE_BASE_2_PART1_NAME='setup_the_planet_crafter_v1.518.1_(82237)-1.bin'
ARCHIVE_BASE_2_PART1_MD5='21522bd690b0e19579555cd60cc4ea48'
ARCHIVE_BASE_2_SIZE='4961016'
ARCHIVE_BASE_2_VERSION='1.518.1-gog82237'

ARCHIVE_BASE_1_NAME='setup_the_planet_crafter_v1.410_(79912).exe'
ARCHIVE_BASE_1_MD5='99a76531a684432048b1e1de9ad47293'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_PART1_NAME='setup_the_planet_crafter_v1.410_(79912)-1.bin'
ARCHIVE_BASE_1_PART1_MD5='dca216a778df5323b2952a9f53c49bf7'
ARCHIVE_BASE_1_SIZE='4090924'
ARCHIVE_BASE_1_VERSION='1.410-gog79912'

ARCHIVE_BASE_0_NAME='setup_the_planet_crafter_v1.005_(73160).exe'
ARCHIVE_BASE_0_MD5='60ece555d812bed78d38f571dc2ddaf8'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_the_planet_crafter_v1.005_(73160)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='d0435d2e30c97cf7f1d5fa24e4290e3a'
ARCHIVE_BASE_0_PART2_NAME='setup_the_planet_crafter_v1.005_(73160)-2.bin'
ARCHIVE_BASE_0_PART2_MD5='22f21c99887225b814a2d2e55eb007c4'
ARCHIVE_BASE_0_SIZE='8000000'
ARCHIVE_BASE_0_VERSION='1.005-gog73160'

UNITY3D_NAME='planet crafter'

CONTENT_PATH_DEFAULT='.'

WINE_DIRECT3D_RENDERER='dxvk'
WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/LocalLow/MijuGames/Planet Crafter'
## TODO: Check is these fonts are required with current WINE
WINE_WINETRICKS_VERBS='corefonts'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_GSTREAMER_PLUGINS='
video/quicktime, variant=(string)iso'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
