/*
 * Decompiled with CFR 0.152.
 */
package spec.jbb;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import spec.jbb.Address;
import spec.jbb.Infrastructure;
import spec.jbb.JBBDataStorage;
import spec.jbb.JBBSortedStorage;
import spec.jbb.JBButil;
import spec.jbb.NewOrder;
import spec.jbb.Order;

public class District {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2000-2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,(C) Copyright IBM Corp., 1996 - 2005All rights reserved,Licensed Materials - Property of SPEC";
    private JBBSortedStorage orderTable;
    private JBBSortedStorage newOrderTable;
    private String name;
    private Address address;
    private BigDecimal taxRate;
    private BigDecimal ytd;
    private int nextOrder;
    private byte districtId;
    private short warehouseId;
    private int oldestOrder;

    public District(short s, byte by) {
        this.districtId = by;
        this.warehouseId = s;
        this.address = new Address();
        this.nextOrder = 1;
        this.orderTable = Infrastructure.createSortedStorage();
        this.newOrderTable = Infrastructure.createSortedStorage();
    }

    public int getId() {
        return this.districtId;
    }

    public BigDecimal getTaxRate() {
        return this.taxRate;
    }

    public Address getAddress() {
        return this.address;
    }

    public synchronized int lastOrderId() {
        int n = this.nextOrder - 1;
        return n;
    }

    public synchronized int nextOrderId() {
        int n = this.nextOrder++;
        return n;
    }

    public synchronized void display() {
        System.out.println("District display ****************************");
        System.out.println("districtId is ======== " + this.districtId);
        System.out.println("warehouseID == " + this.warehouseId);
        System.out.println("name is   ==== " + this.name);
        this.address.display();
        System.out.println("*********************************************");
    }

    public synchronized void receivePayment(BigDecimal bigDecimal) {
        this.ytd = this.ytd.add(bigDecimal);
    }

    public synchronized void setUsingRandom() {
        this.name = new String(JBButil.create_random_a_string(6, 10, this.warehouseId));
        this.address.setUsingRandom(this.warehouseId);
        float f = JBButil.create_random_float_val_return(0.0f, 0.2f, 1.0E-4f, this.warehouseId);
        this.taxRate = new BigDecimal(f).setScale(4, 4);
        this.ytd = BigDecimal.valueOf(3000000L, 2);
    }

    public synchronized void addOrder(Order order) {
        this.orderTable.put(order.getId(), order);
    }

    public synchronized Order retrieveOrder(Order order) {
        return (Order)this.orderTable.get(order.getId());
    }

    public synchronized void removeOldestOrder() {
        ++this.oldestOrder;
        boolean bl = this.orderTable.deleteFirstEntities();
        if (!bl) {
            JBButil.getLog().warning("District.removeOldestOrder failed for orderId=" + this.oldestOrder + ", districtId=" + this.districtId + ", warehouseId=" + this.warehouseId);
        }
    }

    public synchronized void removeOldOrders(int n) {
        int n2 = this.orderTable.size();
        boolean bl = this.orderTable.deleteFirstEntities(n2 - n);
        if (bl) {
            this.oldestOrder += n2 - n;
        } else {
            JBButil.getLog().warning("District.removeOldOrders failed for , districtId=" + this.districtId + ", warehouseId=" + this.warehouseId + ", size=" + this.orderTable.size());
        }
        if (JBButil.getLog().isLoggable(Level.FINEST)) {
            Logger logger = JBButil.getLog();
            logger.finest("SteadyState trimmed orderTable to " + this.orderTable.size() + " elements, from " + n2 + " elements");
            logger.finest("  for districtId=" + this.districtId + " warehouseId=" + this.warehouseId);
        }
    }

    public synchronized void removeOldNewOrders(int n) {
        int n2 = this.newOrderTable.size();
        boolean bl = this.newOrderTable.deleteFirstEntities(n2 - n);
        if (!bl) {
            JBButil.getLog().warning("District.removeOldNewOrders failed for , districtId=" + this.districtId + ", warehouseId=" + this.warehouseId + ", size=" + this.newOrderTable.size());
        }
        if (JBButil.getLog().isLoggable(Level.FINEST)) {
            Logger logger = JBButil.getLog();
            logger.finest("SteadyState trimmed newOrderTable to " + this.newOrderTable.size() + " elements, from " + n2 + " elements");
            logger.finest("  for districtId=" + this.districtId + ", warehouseId=" + this.warehouseId);
        }
    }

    public synchronized void addNewOrder(NewOrder newOrder) {
        this.newOrderTable.put(newOrder.getId(), newOrder);
    }

    public synchronized NewOrder removeFirstNewOrder() {
        NewOrder newOrder = null;
        newOrder = (NewOrder)this.newOrderTable.removeFirstElem();
        return newOrder;
    }

    public synchronized JBBDataStorage getOrderTable() {
        return this.orderTable;
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized Iterator newOrderIter() {
        return this.newOrderTable.elements();
    }

    public synchronized NewOrder removeNewOrder(Object object) {
        NewOrder newOrder = (NewOrder)this.newOrderTable.get(object);
        return (NewOrder)this.newOrderTable.remove(object);
    }
}

