# Contributing

If you wish to contribute to Cacti, the process is very easy.  The first step
is to register for a GitHub account.  Once you have a GitHub account, you then
need to learn about their community guidelines and familiarize yourself with
how to create a pull request.  Pull requests are how we accept submissions from
the community for Code and Documentation.

Pull requests are always created against the **develop** branch, unless
otherwise instructed. Detailed guide on how to create Pull Requests on GitHub
under [Standards-Patch-Creation](Standards-Patch-Creation.md) section.

## Code Contributions

There are a few key points.  First, if you want a feature, or find an issue,
and the forums are leading you to GitHub, create an Issue, this issue can be
tagged either an enhancement or a bug.  Regardless of what it is, if you think
you can create a fix for that, prepare a pull request with your changes.

When your code is submitted, basic checks are performed to ensure that the code
is runnable but this does not guarantee that it will work.  Please ensure that
you have been able to test your code before submitting a fix.

In addition to testing, please try to keep your code to Cacti's standards:

- [Code](Standards-Code-Formatting.md)

- [File System Layout](Standards-FileSystem-Layout.md)

- [SQL styling](Standards-SQL.md)

  and

- [Security](Standards-Security.md)

You can view all the repositories of code that Cacti publicly shares on GitHub
at this [link](https://github.com/Cacti), or to go specifically to the [Cacti
source code](https://github.com/Cacti/cacti), [issue
tracker](https://github.com/Cacti/cacti/issues), and [internal
Wiki](https://github.com/Cacti/cacti/wiki)

## Documentation Contributions

As with Code contributions, if you wish to enhance or correct an issue with the
current documentation, create an issue with the details and then link the Pull
Request to it.

Unlike the various standards for coding depending on the type of code you are
attempting to contribute, there is only one set of [Documentation
Standards](Standards-Documentation.md) at this time.  Please try to ensure that
your code confirms to this, as there are strict checks in place which will fail
your submission if it fails these standards.

---
<copy>Copyright (c) 2004-2023 The Cacti Group</copy>
