libNVVM and NVVM IR Samples
===========================

Introduction
------------

The following samples illustrate the use of libNVVM and NVVM IR.

- cuda-shared-memory - A directory containing NVVM IR programs that demonstrate
  CUDA 'shared' memory usage.

- cuda-c-linking - Builds an NVVM IR program using the LLVM IR build APIs. It
  will link the generated PTX with a PTX generated by nvcc, and launch the
  linked program on GPU using CUDA driver APIs.

- device-side-launch - Demonstrates launching a kernel within a kernel (CUDA
  dynamic parallelism).

- ptxgen -A standalone NVVM IR program to PTX compiler. It will link the
  libDevice library with the input NVVM IR program, verify the IR for
  conformance to the NVVM IR specification, and then generate PTX.

- simple - Reads in a NVVM IR program from a file, compiles it to PTX, and
  launches the program on GPU using CUDA driver APIs.

- syscalls - A directory containing NVVM IR programs that demonstrate the use of
  device side malloc/free/vprintf functions.

- uvmlite - Demonstrates the use of unified virtual memory.

Steps for Building the Samples
------------------------------

The following environment variables can be used to control the build
process for the samples.  If not specified, CUDA_HOME will be derived by
looking for nvcc in your PATH.  CMake will try to automatically
identify all of these paths.

- CUDA_HOME    : The directory where the CUDA toolkit is installed,
               e.g., /usr/local/cuda.
- LIBNVVM_HOME : The directory where libNVVM components are located.
               e.g., $CUDA_HOME/nvvm.
- LLVM_HOME    : This should point to the install directory if you built llvm
               locally.  This is only required for building the cuda-c-linking
               sample (see the cuda-c-linking note below).

After setting the environment variables and adding the path to the CMake tool
via the PATH environment variable, sample script utils/build.sh (for Linux) or
utils/build.bat (for Windows) may be executed. This script will use build
directory "build" to build the samples, and then install them in the "install"
directory.

If you chose to build using Visual Studio and its integrated CMake support,
then simply run "Build All" and "Install libnvvm-samples."  The installed
samples will be copied to out/install/\<build architecture\>/bin/

Alternatively, we provide a Makefile that will automatically build these
samples on Linux as part of the toplevel cuda-samples build.  Windows users
should build manually via utils/built.bat or Visual Studio's CMake integration.

A Note About the cuda-c-linking Sample
--------------------------------------

This sample requires a development package (or locally-built) LLVM library
between versions 7 to 14 inclusive.  LLVM 15 defaults to using opaque pointers,
which are currently not supported in libNVVM.

The LLVM_HOME environment variable is required for users who wish to build the
cuda-c-linking sample and have a locally built copy of LLVM that they wish to
use.  That sample requires the development package of LLVM with the LLVM header
files and libraries.

If the LLVM dependencies are met, the user can enable the building of this
sample by setting the CMake variable "ENABLE_CUDA_C_LINKING_SAMPLE" from either
the command line invocation of CMake or by modifying the CMakeLists.txt in this
directory.

Windows users should download LLVM 14 sources from llvm.org and build+install
LLVM locally.  Using the llvm.org provided Windows installer lacks some of
the required components the cuda-c-linking sample depends on.

For Ubuntu users, the "llvm-dev" package contains the LLVM headers and libraries
this sample requires, the user should not have to explicitly define an LLVM_HOME
in this case.

Windows users will want to build this sample using the same CMake build mode
as they built LLVM with.  For instance if they built LLVM in Release mode,
then this sample should also be built in Release mode. The utils/build.bat can
be updated to reflect this: Add "-DCMAKE_BUILD_TYPE=Release" to the CMake
invocation.
