#
# tmpk01.rb
#

require "numru/dcl"

include NumRu
include Math

nx = 101
ny = 101
thres = 1

dx = 6.2832/(nx - 1).to_f
dy = 6.2832/(ny - 1).to_f
arrow_thres = 1.0

skip = (ARGV[0] || (puts ' SKIP NUM (I)  ? ;'; gets)).to_i

x = NArray.sfloat(nx).indgen*dx
y = NArray.sfloat(ny).indgen*dy

u = NArray.sfloat(nx,ny)
v = NArray.sfloat(nx,ny)

ny.times do |j|
  nx.times do |i|
    u[i,j] = -cos(y[j])
    v[i,j] =  cos(x[i])
  end
end

iws = (ARGV[1] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws

DCL::grfrm
DCL::grswnd(x[0], x[nx-1], y[0], y[ny-1])
DCL::uspfit
DCL::grstrf
DCL::usdaxs

DCL::tmiset('SKIPINTV', skip)
DCL::tmstlc(x, y, u, v)

DCL::grcls

