!----------------------------------------------------------------------
! COPYRIGHT (c) 2007-2010 SPMODEL Development Group. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  au_module ƥȥץ
!
!  2002/08/20  ݹ
!      2007/10/24  ݹ  顼åɲ
!      2010/12/21  ʿ dc_test Ѥ褦˽
!
program au_intavr

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use au_module
  implicit none

 !---- ֲ ----
  integer, parameter :: im=32            ! ʻ
  integer, parameter :: km=32,lm=2       ! ȿ

 !---- ѿ ----
  real(8)            :: g_Data(0:im)        ! ʻҥǡ
  real(8)            :: ag_Data(lm,0:im)    ! ʻҥǡ

 !---- ɸѿʤ ----
  real(8), parameter :: ra=3.0D0

  ! Ƚ
  integer, parameter :: check_digits = 3
  integer, parameter :: ignore = -3

  integer :: i

 !---------------- ɸͤ ---------------------

  call MessageNotify('M','au_test_intavr',    &
    'au_module Integral, Averaging function tests')


  do i=1,2
    call au_Initial(im,km/i,ra,(/0,0/))               ! ڥȥ
    
    g_Data = 1.0D0 - g_R
    
    call check0d(Int_g(g_Data), (ra-ra**2/2), 'Int_g')
    call check0d(Avr_g(g_Data), (1-ra/2),     'Avr_g')
    
    ag_Data(1,:) = g_R**2
    ag_Data(2,:) = g_R**5
    
    call check1d(a_Int_ag(ag_Data), (/ra**3/3,ra**6/6/), 'a_Int_ag')
    call check1d(a_Avr_ag(ag_Data), (/ra**2/3,ra**5/6/), 'a_Avr_ag')
        
  end do
  
  call MessageNotify('M','au_test_intavr',    &
    'au_module Integral, Averaging function tests succeeded!')
  
contains

  subroutine check1d(var1,sol1,funcname)  ! ͤ eps ʾ var Ǥ
    real(8) :: var1(:)                    ! Ƚꤹ
    real(8) :: sol1(:)                    ! 
    character(len=*), optional :: funcname
    
    call AssertEqual(&
      message= funcname,                                        &
      answer = sol1,                                            &
      check = var1,                                             &
      significant_digits = check_digits, ignore_digits = ignore &
      )
  end subroutine check1d
  
  subroutine check0d(var,sol,funcname)   ! var ͤ eps ʾȽ
    real(8) :: var                       ! Ƚꤹ
    real(8) :: sol                       ! 
    real(8) :: vartmp(1)                 ! Ƚꤹ
    real(8) :: soltmp(1)                 ! 
    character(len=*), optional :: funcname

    vartmp = var
    soltmp = sol

    call check1d(vartmp, soltmp, funcname)
  end subroutine check0d

end program au_intavr
