/*
 * $Id$
 */

#include <stdio.h>
#include "ruby.h"
#include "narray.h"
#include "cdcl.h"

/* for compatibility with ruby 1.6 */
#ifndef StringValuePtr
#define StringValuePtr(s) STR2CSTR(s)
#endif

#define DFLT_SIZE 32

#ifndef NARRAY_BIGMEM
typedef int    na_shape_t;
#endif

extern char    *dcl_obj2ccharary(VALUE, int, int);
extern integer *dcl_obj2cintegerary(VALUE);
extern real    *dcl_obj2crealary(VALUE);
extern complex *dcl_obj2ccomplexary(VALUE);
extern logical *dcl_obj2clogicalary(VALUE);

extern VALUE dcl_ccharary2obj(char *, int, int);
extern VALUE dcl_cintegerary2obj(integer *, na_shape_t, int, na_shape_t *);
extern VALUE dcl_crealary2obj(real *, na_shape_t, int, na_shape_t *);
/* extern VALUE dcl_ccomplexary2obj(complex *, int, char *); */
extern VALUE dcl_clogicalary2obj(logical *, na_shape_t, int, na_shape_t *);

extern void dcl_freeccharary(char *);
extern void dcl_freecintegerary(integer *);
extern void dcl_freecrealary(real *);
extern void dcl_freeccomplexary(complex *);
extern void dcl_freeclogicalary(logical *);

/* for functions which return real */
/* fnclib */
extern real rd2r_(real *);
extern real rr2d_(real *);
extern real rexp_(real *, integer *, integer *);
extern real rfpi_(void);
extern real rmod_(real *, real *);
/* gnmlib */
extern real rgnlt_(real *);
extern real rgnle_(real *);
extern real rgngt_(real *);
extern real rgnge_(real *);
/* rfalib */
extern real rmax_(real *, integer *, integer *);
extern real rmin_(real *, integer *, integer *);
extern real rsum_(real *, integer *, integer *);
extern real rave_(real *, integer *, integer *);
extern real rvar_(real *, integer *, integer *);
extern real rstd_(real *, integer *, integer *);
extern real rrms_(real *, integer *, integer *);
extern real ramp_(real *, integer *, integer *);
/* rfblib */
extern real rprd_(real *, real *, integer *, integer *, integer *);
extern real rcov_(real *, real *, integer *, integer *, integer *);
extern real rcor_(real *, real *, integer *, integer *, integer *);


extern VALUE mDCL;

static VALUE
dcl_imax(obj, ix, n, jx)
    VALUE obj, ix, n, jx;
{
    integer *i_ix;
    integer i_n;
    integer i_jx;
    integer o_rtn_val;
    VALUE rtn_val;

    if ((TYPE(ix) == T_BIGNUM) || (TYPE(ix) == T_FIXNUM)) {
      ix = rb_Array(ix);
    }
    /* if ((TYPE(ix) != T_ARRAY) && 
           (rb_obj_is_kind_of(ix, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_ix = dcl_obj2cintegerary(ix);


    o_rtn_val = imax__(i_ix, &i_n, &i_jx);

    rtn_val = INT2NUM(o_rtn_val);

    dcl_freecintegerary(i_ix);

    return rtn_val;

}

static VALUE
dcl_imax0(obj, ix, n, jx)
    VALUE obj, ix, n, jx;
{
    integer *i_ix;
    integer i_n;
    integer i_jx;
    integer o_rtn_val;
    VALUE rtn_val;

    if ((TYPE(ix) == T_BIGNUM) || (TYPE(ix) == T_FIXNUM)) {
      ix = rb_Array(ix);
    }
    /* if ((TYPE(ix) != T_ARRAY) && 
           (rb_obj_is_kind_of(ix, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_ix = dcl_obj2cintegerary(ix);


    o_rtn_val = imax0__(i_ix, &i_n, &i_jx);

    rtn_val = INT2NUM(o_rtn_val);

    dcl_freecintegerary(i_ix);

    return rtn_val;

}

static VALUE
dcl_imax1(obj, ix, n, jx)
    VALUE obj, ix, n, jx;
{
    integer *i_ix;
    integer i_n;
    integer i_jx;
    integer o_rtn_val;
    VALUE rtn_val;

    if ((TYPE(ix) == T_BIGNUM) || (TYPE(ix) == T_FIXNUM)) {
      ix = rb_Array(ix);
    }
    /* if ((TYPE(ix) != T_ARRAY) && 
           (rb_obj_is_kind_of(ix, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_ix = dcl_obj2cintegerary(ix);


    o_rtn_val = imax1__(i_ix, &i_n, &i_jx);

    rtn_val = INT2NUM(o_rtn_val);

    dcl_freecintegerary(i_ix);

    return rtn_val;

}

static VALUE
dcl_imin(obj, ix, n, jx)
    VALUE obj, ix, n, jx;
{
    integer *i_ix;
    integer i_n;
    integer i_jx;
    integer o_rtn_val;
    VALUE rtn_val;

    if ((TYPE(ix) == T_BIGNUM) || (TYPE(ix) == T_FIXNUM)) {
      ix = rb_Array(ix);
    }
    /* if ((TYPE(ix) != T_ARRAY) && 
           (rb_obj_is_kind_of(ix, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_ix = dcl_obj2cintegerary(ix);


    o_rtn_val = imin__(i_ix, &i_n, &i_jx);

    rtn_val = INT2NUM(o_rtn_val);

    dcl_freecintegerary(i_ix);

    return rtn_val;

}

static VALUE
dcl_imin0(obj, ix, n, jx)
    VALUE obj, ix, n, jx;
{
    integer *i_ix;
    integer i_n;
    integer i_jx;
    integer o_rtn_val;
    VALUE rtn_val;

    if ((TYPE(ix) == T_BIGNUM) || (TYPE(ix) == T_FIXNUM)) {
      ix = rb_Array(ix);
    }
    /* if ((TYPE(ix) != T_ARRAY) && 
           (rb_obj_is_kind_of(ix, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_ix = dcl_obj2cintegerary(ix);


    o_rtn_val = imin0__(i_ix, &i_n, &i_jx);

    rtn_val = INT2NUM(o_rtn_val);

    dcl_freecintegerary(i_ix);

    return rtn_val;

}

static VALUE
dcl_imin1(obj, ix, n, jx)
    VALUE obj, ix, n, jx;
{
    integer *i_ix;
    integer i_n;
    integer i_jx;
    integer o_rtn_val;
    VALUE rtn_val;

    if ((TYPE(ix) == T_BIGNUM) || (TYPE(ix) == T_FIXNUM)) {
      ix = rb_Array(ix);
    }
    /* if ((TYPE(ix) != T_ARRAY) && 
           (rb_obj_is_kind_of(ix, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_ix = dcl_obj2cintegerary(ix);


    o_rtn_val = imin1__(i_ix, &i_n, &i_jx);

    rtn_val = INT2NUM(o_rtn_val);

    dcl_freecintegerary(i_ix);

    return rtn_val;

}

static VALUE
dcl_isum(obj, ix, n, jx)
    VALUE obj, ix, n, jx;
{
    integer *i_ix;
    integer i_n;
    integer i_jx;
    integer o_rtn_val;
    VALUE rtn_val;

    if ((TYPE(ix) == T_BIGNUM) || (TYPE(ix) == T_FIXNUM)) {
      ix = rb_Array(ix);
    }
    /* if ((TYPE(ix) != T_ARRAY) && 
           (rb_obj_is_kind_of(ix, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_ix = dcl_obj2cintegerary(ix);


    o_rtn_val = isum__(i_ix, &i_n, &i_jx);

    rtn_val = INT2NUM(o_rtn_val);

    dcl_freecintegerary(i_ix);

    return rtn_val;

}

static VALUE
dcl_isum0(obj, ix, n, jx)
    VALUE obj, ix, n, jx;
{
    integer *i_ix;
    integer i_n;
    integer i_jx;
    integer o_rtn_val;
    VALUE rtn_val;

    if ((TYPE(ix) == T_BIGNUM) || (TYPE(ix) == T_FIXNUM)) {
      ix = rb_Array(ix);
    }
    /* if ((TYPE(ix) != T_ARRAY) && 
           (rb_obj_is_kind_of(ix, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_ix = dcl_obj2cintegerary(ix);


    o_rtn_val = isum0__(i_ix, &i_n, &i_jx);

    rtn_val = INT2NUM(o_rtn_val);

    dcl_freecintegerary(i_ix);

    return rtn_val;

}

static VALUE
dcl_isum1(obj, ix, n, jx)
    VALUE obj, ix, n, jx;
{
    integer *i_ix;
    integer i_n;
    integer i_jx;
    integer o_rtn_val;
    VALUE rtn_val;

    if ((TYPE(ix) == T_BIGNUM) || (TYPE(ix) == T_FIXNUM)) {
      ix = rb_Array(ix);
    }
    /* if ((TYPE(ix) != T_ARRAY) && 
           (rb_obj_is_kind_of(ix, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_ix = dcl_obj2cintegerary(ix);


    o_rtn_val = isum1__(i_ix, &i_n, &i_jx);

    rtn_val = INT2NUM(o_rtn_val);

    dcl_freecintegerary(i_ix);

    return rtn_val;

}
void
init_math1_ifalib(mDCL)
VALUE mDCL;
{
    rb_define_module_function(mDCL, "imax", dcl_imax, 3);
    rb_define_module_function(mDCL, "imax0", dcl_imax0, 3);
    rb_define_module_function(mDCL, "imax1", dcl_imax1, 3);
    rb_define_module_function(mDCL, "imin", dcl_imin, 3);
    rb_define_module_function(mDCL, "imin0", dcl_imin0, 3);
    rb_define_module_function(mDCL, "imin1", dcl_imin1, 3);
    rb_define_module_function(mDCL, "isum", dcl_isum, 3);
    rb_define_module_function(mDCL, "isum0", dcl_isum0, 3);
    rb_define_module_function(mDCL, "isum1", dcl_isum1, 3);
}
