!----------------------------------------------------------------------
!     Copyright (c) 2010--2012 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  wtq_module_sjpack ƥȥץ
!
!      ȥݥƥ󥷥ζ
!
!  2010/04/18  ݹ   wt_module_sjpack_test_torvelbc.f90 ¤
!      2011/09/14  ݹ   MPI 
!      2011/09/14  ݹ   wtq_mpi_module Ѥ˲¤
!      2012/04/02  ݹ   wtq_mpi_module_sjpack Ѥ˲¤
!      2012/04/03  ݹ   wtq_module_sjpack Ѥ˲¤
!      2012/04/03  ݹ   wtq_module Ѥ˲¤
!      2012/07/08  ݹ   Tau ˡѤ˲¤
!
program wtq_sjpack_torvelbc_tau_wt

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use wtq_module_sjpack

  implicit none

  integer,parameter  :: im=32, jm=16         ! ʻ(, , ư)
  integer,parameter  :: kmo=16, kmi=10       ! ʻ(ư, ư)
  integer,parameter  :: nm=10                ! ȿ(ʿ)
  integer,parameter  :: lmo=16, lmi=16       ! ȿ(ư, ư)
  real(8),parameter  :: ri=0.5, ro=1.5       ! ⳰Ⱦ

  real(8), dimension(0:im-1,1:jm,0:kmo)     :: xyz_Toroidal
  real(8), dimension((nm+1)**2,0:lmo)       :: wt_Toroidal
  real(8), dimension(0:im-1,1:jm,0:kmo)     :: xyz_Toroidal_sol
  real(8), dimension(0:im-1,1:jm,0:kmo)     :: xyz_dToroidaldz
  real(8), dimension(0:im-1,1:jm)          :: xy_Zero=0.0D0

  ! Ƚ
  integer, parameter :: check_digits = 9
  integer, parameter :: ignore = -10

  call MessageNotify('M','wtq_module_sjpack_torvelbc_tau_wt_test', &
       'wtq_module_sjpack wt_TorgBoundariesTau subroutine test')

  call wtq_Initial(im,jm,kmi,kmo,nm,lmi,lmo,ri,ro)

  !----- wt_TorBoundariesTau (FF) ------

  ! P_10
  xyz_Toroidal_sol = sin(xyz_Lat) * xyz_Rad * (xyz_Rad-ri)**2 * (xyz_Rad-ro)**2 
  ! P_1_1
  !xyz_Toroidal_sol = cos(xyz_Lat)*cos(xyz_Lon)* sin( pi*(xyz_Rad-ri)/(ro-ri) )
  !xyz_Toroidal_sol = 2*sin(xyz_Lat)**2 * sin( pi*(xyz_Rad-ri)/(ro-ri) )
  
  wt_Toroidal = wt_xyz(xyz_Toroidal_sol)
  call wt_TorBoundariesTau(wt_Toroidal,cond='FF',new=.true.) 
  xyz_Toroidal = xyz_wt(wt_Toroidal)
  xyz_dToroidaldz   = xyz_wt(wt_DRad_wt(wt_xyz(xyz_Toroidal/xyz_Rad)))

  call AssertEqual(&
    message='wt_TorBoundariesTau (FF)',                           &
    answer =xyz_Toroidal_sol,                                     &
    check = xyz_Toroidal,                                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='wt_TorBoundariesTau (FF, Top)',                      &
    answer =xy_Zero,                                              &
    check = xyz_dToroidaldz(:,:,0),                               &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='wt_TorBoundariesTau (FF, Bottom)',                   &
    answer =xy_Zero,                                              &
    check = xyz_dToroidaldz(:,:,kmo),                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !----- wt_Toroidal2PolTau (RF) ------

  ! P_10
  xyz_Toroidal_sol = sin(xyz_Lat) * xyz_Rad*(xyz_Rad-ri)**2*(xyz_Rad-ro)
  
  wt_Toroidal = wt_xyz(xyz_Toroidal_sol)
  call wt_TorBoundariesTau(wt_Toroidal,cond='RF',new=.true.) 
  xyz_Toroidal = xyz_wt(wt_Toroidal)
  xyz_dToroidaldz   = xyz_wt(wt_DRad_wt(wt_xyz(xyz_Toroidal/xyz_Rad)))

  call AssertEqual(&
    message='wt_TorBoundariesTau (RF)',                           &
    answer =xyz_Toroidal_sol,                                     &
    check = xyz_Toroidal,                                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='wt_TorBoundariesTau (RF, Top)',                      &
    answer =xy_Zero,                                              &
    check = xyz_Toroidal(:,:,0),                                  &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='wt_TorBoundariesTau (RF, Bottom)',                   &
    answer =xy_Zero,                                              &
    check = xyz_dToroidaldz(:,:,kmo),                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !----- wt_Toroidal2PolTau (FR) ------

  ! P_10
  xyz_Toroidal_sol = sin(xyz_Lat) * xyz_Rad*(xyz_Rad-ri)*(xyz_Rad-ro)**2

  wt_Toroidal = wt_xyz(xyz_Toroidal_sol)
  call wt_TorBoundariesTau(wt_Toroidal,cond='FR',new=.true.) 
  xyz_Toroidal = xyz_wt(wt_Toroidal)
  xyz_dToroidaldz   = xyz_wt(wt_DRad_wt(wt_xyz(xyz_Toroidal/xyz_Rad)))

  call AssertEqual(&
    message='wt_TorBoundariesTau (FR)',                           &
    answer =xyz_Toroidal_sol,                                     &
    check = xyz_Toroidal,                                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='wt_TorBoundariesTau (FR, Top)',                      &
    answer =xy_Zero,                                              &
    check = xyz_dToroidaldz(:,:,0),                               &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='wt_TorBoundariesTau (FR, Bottom)',                   &
    answer =xy_Zero,                                              &
    check = xyz_Toroidal(:,:,kmo),                                &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !----- wt_Toroidal2PolTau (RR) ------

  ! P_10
  xyz_Toroidal_sol = sin(xyz_Lat) * (xyz_Rad-ri)*(xyz_Rad-ro)

  wt_Toroidal = wt_xyz(xyz_Toroidal_sol)
  call wt_TorBoundariesTau(wt_Toroidal,cond='RR',new=.true.) 
  xyz_Toroidal = xyz_wt(wt_Toroidal)
  xyz_dToroidaldz   = xyz_wt(wt_DRad_wt(wt_xyz(xyz_Toroidal/xyz_Rad)))

  call AssertEqual(&
    message='wt_TorBoundariesTau (RR)',                           &
    answer =xyz_Toroidal_sol,                                     &
    check = xyz_Toroidal,                                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='wt_TorBoundariesTau (RR, Top)',                      &
    answer =xy_Zero,                                              &
    check = xyz_Toroidal(:,:,0),                                  &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='wt_TorBoundariesTau (RR, Bottom)',                   &
    answer =xy_Zero,                                              &
    check = xyz_Toroidal(:,:,kmo),                                &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call MessageNotify('M','wtq_module_sjpack_torvelbc_tau_wt_test', &
       'wtq_module_sjpack wt_TorvelBoundariesTau subroutine test succeeded!')

end program wtq_sjpack_torvelbc_tau_wt
