!-------------------------------------------------------------------------
! Copyright (c) 2007-2012 SPMODEL Development Group. All rights reserved.!
!-------------------------------------------------------------------------
!
!ɽ  et_module ƥȥץ
!      ٤ήؿ
!
!  2007/11/20  ݹ
!      2011/03/06  ʿ dc_test Ȥ褦˽
!      2012/07/06  ݹ   RF, FR, RR Υƥɲ
!
program et_test_Vor2StrmCheb

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use et_module
  implicit none

 !---- ֲ ----
  integer, parameter :: im=32, jm=32            ! ʻ(X,Y)
  integer, parameter :: km=10, lm=21            ! ȿ(X,Y)

 !---- ɸѿʤ ----
  real(8), parameter :: xmin = -1.0d0, xmax=1.0d0
  real(8), parameter :: ymin = 0.0d0, ymax=1.0d0

  real(8), parameter :: pi=3.1415926535897932385D0

  ! Ƚ
  integer, parameter :: check_digits = 10
  integer, parameter :: ignore = -11

  real(8)            :: yx_Vor(0:jm,0:im-1)     ! ʻҥǡ
  real(8)            :: yx_Psi(0:jm,0:im-1)     ! ʻҥǡ
  real(8)            :: yx_Vor_sol(0:jm,0:im-1) ! ʻҥǡ
  real(8)            :: yx_Psi_sol(0:jm,0:im-1) ! ʻҥǡ
  real(8)            :: yx_dPsidy(0:jm,0:im-1)  ! ʻҥǡ
  real(8)            :: yx_d2Psidy2(0:jm,0:im-1)! ʻҥǡ
  real(8)            :: x_Zero(0:im-1) = 0.0D0  ! ʻҥǡ

  integer            :: k=2

  call MessageNotify('M','et_test_Vor2StrmCheb', &
       'et_module Stream function calculation from vorticity tests')

 !---------------- ɸͤ ---------------------
  call et_initial(im,jm,km,lm,xmin,xmax,ymin,ymax)    ! ڥȥ

!----- et_Vor2Strm_et (FF) ------
  yx_Psi_sol = -sin(k*pi*yx_X)*sin(pi*yx_Y)/((k*pi)**2+pi**2)
  yx_Vor_sol = sin(k*pi*yx_X)*sin(pi*yx_Y)
  yx_Psi = yx_et(et_Vor2Strm_et(et_yx(yx_Vor_sol),cond='FF'))
  yx_Vor = yx_et(et_Lapla_et(et_yx(yx_Psi)))
  yx_dPsidy = yx_et(et_Dy_et(et_yx(yx_Psi)))
  yx_d2Psidy2 = yx_et(et_Dy_et(et_Dy_et(et_yx(yx_Psi))))

  call AssertEqual(&
    message='et_Vor2Strm_et (FF)',                                &
    answer =yx_Psi_sol,                                           &
    check = yx_Psi,                                               &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='et_Vor2Strm_et (FF, vorticity)',                     &
    answer =yx_Vor_sol,                                           &
    check = yx_Vor,                                               &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='et_Vor2Strm_et (FF, Top)',                           &
    answer =x_Zero,                                               &
    check = yx_d2Psidy2(0,:),                                     &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='et_Vor2Strm_et (FF, Bottom)',                        &
    answer =x_Zero,                                               &
    check = yx_d2Psidy2(jm,:),                                    &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

!----- et_Vor2Strm_et (RF) ------
  yx_Psi_sol = sin(k*pi*yx_X)*(yx_Y-ymin)**3*(yx_Y-ymax)**2
  yx_Vor_sol = yx_et(et_Lapla_et(et_yx(yx_Psi_sol)))

  yx_Psi = yx_et(et_Vor2Strm_et(et_yx(yx_Vor_sol),cond='RF',new=.true.))
  yx_Vor = yx_et(et_Lapla_et(et_yx(yx_Psi)))
  yx_dPsidy = yx_et(et_Dy_et(et_yx(yx_Psi)))
  yx_d2Psidy2 = yx_et(et_Dy_et(et_Dy_et(et_yx(yx_Psi))))

  call AssertEqual(&
    message='et_Vor2Strm_et (RF)',                                &
    answer =yx_Psi_sol,                                           &
    check = yx_Psi,                                               &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='et_Vor2Strm_et (RF, vorticity)',                     &
    answer =yx_Vor_sol,                                           &
    check = yx_Vor,                                               &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='et_Vor2Strm_et (RF, Top)',                           &
    answer =x_Zero,                                               &
    check = yx_dPsidy(0,:),                                       &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='et_Vor2Strm_et (RF, Bottom)',                        &
    answer =x_Zero,                                               &
    check = yx_d2Psidy2(jm,:),                                    &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

!----- et_Vor2Strm (FR) ------
  yx_Psi_sol = sin(k*pi*yx_X)*(yx_Y-ymin)**2*(yx_Y-ymax)**3
  yx_Vor_sol = yx_et(et_Lapla_et(et_yx(yx_Psi_sol)))
  yx_Psi = yx_et(et_Vor2Strm_et(et_yx(yx_Vor_sol),cond='FR',new=.true.))
  yx_Vor = yx_et(et_Lapla_et(et_yx(yx_Psi)))
  yx_dPsidy = yx_et(et_Dy_et(et_yx(yx_Psi)))
  yx_d2Psidy2 = yx_et(et_Dy_et(et_Dy_et(et_yx(yx_Psi))))

  call AssertEqual(&
    message='et_Vor2Strm_et (FR)',                                &
    answer =yx_Psi_sol,                                           &
    check = yx_Psi,                                               &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='et_Vor2Strm_et (FR, vorticity)',                     &
    answer =yx_Vor_sol,                                           &
    check = yx_Vor,                                               &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='et_Vor2Strm_et (FR, Top)',                           &
    answer =x_Zero,                                               &
    check = yx_d2Psidy2(0,:),                                     &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='et_Vor2Strm_et (FR, Bottom)',                        &
    answer =x_Zero,                                               &
    check = yx_dPsidy(jm,:),                                      &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

!----- et_Vor2Strm (RR) ------
  yx_Psi_sol = sin(k*pi*yx_X)*(yx_Y-ymin)**2*(yx_Y-ymax)**2
  yx_Vor_sol = yx_et(et_Lapla_et(et_yx(yx_Psi_sol)))
  yx_Psi = yx_et(et_Vor2Strm_et(et_yx(yx_Vor_sol),cond='RR',new=.true.))
  yx_Vor = yx_et(et_Lapla_et(et_yx(yx_Psi)))
  yx_dPsidy = yx_et(et_Dy_et(et_yx(yx_Psi)))
  yx_d2Psidy2 = yx_et(et_Dy_et(et_Dy_et(et_yx(yx_Psi))))

  call AssertEqual(&
    message='et_Vor2Strm_et (RR)',                                &
    answer =yx_Psi_sol,                                           &
    check = yx_Psi,                                               &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='et_Vor2Strm_et (RR, vorticity)',                     &
    answer =yx_Vor_sol,                                           &
    check = yx_Vor,                                               &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='et_Vor2Strm_et (RR, Top)',                           &
    answer =x_Zero,                                               &
    check = yx_dPsidy(0,:),                                       &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='et_Vor2Strm_et (RR, Bottom)',                        &
    answer =x_Zero,                                               &
    check = yx_dPsidy(jm,:),                                      &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call MessageNotify('M','et_test_Vor2StrmCheb', &
       'et_module Stream function calculation from vorticity tests OK!')

end program et_test_Vor2StrmCheb
