!--
!----------------------------------------------------------------------
!     Copyright (c) 2011 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  ʣǸͭꥵ֥롼 (SSL2)
!
!  2011/11/05  ݹ
!
!++
module ssl2_ceigen
  !
  != ssl2_ceigen
  !
  ! Authors:: Shin-ichi Takehiro, Youhei SASAKI
  ! Version:: $Id: 
  ! Copyright&License:: See COPYRIGHT[link:../COPYRIGHT]
  ! 
  !== 
  !
  ! spml/ssl2_ceigen  eigmatrix ⥸塼θ֥롼 ceigen
  ! Ѥθͭͷ׻Ѷ̥󥿡եͿ.
  !
  !   *  CMAT  i ܸͭͤ eigen(i) ˳Ǽ
  !   * бͭ٥ȥ eigvec(:,i) ˳Ǽ
  !   * Ǽͭͤοϰ eigen 礭Ƿޤ
  !   * ͭͤν֤ sort  order . 
  !   * sort ˤäƽ֤뤿Ѥ̤ꤹ. 
  !     (R), (RA), (I), (IA)
  !   * reverse ˤäƾ(.false.), 礭(.true.)Ǥ.
  !   * ǥեȤ sort='R', reverse=.false.
  !   *  CMAT ¸ʤ.
  !
  ! Ǥ DCEIG2/SSL2 롼ˤʣǹθͭ/ͭ٥ȥ׻
  ! ԤäƤ. , 桼ѤƤ饤֥ȥ֥롼ռ
  ! 뤳ȤʤȤȤǤ. 
  use dc_message, only : MessageNotify

  implicit none
  private
  public dceig2_ssl2

contains
  subroutine dceig2_ssl2(cmat,eigen,eigvec,info,sort,reverse)
    !
    ! Υ֥롼ϸͭͷ׻Ѷ̥󥿡եͿ
    ! eigmatrix ⥸塼θ֥롼 ceigen ȤѤ. 
    !
    !   *  CMAT  i ܸͭͤ eigen(i) ˳Ǽ
    !   * бͭ٥ȥ eigvec(:,i) ˳Ǽ
    !   * Ǽͭͤοϰ eigen 礭Ƿޤ
    !   * ͭͤν֤ sort  order . 
    !   * sort ˤäƽ֤뤿Ѥ̤ꤹ. 
    !     (R), (RA), (I), (IA)
    !   * reverse ˤäƾ(.false.), 礭(.true.)Ǥ.
    !   * ǥեȤ sort='R', reverse=.false.
    !   *  CMAT ¸ʤ.
    !
    ! Ǥ DCEIG2/SSL2 롼ˤʣǹθͭ/ͭ٥ȥ׻
    ! ԤäƤ. , 桼ѤƤ饤֥ȥ֥롼ռ
    ! 뤳ȤʤȤȤǤ. 
    !
    interface 
       function indexx(arrin)
         implicit none
         real(8), dimension(:), intent(in)  :: arrin
         integer, dimension(size(arrin))    :: indexx
       end function indexx
    end interface

   !------------  ------------
    complex(8), dimension(:,:)                :: cmat      ! 
    complex(8), intent(out), dimension(:)     :: eigen     ! ͭͼ¿
    complex(8), intent(out), &
      dimension(size(cmat,1),size(eigen))     :: eigvec    ! ͭ٥ȥ
    integer, intent(out)                      :: info      ! ơ
    character(len=2), intent(in), optional    :: sort      ! ¤Ѥ
    logical, intent(in), optional             :: reverse   ! ¤Ѥå

   !------------ ѿ ------------
    complex(8), dimension(size(cmat,1))              :: ceig  ! ͭ
    complex(8), dimension(size(cmat,1),size(cmat,1)) :: cvec  ! ͭ٥ȥ
    real(8), dimension(size(cmat,1))                 :: vw    ! ѿ
    integer, dimension(size(cmat,1))                 :: ivw   ! ѿ
    integer, dimension(size(cmat,1))                 :: index ! ¤Ѥ
    integer, parameter :: mode=0   ! DCEIG1Ϥå(ʿղά)

    integer :: nm, i, j

    !------- å ------
    if (size(cmat,1) /= size(cmat,2))then
       call MessageNotify('E','DCEIG2_SSL2','Input matrix not square')
    else
       nm = size(cmat,1)
    endif

    !------- DCEIG2/SSL2 ˤ׻ ------
    call dceig2(cmat,nm,nm,mode,ceig,cvec,vw,ivw,info)

    !------- ֥롼󥨥顼 -------
    if ( info /= 0 ) then
       call MessageNotify('W','DCEIG2_SSL2',&
            'Error in calculating eigenvalues/vectors...',i=(/info/) )
       return
    endif

    !------- ͭ٥ȥ촹 -------
    if ( present(sort) ) then
       if ( sort == 'RA' ) then          ! ͭͼ
          index=indexx(abs(dble(ceig)))
       elseif ( trim(sort) == 'I' ) then ! ͭ͵
          index=indexx(dimag(ceig))
       elseif ( sort == 'IA' ) then      ! ͭ͵
          index=indexx(abs(dimag(ceig)))
       else
          index=indexx(dble(ceig))       ! defaultϸͭͼ
       endif
    else
       index=indexx(dble(ceig))          ! defaultϸͭͼ
    endif

    if ( present(reverse) )then
       if ( reverse ) then               ! 礭
          index=index(size(index):1:-1)
       endif
    endif

    do i=1,size(eigen)
       j = index(i)
       eigen(i) = ceig(j)
       eigvec(:,i) = cvec(:,j)
    enddo

  end subroutine dceig2_ssl2

end module ssl2_ceigen

