!------------------------------------------------------------------------
! Copyright (c) 2011 SPMODEL Development Group. All rights reserved.
!------------------------------------------------------------------------
!
!ɽ  eea_module ƥȥץ (ʬ׻)
!
!  2011/12/10  ݹ
!
program eea_test_derivative

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use eea_module
  implicit none

 !---- ֲ ----
  integer, parameter :: im=32, jm=32            ! ʻ(X,Y)
  integer, parameter :: km=10, lm=10              ! ȿ(X,Y)

 !---- ѿ ----
  real(8)            :: yxa_Data(0:jm-1,0:im-1,2)    ! ʻҥǡ
  real(8)            :: yxa_Deriv(0:jm-1,0:im-1,2)   ! ʻҥǡ

  integer            :: k=2, l=3

 !---- ɸѿʤ ----
  real(8), parameter :: xmin = -1.0d0, xmax=1.0d0
  real(8), parameter :: ymin = -1.0d0, ymax=1.0d0

  ! Ƚ
  integer, parameter :: check_digits = 10
  integer, parameter :: ignore = -11

  real(8), parameter :: pi=3.1415926535897932385D0

  call MessageNotify('M','eea_test_derivative', &
       'eea_module derivative function tests')

 !---------------- ɸͤ ---------------------
  call eea_initial(im,jm,km,lm,xmin,xmax,ymin,ymax)    ! ڥȥ

 !-------------------  ----------------------
  yxa_Data(:,:,1) = sin(k*pi*yx_X) * sin(l*pi*yx_Y)
  yxa_Data(:,:,2) = cos(k*pi*yx_X) * cos(l*pi*yx_Y)

  yxa_Deriv(:,:,1) = k*pi*cos(k*pi*yx_X) * sin(l*pi*yx_Y)
  yxa_Deriv(:,:,2) = -k*pi*sin(k*pi*yx_X) * cos(l*pi*yx_Y)
  call check3d(yxa_eea(eea_Dx_eea(eea_yxa(yxa_Data))), &
    yxa_Deriv, 'Dx(sin(k*pi*X)*sin(l*pi*Y)),Dx(cos(k*pi*X)*cos(l*pi*Y))')

  yxa_Deriv(:,:,1) = l*pi*sin(k*pi*yx_X) * cos(l*pi*yx_Y)
  yxa_Deriv(:,:,2) = -l*pi*cos(k*pi*yx_X) * sin(l*pi*yx_Y)
  call check3d(yxa_eea(eea_Dy_eea(eea_yxa(yxa_Data))), &
    yxa_Deriv, 'Dy(sin(k*pi*X)*sin(l*pi*Y)),Dy(cos(k*pi*X)*cos(l*pi*Y)')

  yxa_Deriv(:,:,1) = -((k*pi)**2 + (l*pi)**2) * sin(k*pi*yx_X) * sin(l*pi*yx_Y)
  yxa_Deriv(:,:,2) = -((k*pi)**2 + (l*pi)**2) * cos(k*pi*yx_X) * cos(l*pi*yx_Y)
  call check3d(yxa_eea(eea_Lapla_eea(eea_yxa(yxa_Data))), &
    yxa_Deriv, 'Lapla(sin(k*pi*X)*sin(l*pi*Y)),Lapla(cos(k*pi*X)*cos(l*pi*Y))')

  yxa_Deriv(:,:,1) = -1.0/((k*pi)**2 + (l*pi)**2) * sin(k*pi*yx_X) * sin(l*pi*yx_Y)
  yxa_Deriv(:,:,2) = -1.0/((k*pi)**2 + (l*pi)**2) * cos(k*pi*yx_X) * cos(l*pi*yx_Y)
  call check3d(yxa_eea(eea_LaplaInv_eea(eea_yxa(yxa_Data))), &
    yxa_Deriv, 'LaplaInv(sin(k*pi*X)*sin(l*pi*Y)),LaplaInv(cos(k*pi*X)*cos(l*pi*Y))')


  yxa_Data(:,:,1) = sin(k*pi*yx_X) * cos(l*pi*yx_Y)
  yxa_Data(:,:,2) = cos(k*pi*yx_X) * sin(l*pi*yx_Y)

  yxa_Deriv(:,:,1) = k*pi*cos(k*pi*yx_X) * cos(l*pi*yx_Y)
  yxa_Deriv(:,:,2) = -k*pi*sin(k*pi*yx_X) * sin(l*pi*yx_Y)
  call check3d(yxa_eea(eea_Dx_eea(eea_yxa(yxa_Data))), &
    yxa_Deriv, 'Dx(sin(k*pi*X)*cos(l*pi*Y)),Dx(cos(k*pi*X)*sin(l*pi*Y))')

  yxa_Deriv(:,:,1) = -l*pi*sin(k*pi*yx_X) * sin(l*pi*yx_Y)
  yxa_Deriv(:,:,2) = l*pi*cos(k*pi*yx_X) * cos(l*pi*yx_Y)
  call check3d(yxa_eea(eea_Dy_eea(eea_yxa(yxa_Data))), &
    yxa_Deriv, 'Dy(sin(k*pi*X)*cos(l*pi*Y)),Dy(cos(k*pi*X)*sin(l*pi*Y))')

  yxa_Deriv(:,:,1) = -((k*pi)**2 + (l*pi)**2) * sin(k*pi*yx_X) * cos(l*pi*yx_Y)
  yxa_Deriv(:,:,2) = -((k*pi)**2 + (l*pi)**2) * cos(k*pi*yx_X) * sin(l*pi*yx_Y)
  call check3d(yxa_eea(eea_Lapla_eea(eea_yxa(yxa_Data))), &
    yxa_Deriv, 'Lapla(sin(k*pi*X)*cos(l*pi*Y)),Lapla(cos(k*pi*X)*sin(l*pi*Y))')

  yxa_Deriv(:,:,1) = -1.0/((k*pi)**2 + (l*pi)**2) * sin(k*pi*yx_X) * cos(l*pi*yx_Y)
  yxa_Deriv(:,:,2) = -1.0/((k*pi)**2 + (l*pi)**2) * cos(k*pi*yx_X) * sin(l*pi*yx_Y)
  call check3d(yxa_eea(eea_LaplaInv_eea(eea_yxa(yxa_Data))), &
    yxa_Deriv, 'LaplaInv(sin(k*pi*X)*cos(l*pi*Y)),LaplaInv(cos(k*pi*X)*sin(l*pi*Y))')

  call MessageNotify('M','eea_test_derivative', &
       'eea_module derivative function tests succeeded!')

contains

  subroutine check3d(var,sol,funcname)
    real(8) :: var(:,:,:)                ! Ƚꤹ
    real(8) :: sol(:,:,:)                ! ϲ
    character(len=*) :: funcname         ! ؿ̾

    call AssertEqual(     &
      message = funcname, &
      answer = sol,       &
      check = var,        &
      significant_digits = check_digits, ignore_digits = ignore     )

  end subroutine check3d

end program eea_test_derivative
