#
# uspac4.rb
#   $Id$
#


require "numru/dcl"
include NumRu
include Math


nmax = 50
ymin = 0.0
ymax = 50.0
x1 = NArray.sfloat(nmax+1)
x2 = NArray.sfloat(nmax+1)

#-- data ---
iseed = 0
for n in 0..nmax
  y = ymin + (ymax-ymin)*n/nmax
  x1[n] = 10.0*(exp(-y/20))**2 * exp((rand(iseed)-0.5)*2)**2
  x2[n] = 10.0*(exp(-y/20))**2
end

#-- graph ---
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws

DCL::grfrm

rundef = DCL::glrget('RUNDEF')
DCL::grswnd(rundef, rundef, ymin, ymax)
DCL::usspnt(x1, rundef)
DCL::usspnt(x2, rundef)
DCL::grstrn(3)
DCL::uspfit
DCL::grstrf

DCL::ussttl('MIXING RATIO', 'ppmv', 'HEIGHT', 'km')
DCL::usdaxs

DCL::uusmkt(2)
DCL::uumrk(x1, rundef)
DCL::uulin(x2, rundef)

DCL::grcls

