% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/files.R
\name{stri_write_lines}
\alias{stri_write_lines}
\title{Write Text Lines to a Text File}
\usage{
stri_write_lines(
  str,
  con,
  encoding = "UTF-8",
  sep = ifelse(.Platform$OS.type == "windows", "\\r\\n", "\\n"),
  fname = con
)
}
\arguments{
\item{str}{character vector with data to write}

\item{con}{name of the output file or a connection object
(opened in the binary mode)}

\item{encoding}{output encoding, \code{NULL} or \code{''} for
the current default one}

\item{sep}{newline separator}

\item{fname}{deprecated alias of \code{con}}
}
\value{
This function returns nothing noteworthy.
}
\description{
Writes a text file is such a way that each element of a given
character vector becomes a separate text line.
}
\details{
It is a substitute for the \R \code{\link{writeLines}} function,
with the ability to easily re-encode the output.

We suggest using the UTF-8 encoding for all text files:
thus, it is the default one for the output.
}
\seealso{
Other files: 
\code{\link{stri_read_lines}()},
\code{\link{stri_read_raw}()}
}
\concept{files}
