% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/migrate.R
\name{migrate}
\alias{migrate}
\title{Migrate a project from packrat to renv}
\usage{
migrate(
  project = NULL,
  packrat = c("lockfile", "sources", "library", "options", "cache")
)
}
\arguments{
\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}

\item{packrat}{Components of the Packrat project to migrate. See the default
argument list for components of the Packrat project that can be migrated.
Select a subset of those components for migration as appropriate.}
}
\value{
The project directory, invisibly. Note that this function is normally
called for its side effects.
}
\description{
Migrate a project's infrastructure from packrat to renv.
}
\section{Migration}{
When migrating Packrat projects to renv, the set of components migrated
can be customized using the \code{packrat} argument. The set of components that
can be migrated are as follows:

\tabular{ll}{

\strong{Name} \tab \strong{Description} \cr

\code{lockfile} \tab
Migrate the Packrat lockfile (\code{packrat/packrat.lock}) to the renv lockfile
(\code{renv.lock}). \cr

\code{sources} \tab
Migrate package sources from the \code{packrat/src} folder to the renv
sources folder. Currently, only CRAN packages are migrated to renv --
packages retrieved from other sources (e.g. GitHub) are ignored.
\cr

\code{library} \tab
Migrate installed packages from the Packrat library to the renv project
library.
\cr

\code{options} \tab
Migrate compatible Packrat options to the renv project.
\cr

\code{cache} \tab
Migrate packages from the Packrat cache to the renv cache.
\cr

}
}

\examples{
\dontrun{

# migrate Packrat project infrastructure to renv
renv::migrate()

}
}
