% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pr_set.R
\name{pr_set_api_spec}
\alias{pr_set_api_spec}
\title{Set the OpenAPI Specification information}
\usage{
pr_set_api_spec(pr, api)
}
\arguments{
\item{pr}{A Plumber API. Note: The supplied Plumber API object will also be updated in place as well as returned by the function.}

\item{api}{This can be
\itemize{
\item an OpenAPI Specification formatted list object
\item a function that accepts the OpenAPI Specification autogenerated by \code{plumber} and returns a OpenAPI Specification formatted list object.
}

The value returned will not be validated for OAS compatibility.}
}
\value{
The Plumber router with the new OpenAPI Specification object or function.
}
\description{
When set, it will be called with a character string corresponding
to the API visual documentation url. This allows RStudio to open \code{swagger} docs when a
Plumber router \code{\link[=pr_run]{pr_run()}} method is executed using default \code{plumber.docs.callback} option.
}
\examples{
\dontrun{
# Set the API Spec to a function to use the auto-generated OAS object
pr() \%>\%
  pr_set_api_spec(function(spec) {
    spec$info$title <- Sys.time()
    spec
  }) \%>\%
  pr_get("/plus/<a:int>/<b:int>", function(a, b) { a + b }) \%>\%
  pr_run()

# Set the API Spec using an object
pr() \%>\%
  pr_set_api_spec(my_custom_object) \%>\%
  pr_get("/plus/<a:int>/<b:int>", function(a, b) { a + b }) \%>\%
  pr_run()
}
}
