% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{+.igraph}
\alias{+.igraph}
\title{Add vertices, edges or another graph to a graph}
\usage{
\method{+}{igraph}(e1, e2)
}
\arguments{
\item{e1}{First argument, probably an igraph graph, but see details
below.}

\item{e2}{Second argument, see details below.}
}
\description{
Add vertices, edges or another graph to a graph
}
\details{
The plus operator can be used to add vertices or edges to graph.
  The actual operation that is performed depends on the type of the
  right hand side argument.
  \itemize{
  \item If is is another igraph graph object and they are both
    named graphs, then the union of the two graphs are calculated,
    see \code{\link{union}}.
  \item If it is another igraph graph object, but either of the two
    are not named, then the disjoint union of
    the two graphs is calculated, see \code{\link{disjoint_union}}.
  \item If it is a numeric scalar, then the specified number of vertices
    are added to the graph.
  \item If it is a character scalar or vector, then it is interpreted as
    the names of the vertices to add to the graph.
  \item If it is an object created with the \code{\link{vertex}} or
    \code{\link{vertices}} function, then new vertices are added to the
    graph. This form is appropriate when one wants to add some vertex
    attributes as well. The operands of the \code{vertices} function
    specifies the number of vertices to add and their attributes as
    well.

    The unnamed arguments of \code{vertices} are concatenated and
    used as the \sQuote{\code{name}} vertex attribute (i.e. vertex
    names), the named arguments will be added as additional vertex
    attributes. Examples: \preformatted{  g <- g +
        vertex(shape="circle", color= "red")
  g <- g + vertex("foo", color="blue")
  g <- g + vertex("bar", "foobar")
  g <- g + vertices("bar2", "foobar2", color=1:2, shape="rectangle")}

    \code{vertex} is just an alias to \code{vertices}, and it is
    provided for readability. The user should use it if a single vertex
    is added to the graph.

  \item If it is an object created with the \code{\link{edge}} or
    \code{\link{edges}} function, then new edges will be added to the
    graph. The new edges and possibly their attributes can be specified as
    the arguments of the \code{edges} function.

    The unnamed arguments of \code{edges} are concatenated and used
    as vertex ids of the end points of the new edges. The named
    arguments will be added as edge attributes.

    Examples: \preformatted{  g <- make_empty_graph() +
         vertices(letters[1:10]) +
         vertices("foo", "bar", "bar2", "foobar2")
  g <- g + edge("a", "b")
  g <- g + edges("foo", "bar", "bar2", "foobar2")
  g <- g + edges(c("bar", "foo", "foobar2", "bar2"), color="red", weight=1:2)}
    See more examples below.

    \code{edge} is just an alias to \code{edges} and it is provided
    for readability. The user should use it if a single edge is added to
    the graph.

  \item If it is an object created with the \code{\link{path}} function, then
    new edges that form a path are added. The edges and possibly their
    attributes are specified as the arguments to the \code{path}
    function. The non-named arguments are concatenated and interpreted
    as the vertex ids along the path. The remaining arguments are added
    as edge attributes.

    Examples: \preformatted{  g <- make_empty_graph() + vertices(letters[1:10])
  g <- g + path("a", "b", "c", "d")
  g <- g + path("e", "f", "g", weight=1:2, color="red")
  g <- g + path(c("f", "c", "j", "d"), width=1:3, color="green")}
  }

  It is important to note that, although the plus operator is
  commutative, i.e. is possible to write \preformatted{  graph <- "foo" + make_empty_graph()}
  it is not associative, e.g. \preformatted{  graph <- "foo" + "bar" + make_empty_graph()}
  results a syntax error, unless parentheses are used: \preformatted{  graph <- "foo" + ( "bar" + make_empty_graph() )}
  For clarity, we suggest to always put the graph object on the left
  hand side of the operator: \preformatted{  graph <- make_empty_graph() + "foo" + "bar"}
}
\examples{
# 10 vertices named a,b,c,... and no edges
g <- make_empty_graph() + vertices(letters[1:10])

# Add edges to make it a ring
g <- g + path(letters[1:10], letters[1], color = "grey")

# Add some extra random edges
g <- g + edges(sample(V(g), 10, replace = TRUE), color = "red")
g$layout <- layout_in_circle
plot(g)
}
\seealso{
Other functions for manipulating graph structure: 
\code{\link{add_edges}()},
\code{\link{add_vertices}()},
\code{\link{delete_edges}()},
\code{\link{delete_vertices}()},
\code{\link{edge}()},
\code{\link{igraph-minus}},
\code{\link{path}()},
\code{\link{vertex}()}
}
\concept{functions for manipulating graph structure}
