% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/append_chunk.R
\name{append_chunks}
\alias{append_chunks}
\title{Append chunks to flextable content}
\usage{
append_chunks(x, ..., i = NULL, j = NULL, part = "body")
}
\arguments{
\item{x}{a flextable object}

\item{...}{chunks to be appened, see \code{\link[=as_chunk]{as_chunk()}}, \code{\link[=gg_chunk]{gg_chunk()}} and other
chunk elements for paragraph.}

\item{i}{rows selection}

\item{j}{column selection}

\item{part}{partname of the table (one of 'body', 'header', 'footer')}
}
\description{
append chunks (for example chunk \code{\link[=as_chunk]{as_chunk()}})
in a flextable.
}
\examples{
library(flextable)
img.file <- file.path(R.home("doc"), "html", "logo.jpg")

ft_1 <- flextable(head(cars))

ft_1 <- append_chunks(ft_1,
  # where to append
  i = c(1, 3, 5),
  j = 1,
  # what to append
  as_chunk(" "),
  as_image(src = img.file, width = .20, height = .15)
)
ft_1 <- set_table_properties(ft_1, layout = "autofit")
ft_1
}
\seealso{
\code{\link[=as_chunk]{as_chunk()}}, \code{\link[=as_sup]{as_sup()}}, \code{\link[=as_sub]{as_sub()}}, \code{\link[=colorize]{colorize()}}

Other functions for mixed content paragraphs: 
\code{\link{as_paragraph}()},
\code{\link{compose}()},
\code{\link{prepend_chunks}()}
}
\concept{functions for mixed content paragraphs}
