% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basis.R
\name{nonpara_binomial_rank}
\alias{nonpara_binomial_rank}
\title{Rank for distribution-free tolerance bound}
\usage{
nonpara_binomial_rank(n, p, conf)
}
\arguments{
\item{n}{the sample size}

\item{p}{the desired content for the tolerance bound}

\item{conf}{the confidence level for the desired tolerance bound}
}
\value{
The rank corresponding with the desired tolerance bound
}
\description{
Calculates the rank order for finding distribution-free tolerance
bounds for large samples. This function should only be used for
computing B-Basis for samples larger than 28 or A-Basis for samples
larger than 298. This function is used by
\code{\link{basis_nonpara_large_sample}}.
}
\details{
This function uses the sum of binomial terms to determine the rank
of the ordered statistic that corresponds with the desired tolerance
limit. This approach does not assume any particular distribution. This
approach is described by Guenther (1969) and by CMH-17-1G.

The results of this function have been verified against the tables in
CMH-17-1G and agreement was found for all sample sizes published in
CMH-17-1G for both A- and B-Basis, as well as the sample sizes
\code{n+1} and \code{n-1}, where
\code{n} is the sample size published in CMH-17-1G.

The tables in CMH-17-1G purportedly list the smallest sample sizes
for which a particular rank can be used. That is, for a sample size
one less than the \code{n} published in the table, the next lowest rank
would be used. In some cases, the results of this function disagree by a
rank of one for sample sizes one less than the \code{n} published in the
table. This indicates a disagreement in that sample size at which
the rank should change. This is likely due to numerical
differences in this function and the procedure used to generate the tables.
However, the disagreement is limited to sample 6500 for A-Basis; no
discrepancies have been identified for B-Basis. Since these sample sizes are
uncommon for composite materials
testing, and the difference between subsequent order statistics will be
very small for samples this large, this difference will have no practical
effect on computed tolerance bounds.
}
\examples{
nonpara_binomial_rank(n = 1693, p = 0.99, conf = 0.95)
## [1] 11

# The above example indicates that for a sample of 1693 observations,
# the A-Basis is best approximated as the 11th ordered observation.
# In the example below, the same ordered observation would also be used
# for a sample of size 1702.

nonpara_binomial_rank(n = 1702, p = 0.99, conf = 0.95)
## [1] 11

}
\references{
W. Guenther, “Determination of Sample Size for Distribution-Free
Tolerance Limits,” Jan. 1969.
Available online: \url{https://www.duo.uio.no/handle/10852/48686}

“Composite Materials Handbook, Volume 1. Polymer Matrix Composites
Guideline for Characterization of Structural Materials,” SAE International,
CMH-17-1G, Mar. 2012.
}
\seealso{
\code{\link{basis_nonpara_large_sample}}
}
