% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R, R/methods_row.R
\name{colProds,xgCMatrix-method}
\alias{colProds,xgCMatrix-method}
\alias{rowProds,xgCMatrix-method}
\title{Calculates the product for each row (column) in a matrix}
\usage{
\S4method{colProds}{xgCMatrix}(x, rows = NULL, cols = NULL, na.rm = FALSE, ...)

\S4method{rowProds}{xgCMatrix}(x, rows = NULL, cols = NULL, na.rm = FALSE, ...)
}
\arguments{
\item{x}{An NxK matrix-like object.}

\item{rows}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{na.rm}{If \code{\link[base:logical]{TRUE}}, \code{\link{NA}}s
are excluded first, otherwise not.}

\item{...}{Additional arguments passed to specific methods.}
}
\value{
Returns a \code{\link{numeric}} \code{\link{vector}} of length N (K).
}
\description{
Calculates the product for each row (column) in a matrix
}
\details{
Attention: This method ignores the order of the values, because it assumes that
the product is commutative. Unfortunately, for 'double' this is not true.
For example `NaN * NA = NaN`, but `NA * NaN = NA`. This is relevant for this
function if there are `+-Inf`, because `Inf * 0 = NaN`. This function returns
`NA` whenever there is `NA` in the input. This is different from `matrixStats::colProds()`.
}
\examples{
mat <- matrix(rnorm(15), nrow = 5, ncol = 3)
  mat[2, 1] <- NA
  mat[3, 3] <- Inf
  mat[4, 1] <- 0
  
  print(mat)
  
  rowProds(mat)
  colProds(mat)
}
\seealso{
\itemize{
  \item \code{matrixStats::\link[matrixStats]{rowProds}()} and
    \code{matrixStats::\link[matrixStats:rowProds]{colProds}()} which are used
    when the input is a \code{matrix} or \code{numeric} vector.
  \item For sums across rows (columns), see
    \code{rowSums2()} (\code{colSums2()})
  \item \code{base::\link{prod}()}.
}
}
