% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrapResults.R
\name{bootstrapResults}
\alias{bootstrapResults}
\title{Bootstrapping variant fits}
\usage{
bootstrapResults(res, n = 500, top = NULL, reorder = FALSE)
}
\arguments{
\item{res}{Return object of the \code{\link{runAbsoluteCN}} function.}

\item{n}{Number of bootstrap replicates.}

\item{top}{Include solution if it appears in the top \code{n} solutions of
any bootstrap replicate. If \code{NULL}, do not filter solutions.}

\item{reorder}{Reorder results by bootstrap value.}
}
\value{
Returns a \code{\link{runAbsoluteCN}} object with added bootstrap 
value to each solution. This value
is the fraction of bootstrap replicates in which the solution ranked first.
}
\description{
This function bootstraps variants, then optionally re-ranks solutions by 
using the bootstrap estimate of the likelihood score, and then optionally
removes solutions that never ranked high in any bootstrap replicate.
}
\examples{

data(purecn.example.output)
ret.boot <- bootstrapResults(purecn.example.output, n=100)
plotAbs(ret.boot, type="overview")

}
\seealso{
\code{\link{runAbsoluteCN}}
}
\author{
Markus Riester
}
