% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IO-methods.R
\name{show_mothur_cutoffs}
\alias{show_mothur_cutoffs}
\title{Show cutoff values available in a mothur file.}
\usage{
show_mothur_cutoffs(mothur_list_file)
}
\arguments{
\item{mothur_list_file}{The file name and/or location as produced by \emph{mothur}.}
}
\value{
A character vector of the different cutoff values contained in the file.
 For a given set of arguments to the \code{cluster()} command from within
 \emph{mothur}, a number of OTU-clustering results are returned in the same
 file. The exact cutoff values used by \emph{mothur} can vary depending
 on the input data/parameters. This simple function returns the cutoffs that were actually
 included in the \emph{mothur} output. This an important extra step prior to
 importing data with the \code{\link{import_mothur}} function.
}
\description{
This is a helper function to report back to the user the different cutoff
values available in a given mothur file -- 
for instance, a list or shared file.
}
\seealso{
\code{\link{import_mothur}}
}
