% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_pc_variance_explained}
\alias{plot_pc_variance_explained}
\title{Plots the percentage of variance explained by the each component based on PCA from the normalized expression
data using the same procedure used in reduceDimension function.}
\usage{
plot_pc_variance_explained(
  cds,
  max_components = 100,
  norm_method = c("log", "vstExprs", "none"),
  residualModelFormulaStr = NULL,
  pseudo_expr = NULL,
  return_all = F,
  use_existing_pc_variance = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{cds}{CellDataSet for the experiment after running reduceDimension with reduction_method as tSNE}

\item{max_components}{Maximum number of components shown in the scree plot (variance explained by each component)}

\item{norm_method}{Determines how to transform expression values prior to reducing dimensionality}

\item{residualModelFormulaStr}{A model formula specifying the effects to subtract from the data before clustering.}

\item{pseudo_expr}{amount to increase expression values before dimensionality reduction}

\item{return_all}{A logical argument to determine whether or not the variance of each component is returned}

\item{use_existing_pc_variance}{Whether to plot existing results for variance explained by each PC}

\item{verbose}{Whether to emit verbose output during dimensionality reduction}

\item{...}{additional arguments to pass to the dimensionality reduction function}
}
\description{
Plots the percentage of variance explained by the each component based on PCA from the normalized expression
data using the same procedure used in reduceDimension function.
}
\examples{
\dontrun{
library(HSMMSingleCell)
HSMM <- load_HSMM()
plot_pc_variance_explained(HSMM)
}
}
