from django.db import models


class R(models.Model):
    is_default = models.BooleanField(default=False)

    def __str__(self):
        return "%s" % self.pk


def get_default_r():
    return R.objects.get_or_create(is_default=True)[0].pk


class S(models.Model):
    r = models.ForeignKey(R, models.CASCADE)


class T(models.Model):
    s = models.ForeignKey(S, models.CASCADE)


class U(models.Model):
    t = models.ForeignKey(T, models.CASCADE)


class RChild(R):
    pass


class A(models.Model):
    name = models.CharField(max_length=30)

    auto = models.ForeignKey(R, models.CASCADE, related_name="auto_set")
    auto_nullable = models.ForeignKey(R, models.CASCADE, null=True, related_name='auto_nullable_set')
    setvalue = models.ForeignKey(R, models.SET(get_default_r), related_name='setvalue')
    setnull = models.ForeignKey(R, models.SET_NULL, null=True, related_name='setnull_set')
    setdefault = models.ForeignKey(R, models.SET_DEFAULT, default=get_default_r, related_name='setdefault_set')
    setdefault_none = models.ForeignKey(
        R, models.SET_DEFAULT,
        default=None, null=True, related_name='setnull_nullable_set',
    )
    cascade = models.ForeignKey(R, models.CASCADE, related_name='cascade_set')
    cascade_nullable = models.ForeignKey(R, models.CASCADE, null=True, related_name='cascade_nullable_set')
    protect = models.ForeignKey(R, models.PROTECT, null=True)
    donothing = models.ForeignKey(R, models.DO_NOTHING, null=True, related_name='donothing_set')
    child = models.ForeignKey(RChild, models.CASCADE, related_name="child")
    child_setnull = models.ForeignKey(RChild, models.SET_NULL, null=True, related_name="child_setnull")

    # A OneToOneField is just a ForeignKey unique=True, so we don't duplicate
    # all the tests; just one smoke test to ensure on_delete works for it as
    # well.
    o2o_setnull = models.ForeignKey(R, models.SET_NULL, null=True, related_name="o2o_nullable_set")


def create_a(name):
    a = A(name=name)
    for name in ('auto', 'auto_nullable', 'setvalue', 'setnull', 'setdefault',
                 'setdefault_none', 'cascade', 'cascade_nullable', 'protect',
                 'donothing', 'o2o_setnull'):
        r = R.objects.create()
        setattr(a, name, r)
    a.child = RChild.objects.create()
    a.child_setnull = RChild.objects.create()
    a.save()
    return a


class M(models.Model):
    m2m = models.ManyToManyField(R, related_name="m_set")
    m2m_through = models.ManyToManyField(R, through="MR", related_name="m_through_set")
    m2m_through_null = models.ManyToManyField(R, through="MRNull", related_name="m_through_null_set")


class MR(models.Model):
    m = models.ForeignKey(M, models.CASCADE)
    r = models.ForeignKey(R, models.CASCADE)


class MRNull(models.Model):
    m = models.ForeignKey(M, models.CASCADE)
    r = models.ForeignKey(R, models.SET_NULL, null=True)


class Avatar(models.Model):
    desc = models.TextField(null=True)


# This model is used to test a duplicate query regression (#25685)
class AvatarProxy(Avatar):
    class Meta:
        proxy = True


class User(models.Model):
    avatar = models.ForeignKey(Avatar, models.CASCADE, null=True)


class HiddenUser(models.Model):
    r = models.ForeignKey(R, models.CASCADE, related_name="+")


class HiddenUserProfile(models.Model):
    user = models.ForeignKey(HiddenUser, models.CASCADE)


class M2MTo(models.Model):
    pass


class M2MFrom(models.Model):
    m2m = models.ManyToManyField(M2MTo)


class Parent(models.Model):
    pass


class Child(Parent):
    pass


class Base(models.Model):
    pass


class RelToBase(models.Model):
    base = models.ForeignKey(Base, models.DO_NOTHING)
