# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Dict, List, Mapping, Optional, TYPE_CHECKING, Union, overload

from .. import _model_base
from .._model_base import rest_field

if TYPE_CHECKING:
    from .. import models as _models


class Resource(_model_base.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.playwrighttesting.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long"""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.playwrighttesting.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[Dict[str, str]] = rest_field()
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Account(TrackedResource):
    """A Playwright service account resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.playwrighttesting.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.playwrighttesting.models.AccountProperties
    """

    properties: Optional["_models.AccountProperties"] = rest_field()
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.AccountProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AccountFreeTrialProperties(_model_base.Model):
    """The Playwright service account quota resource free-trial properties.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar created_at: The free-trial createdAt utcDateTime. Required.
    :vartype created_at: ~datetime.datetime
    :ivar expiry_at: The free-trial expiryAt utcDateTime. Required.
    :vartype expiry_at: ~datetime.datetime
    :ivar allocated_value: The free-trial allocated limit value eg. allocated free minutes.
     Required.
    :vartype allocated_value: int
    :ivar used_value: The free-trial used value eg. used free minutes. Required.
    :vartype used_value: int
    :ivar percentage_used: The free-trial percentage used. Required.
    :vartype percentage_used: float
    """

    created_at: datetime.datetime = rest_field(name="createdAt", visibility=["read"], format="rfc3339")
    """The free-trial createdAt utcDateTime. Required."""
    expiry_at: datetime.datetime = rest_field(name="expiryAt", visibility=["read"], format="rfc3339")
    """The free-trial expiryAt utcDateTime. Required."""
    allocated_value: int = rest_field(name="allocatedValue", visibility=["read"])
    """The free-trial allocated limit value eg. allocated free minutes. Required."""
    used_value: int = rest_field(name="usedValue", visibility=["read"])
    """The free-trial used value eg. used free minutes. Required."""
    percentage_used: float = rest_field(name="percentageUsed", visibility=["read"])
    """The free-trial percentage used. Required."""


class AccountProperties(_model_base.Model):
    """Account resource properties.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar dashboard_uri: The Playwright testing dashboard URI for the account resource.
    :vartype dashboard_uri: str
    :ivar regional_affinity: This property sets the connection region for Playwright client workers
     to cloud-hosted browsers. If enabled, workers connect to browsers in the closest Azure region,
     ensuring lower latency. If disabled, workers connect to browsers in the Azure region in which
     the workspace was initially created. Known values are: "Enabled" and "Disabled".
    :vartype regional_affinity: str or ~azure.mgmt.playwrighttesting.models.EnablementStatus
    :ivar scalable_execution: When enabled, Playwright client workers can connect to cloud-hosted
     browsers. This can increase the number of parallel workers for a test run, significantly
     minimizing test completion durations. Known values are: "Enabled" and "Disabled".
    :vartype scalable_execution: str or ~azure.mgmt.playwrighttesting.models.EnablementStatus
    :ivar reporting: When enabled, this feature allows the workspace to upload and display test
     results, including artifacts like traces and screenshots, in the Playwright portal. This
     enables faster and more efficient troubleshooting. Known values are: "Enabled" and "Disabled".
    :vartype reporting: str or ~azure.mgmt.playwrighttesting.models.EnablementStatus
    :ivar local_auth: When enabled, this feature allows the workspace to use local auth(through
     access key) for authentication of test runs. Known values are: "Enabled" and "Disabled".
    :vartype local_auth: str or ~azure.mgmt.playwrighttesting.models.EnablementStatus
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Creating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.playwrighttesting.models.ProvisioningState
    """

    dashboard_uri: Optional[str] = rest_field(name="dashboardUri", visibility=["read"])
    """The Playwright testing dashboard URI for the account resource."""
    regional_affinity: Optional[Union[str, "_models.EnablementStatus"]] = rest_field(name="regionalAffinity")
    """This property sets the connection region for Playwright client workers to cloud-hosted
     browsers. If enabled, workers connect to browsers in the closest Azure region, ensuring lower
     latency. If disabled, workers connect to browsers in the Azure region in which the workspace
     was initially created. Known values are: \"Enabled\" and \"Disabled\"."""
    scalable_execution: Optional[Union[str, "_models.EnablementStatus"]] = rest_field(name="scalableExecution")
    """When enabled, Playwright client workers can connect to cloud-hosted browsers. This can increase
     the number of parallel workers for a test run, significantly minimizing test completion
     durations. Known values are: \"Enabled\" and \"Disabled\"."""
    reporting: Optional[Union[str, "_models.EnablementStatus"]] = rest_field()
    """When enabled, this feature allows the workspace to upload and display test results, including
     artifacts like traces and screenshots, in the Playwright portal. This enables faster and more
     efficient troubleshooting. Known values are: \"Enabled\" and \"Disabled\"."""
    local_auth: Optional[Union[str, "_models.EnablementStatus"]] = rest_field(name="localAuth")
    """When enabled, this feature allows the workspace to use local auth(through access key) for
     authentication of test runs. Known values are: \"Enabled\" and \"Disabled\"."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Creating\", \"Deleting\", and \"Accepted\"."""

    @overload
    def __init__(
        self,
        *,
        regional_affinity: Optional[Union[str, "_models.EnablementStatus"]] = None,
        scalable_execution: Optional[Union[str, "_models.EnablementStatus"]] = None,
        reporting: Optional[Union[str, "_models.EnablementStatus"]] = None,
        local_auth: Optional[Union[str, "_models.EnablementStatus"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.playwrighttesting.models.SystemData
    """


class AccountQuota(ProxyResource):
    """A quota resource for a Playwright service account.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.playwrighttesting.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.playwrighttesting.models.AccountQuotaProperties
    """

    properties: Optional["_models.AccountQuotaProperties"] = rest_field()
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.AccountQuotaProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AccountQuotaProperties(_model_base.Model):
    """The Playwright service account quota resource properties.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar free_trial: The Playwright service account quota resource free-trial properties.
    :vartype free_trial: ~azure.mgmt.playwrighttesting.models.AccountFreeTrialProperties
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Creating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.playwrighttesting.models.ProvisioningState
    """

    free_trial: Optional["_models.AccountFreeTrialProperties"] = rest_field(name="freeTrial")
    """The Playwright service account quota resource free-trial properties."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Creating\", \"Deleting\", and \"Accepted\"."""

    @overload
    def __init__(
        self,
        *,
        free_trial: Optional["_models.AccountFreeTrialProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AccountUpdate(_model_base.Model):
    """The type used for update operations of the Account.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.playwrighttesting.models.AccountUpdateProperties
    """

    tags: Optional[Dict[str, str]] = rest_field()
    """Resource tags."""
    properties: Optional["_models.AccountUpdateProperties"] = rest_field()
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.AccountUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AccountUpdateProperties(_model_base.Model):
    """The updatable properties of the Account.

    :ivar regional_affinity: This property sets the connection region for Playwright client workers
     to cloud-hosted browsers. If enabled, workers connect to browsers in the closest Azure region,
     ensuring lower latency. If disabled, workers connect to browsers in the Azure region in which
     the workspace was initially created. Known values are: "Enabled" and "Disabled".
    :vartype regional_affinity: str or ~azure.mgmt.playwrighttesting.models.EnablementStatus
    :ivar scalable_execution: When enabled, Playwright client workers can connect to cloud-hosted
     browsers. This can increase the number of parallel workers for a test run, significantly
     minimizing test completion durations. Known values are: "Enabled" and "Disabled".
    :vartype scalable_execution: str or ~azure.mgmt.playwrighttesting.models.EnablementStatus
    :ivar reporting: When enabled, this feature allows the workspace to upload and display test
     results, including artifacts like traces and screenshots, in the Playwright portal. This
     enables faster and more efficient troubleshooting. Known values are: "Enabled" and "Disabled".
    :vartype reporting: str or ~azure.mgmt.playwrighttesting.models.EnablementStatus
    :ivar local_auth: When enabled, this feature allows the workspace to use local auth(through
     access key) for authentication of test runs. Known values are: "Enabled" and "Disabled".
    :vartype local_auth: str or ~azure.mgmt.playwrighttesting.models.EnablementStatus
    """

    regional_affinity: Optional[Union[str, "_models.EnablementStatus"]] = rest_field(name="regionalAffinity")
    """This property sets the connection region for Playwright client workers to cloud-hosted
     browsers. If enabled, workers connect to browsers in the closest Azure region, ensuring lower
     latency. If disabled, workers connect to browsers in the Azure region in which the workspace
     was initially created. Known values are: \"Enabled\" and \"Disabled\"."""
    scalable_execution: Optional[Union[str, "_models.EnablementStatus"]] = rest_field(name="scalableExecution")
    """When enabled, Playwright client workers can connect to cloud-hosted browsers. This can increase
     the number of parallel workers for a test run, significantly minimizing test completion
     durations. Known values are: \"Enabled\" and \"Disabled\"."""
    reporting: Optional[Union[str, "_models.EnablementStatus"]] = rest_field()
    """When enabled, this feature allows the workspace to upload and display test results, including
     artifacts like traces and screenshots, in the Playwright portal. This enables faster and more
     efficient troubleshooting. Known values are: \"Enabled\" and \"Disabled\"."""
    local_auth: Optional[Union[str, "_models.EnablementStatus"]] = rest_field(name="localAuth")
    """When enabled, this feature allows the workspace to use local auth(through access key) for
     authentication of test runs. Known values are: \"Enabled\" and \"Disabled\"."""

    @overload
    def __init__(
        self,
        *,
        regional_affinity: Optional[Union[str, "_models.EnablementStatus"]] = None,
        scalable_execution: Optional[Union[str, "_models.EnablementStatus"]] = None,
        reporting: Optional[Union[str, "_models.EnablementStatus"]] = None,
        local_auth: Optional[Union[str, "_models.EnablementStatus"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CheckNameAvailabilityRequest(_model_base.Model):
    """The check availability request body.

    :ivar name: The name of the resource for which availability needs to be checked.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    """

    name: Optional[str] = rest_field()
    """The name of the resource for which availability needs to be checked."""
    type: Optional[str] = rest_field()
    """The resource type."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CheckNameAvailabilityResponse(_model_base.Model):
    """The check availability result.

    :ivar name_available: Indicates if the resource name is available.
    :vartype name_available: bool
    :ivar reason: The reason why the given name is not available. Known values are: "Invalid" and
     "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.playwrighttesting.models.CheckNameAvailabilityReason
    :ivar message: Detailed reason why the given name is not available.
    :vartype message: str
    """

    name_available: Optional[bool] = rest_field(name="nameAvailable")
    """Indicates if the resource name is available."""
    reason: Optional[Union[str, "_models.CheckNameAvailabilityReason"]] = rest_field()
    """The reason why the given name is not available. Known values are: \"Invalid\" and
     \"AlreadyExists\"."""
    message: Optional[str] = rest_field()
    """Detailed reason why the given name is not available."""

    @overload
    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[Union[str, "_models.CheckNameAvailabilityReason"]] = None,
        message: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_model_base.Model):
    """The resource management error additional info.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_model_base.Model):
    """The error detail.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.playwrighttesting.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.playwrighttesting.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[List["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_model_base.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.playwrighttesting.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field()
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FreeTrialProperties(_model_base.Model):
    """The subscription quota resource free-trial properties.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar account_id: The Playwright service account id. Required.
    :vartype account_id: str
    :ivar state: The free-trial state. Required. Known values are: "Active", "Expired",
     "NotEligible", and "NotRegistered".
    :vartype state: str or ~azure.mgmt.playwrighttesting.models.FreeTrialState
    """

    account_id: str = rest_field(name="accountId", visibility=["read"])
    """The Playwright service account id. Required."""
    state: Union[str, "_models.FreeTrialState"] = rest_field(visibility=["read"])
    """The free-trial state. Required. Known values are: \"Active\", \"Expired\", \"NotEligible\", and
     \"NotRegistered\"."""


class Operation(_model_base.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.playwrighttesting.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.playwrighttesting.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.playwrighttesting.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field()
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType", visibility=["read"])
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_model_base.Model):
    """Localized display information for and operation.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class Quota(ProxyResource):
    """A subscription quota resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.playwrighttesting.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.playwrighttesting.models.QuotaProperties
    """

    properties: Optional["_models.QuotaProperties"] = rest_field()
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.QuotaProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class QuotaProperties(_model_base.Model):
    """The subscription quota resource properties.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar free_trial: The subscription quota resource free-trial properties.
    :vartype free_trial: ~azure.mgmt.playwrighttesting.models.FreeTrialProperties
    :ivar offering_type: Indicates the offering type for the subscription. Known values are:
     "NotApplicable", "PrivatePreview", "PublicPreview", and "GeneralAvailability".
    :vartype offering_type: str or ~azure.mgmt.playwrighttesting.models.OfferingType
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Creating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.playwrighttesting.models.ProvisioningState
    """

    free_trial: Optional["_models.FreeTrialProperties"] = rest_field(name="freeTrial")
    """The subscription quota resource free-trial properties."""
    offering_type: Optional[Union[str, "_models.OfferingType"]] = rest_field(name="offeringType", visibility=["read"])
    """Indicates the offering type for the subscription. Known values are: \"NotApplicable\",
     \"PrivatePreview\", \"PublicPreview\", and \"GeneralAvailability\"."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Creating\", \"Deleting\", and \"Accepted\"."""

    @overload
    def __init__(
        self,
        *,
        free_trial: Optional["_models.FreeTrialProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_model_base.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.playwrighttesting.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.playwrighttesting.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy")
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(name="createdByType")
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(name="createdAt", format="rfc3339")
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(name="lastModifiedBy")
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(name="lastModifiedByType")
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(name="lastModifiedAt", format="rfc3339")
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
