#/*##########################################################################
# Copyright (C) 2004-2020 V.A. Sole, European Synchrotron Radiation Facility
#
# This file is part of the PyMca X-ray Fluorescence Toolkit developed at
# the ESRF by the Software group.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
#############################################################################*/
__author__ = "V.A. Sole - ESRF Data Analysis"
__contact__ = "sole@esrf.fr"
__license__ = "MIT"
__copyright__ = "European Synchrotron Radiation Facility, Grenoble, France"

import logging
import sys

if sys.version_info < (3, ):
    from collections import MutableMapping
else:
    from collections.abc import MutableMapping

_logger = logging.getLogger(__name__)


aspect_ratio = [
#/* columns rows colors chars-per-pixel */
"32 32 5 1",
"  c #47463F",
". c #BA165D",
"X c #2F3AB5",
"o c #FFFFE8",
"O c None",
#/* pixels */
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOXXXXXXXXXXXXXXXXXXXXXXXXXXXXOO",
"OOXooooooooooooooooooooooooooXOO",
"OOXo ......  ooooooooooooooooXOO",
"OOXo. XXXXX.    oooooooooooooXOO",
"OOXo.XXXXXX.ooo   oooooooooooXOO",
"OOXo .. ....oooooo   ooooooooXOO",
"OOXo ooo ooo ooooooo    oooooXOO",
"OOXo  ooo ooo ooooooooo    ooXOO",
"OOXoo oooo                  oXOO",
"OOXoo oooo ................ oXOO",
"OOXoo  ooo ................ oXOO",
"OOXooo ooo ..XXXXXXXXXXXX.. oXOO",
"OOXooo ooo ..XXXXXXXXXXXX.. oXOO",
"OOXooo ooo ..XXXXXXXXXXXX.. oXOO",
"OOXoooo oo ..XXXXXXXXXXXX.. oXOO",
"OOXoooo oo ..XXXXXXXXXXXX.. oXOO",
"OOXoooo oo ..XXXXXXXXXXXX.. oXOO",
"OOXooooo o ..XXXXXXXXXXXX.. oXOO",
"OOXooooo o ..XXXXXXXXXXXX.. oXOO",
"OOXooooo o ..XXXXXXXXXXXX.. oXOO",
"OOXooooo   ..XXXXXXXXXXXX.. oXOO",
"OOXoooooo  ..XXXXXXXXXXXX.. oXOO",
"OOXoooooo  ..XXXXXXXXXXXX.. oXOO",
"OOXoooooo  ................ oXOO",
"OOXooooooo ................ oXOO",
"OOXooooooo                  oXOO",
"OOXooooooooooooooooooooooooooXOO",
"OOXXXXXXXXXXXXXXXXXXXXXXXXXXXXOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO"
]


# --- scan window icons ---
plugin = [
#columns rows colors chars-per-pixel
"32 32 16 1",
"  c #000000",
". c #303030",
"X c #585858",
"o c #c05800",
"O c #ff8000",
"+ c #ffa858",
"@ c #c0c000",
"# c #ffff00",
"$ c #808080",
"% c #a0a0a0",
"& c #ffdca8",
"* c #c3c3c3",
"= c #dcdcdc",
"- c #ffffc0",
"; c #ffffff",
": c None",
# pixels
":::::::::::::::::::::::  :::::::",
":::::::::::::::::::::: -& :  :::",
":::::::::::::::::::    &## &+ ::",
":::::::::::::::::: -&-&&#+&#o ::",
":::::::::::::::::: ###+#@#@+o ::",
"::::::::::::::::::: &&#@ @O@O  :",
":::::::::::::::::: -&#@ : o@+#+ ",
":::::::::::   ::: &&## ::: #+@@ ",
":::::::::: ;;; :: ##@+# : &#@@ :",
"::::: :::: ;;= :::  #@+@ #&+# ::",
":::: ;    ;;;;=     @+@+#&##+# :",
"::: ;;;;;;;====;;;; #oO@+@@@## :",
":: ;;;;;;;===***%%% oo @@@    ::",
"::: ;;;;;;===**%%%%$  : @@ :::::",
"::: ;;;;====**%%%$%$  ::  ::::::",
"::: ;;;;==%XXX%%%%$$  ::::::::::",
"::: ;;===%X   X$$$$$$ ::::::::::",
":  ;;;==%X ::: X$$%$%%  ::::::::",
" ;;;====X ::::: $$$%%%=* :::::::",
" ;;;==**$ ::::: %$%%%%*$ :::::::",
" ;===***% ::::: =%%%%$X$ :::::::",
":  ****%%% ::: ;=%%%$X  ::::::::",
"::: **%%%%%   ;;%%%*$ ::::::::::",
"::: =%%%%$$%;;=%%%*=$ ::::::::::",
"::: =%%%$$%$$%%%%***% ::::::::::",
"::: =%%$$$$%%%%***=== ::::::::::",
":: **%$%$$%$%%%***==== :::::::::",
"::: X    .$%%%$X$%**= ::::::::::",
"::::      X%%$X    = :::::::::::",
"::::: :::: %*$ :::: ::::::::::::",
":::::::::: %X$ :::::::::::::::::",
":::::::::::   ::::::::::::::::::"
]

clipboard = [
"30 30 17 1 ",
"  c #4F4E50",
". c #6E6E70",
"X c #F7941E",
"o c #F89A2B",
"O c #F8A038",
"+ c #F8A848",
"@ c #FAB86A",
"# c #FAC17C",
"$ c #7E7F80",
"% c #919192",
"& c #AEAEAF",
"* c #FBCA8E",
"= c #FCD6A8",
"- c #C0BFC0",
"; c #CECECF",
": c #FEEDD9",
"> c None",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>#@>>>>>>>>>>>>>>",
">>>>>>>>>>>>>>Xo>>>>>>>>>>>>>>",
">>>>>>>>>>>>>:XX:>>>>>>>>>>>>>",
">>>>>>>>>>>>>@*=@>>>>>>>>>>>>>",
">>>>>>>>>>>>:+>>@=>>>>>>>>>>>>",
">>>>>>>::::>Oo:>+o>::::>>>>>>>",
">>>>>>#XoX@*XXXoXX*@XXX@>>>>>>",
">>>>>>oo+@:XXXXXXXX:@+oX>>>>>>",
">>>>>>XO>>>========:>>+X>>>>>>",
">>>>>>XO>>>>>>>>>>>>>>+X>>>>>>",
">>>>>>XO>>>>>>>>>>>>>>+X:>>>>>",
">>>>>>XO>>;;;;:;;-&;>>+X>>>>>>",
">>>>>>XO>>$.    ..%;>>+X>>>>>>",
">>>>>>XO>>>>>>>>>>>>>>OX>>>>>>",
">>>>>>XO>>>;;;----&>>>+X:>>>>>",
">>>>>>XO>>.       .>>>+X>>>>>>",
">>>>>>XO>>;:>>>>>>>>>>+X>>>>>>",
">>>>>>XO>>>;&:>>>>>>>>+X>>>>>>",
">>>>>>XO>>%%%>>>>>>>>>+X:>>>>>",
">>>>>>XO>>>>>>>>>>>>>>+X>>>>>>",
">>>>>>XO>>;........&>>+X>>>>>>",
">>>>>>XO>>%%&%&&&%%;>>+X>>>>>>",
">>>>>>XO>>>>>>>>>>>>>>+X>>>>>>",
">>>>>>XO>>>>>>>>>>>>>>+X>>>>>>",
">>>>>>XO>>>>>>>>>>>>>>+X>>>>>>",
">>>>>>oXooooooooooooooXX:>>>>>",
">>>>>>=OooooooooooooooO#>>>>>>",
">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
]

crop =[
"16 16 2 1",
"   c none",
".  c black",
"                ",
"   ..           ",
"   ..           ",
"   ..           ",
"   ..........   ",
"   ..........   ",
"   ..      ..   ",
"   ..      ..   ",
"   ..      ..   ",
"   ..      ..   ",
"   ..........   ",
"   ..........   ",
"           ..   ",
"           ..   ",
"           ..   ",
"                ",
]

togglepoints =[
"16 16 2 1",
"   c none",
".  c blue",
"                ",
"  .    .        ",
"  .    .        ",
"  .    .        ",
"  .    .        ",
"  .    .        ",
"  .   ...   ... ",
"  .   . .   ... ",
"  .   ...   ... ",
"  .    .        ",
"  .    .        ",
"  .    .        ",
"  .    .        ",
"  .    .        ",
"  .    .        ",
"                "
]

square16 =[
"16 16 2 1",
"  c none",
"X c blue",
"                ",
" XXXXXXXXXXXXXX ",
" X            X ",
" X            X ",
" X            X ",
" X            X ",
" X            X ",
" X            X ",
" X            X ",
" X            X ",
" X            X ",
" X            X ",
" X            X ",
" X            X ",
" XXXXXXXXXXXXXX ",
"                "
]


rectangle16 =[
"16 16 2 1",
"  c none",
"X c blue",
"                ",
"                ",
"                ",
" XXXXXXXXXXXXXX ",
" X            X ",
" X            X ",
" X            X ",
" X            X ",
" X            X ",
" X            X ",
" X            X ",
" X            X ",
" XXXXXXXXXXXXXX ",
"                ",
"                ",
"                "
]


polygon16 =[
"16 16 2 1",
"  c none",
"X c blue",
"                ",
"       XX       ",
"      X  X      ",
"     X    X     ",
"    X      X    ",
"   X        X   ",
"  X         X   ",
" X         X    ",
"  X       X     ",
"   X      X     ",
"    X     X     ",
"     X     X    ",
"    X       X   ",
"   X         X  ",
"   XXXXXXXXXXX  ",
"                "
]


circle16 =[
"16 16 2 1",
"  c none",
"X c blue",
"                ",
"     XXXXXX     ",
"    X      X    ",
"   X        X   ",
"  X          X  ",
" X            X ",
" X            X ",
" X            X ",
" X            X ",
" X            X ",
" X            X ",
"  X          X  ",
"   X        X   ",
"    X      X    ",
"     XXXXXX     ",
"                "
]

ellipse16 =[
"16 16 2 1",
"  c none",
"X c blue",
"                ",
"                ",
"                ",
"                ",
"     XXXXXX     ",
"   X        X   ",
"  X          X  ",
" X            X ",
" X            X ",
" X            X ",
"  X          X  ",
"   X        X   ",
"     XXXXXX     ",
"                ",
"                ",
"                ",
]

solid_circle16 =[
"16 16 2 1",
"  c none",
"X c blue",
"                ",
"     XXXXXX     ",
"    XXXXXXXX    ",
"   XXXXXXXXXX   ",
"  XXXXXXXXXXXX  ",
" XXXXXXXXXXXXXX ",
" XXXXXXXXXXXXXX ",
" XXXXXXXXXXXXXX ",
" XXXXXXXXXXXXXX ",
" XXXXXXXXXXXXXX ",
" XXXXXXXXXXXXXX ",
"  XXXXXXXXXXXX  ",
"   XXXXXXXXXX   ",
"    XXXXXXXX    ",
"     XXXXXX     ",
"                "
]

solid_ellipse16 =[
"16 16 2 1",
"  c none",
"X c blue",
"                ",
"                ",
"                ",
"                ",
"     XXXXXX     ",
"   XXXXXXXXXX   ",
"  XXXXXXXXXXXX  ",
" XXXXXXXXXXXXXX ",
" XXXXXXXXXXXXXX ",
" XXXXXXXXXXXXXX ",
"  XXXXXXXXXXXX  ",
"   XXXXXXXXXX   ",
"     XXXXXX     ",
"                ",
"                ",
"                ",
]


subtract =[
"16 16 2 1",
"  c none",
". c blue",
"                ",
"  ..........    ",
"  .         .   ",
"  .          .  ",
"  .          .  ",
"  .          .  ",
"  .         .   ",
"  ..........    ",
"  .         .   ",
"  .          .  ",
"  .          .  ",
"  .          .  ",
"  .          .  ",
"  .         .   ",
"  ..........    ",
"                "
]

substract = subtract

smooth = [
"16 16 3 1",
"O c none",
"* c yellow",
": c blue",
"OOOOOOOOOOOOOOOO",
"OOOO**OOO*:OOOOO",
"OOOOO**O*::OOOOO",
"OOOO::***:O:OOOO",
"OOOO::O**OO:OOOO",
"OOO:O:****OO:OOO",
"OOO:OO*:O**O:OOO",
"OO:OO**OOOOO:OOO",
"OO:OO*OOOOOO:OOO",
"O:OOOOOOOOOO::OO",
"O:OOOOOOOOOOO:OO",
"O:OOOOOOOOOOO::O",
"OOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOO"
]



derive = [
"16 16 2 1",
"   c None",
".  c blue",
"                ",
"  ..   .        ",
" .  .  .        ",
" .              ",
" .              ",
" .              ",
" .   .       .  ",
" .. .  .   .  . ",
" .  .   . .   . ",
" .  .    .    . ",
" .  .   . .   . ",
" .  .  .   .  . ",
" .   .       .  ",
"                ",
"                ",
"                "
]

swapsign = [
"16 16 3 1",
"   c None",
".  c blue",
"X  c red",
"                ",
"                ",
"             XX ",
"      XXX   XX  ",
"    XXX XX XX   ",
"   XX    XXX    ",
" XXX            ",
"                ",
" .............. ",
"                ",
" ...            ",
"   ..    ...    ",
"    ... .. ..   ",
"      ...   ..  ",
"             .. ",
"                "
]

ymintozero = [
"16 16 3 1",
"   c None",
"X  c blue",
".  c red",
"                ",
"                ",
"                ",
"                ",
"             XX ",
"      XXX   XX  ",
"    XXX XX XX   ",
"   XX    XXX    ",
"  XX            ",
" XX             ",
" X............. ",
"                ",
"                ",
"                ",
"                ",
"                ",
]

"""
average16=[
"16 16 2 1",
". c blue",
"  c None",
"                ",
" .............. ",
"                ",
" ..         ..  ",
"  ..       ..   ",
"   ..     ..    ",
"    ..   ..     ",
"     .. ..      ",
"      ...       ",
"      ..        ",
"     ..         ",
"    ..          ",
"   ..           ",
"  ..            ",
" ..             ",
"                "
]
"""
average16=[
"16 16 2 1",
". c blue",
"  c None",
"                ",
" .............. ",
"                ",
"  .          .  ",
"   .        .   ",
"    .      .    ",
"     .    .     ",
"      .  .      ",
"       ..       ",
"       .        ",
"      .         ",
"     .          ",
"    .           ",
"   .            ",
"  .             ",
"                "
]

horizontal=[
"16 16 2 1",
". c blue",
"  c None",
"                ",
"                ",
"                ",
"                ",
"                ",
"                ",
"                ",
" .............. ",
" .............. ",
"                ",
"                ",
"                ",
"                ",
"                ",
"                ",
"                "
]

vertical=[
"16 16 2 1",
". c blue",
"  c None",
"                ",
"       ..       ",
"       ..       ",
"       ..       ",
"       ..       ",
"       ..       ",
"       ..       ",
"       ..       ",
"       ..       ",
"       ..       ",
"       ..       ",
"       ..       ",
"       ..       ",
"       ..       ",
"       ..       ",
"                "
]

diagonal =[
"16 16 2 1",
". c blue",
"  c None",
"                ",
" ..             ",
"  ..            ",
"   ..           ",
"    ..          ",
"     ..         ",
"      ..        ",
"       ..       ",
"        ..      ",
"         ..     ",
"          ..    ",
"           ..   ",
"            ..  ",
"             .. ",
"              . ",
"                "
]

# -------------------------
sliderson=[
"16 16 2 1",
"  c blue",
". c None",
"................",
"...  .....  ....",
".  ..     ..  ..",
"...  .....  ....",
"................",
"................",
"...  .....  ....",
".  ..     ..  ..",
"...  .....  ....",
"................",
"................",
"...  .....  ....",
".  ..     ..  ..",
"...  .....  ....",
"................",
"................"
]

slidersoff = [
"16 16 3 1",
"  c blue",
". c red",
"X c None",
"XXXXXXXXXXXXXXXX",
"X..  XXXXX  XX.X",
"X ..X     XX ..X",
"XXX..XXXXX  ..XX",
"XXXX..XXXXX..XXX",
"XXXXX..XXX..XXXX",
"XXX  X..X.. XXXX",
"X  XX  ...XX  XX",
"XXX  XX...  XXXX",
"XXXXXX..X..XXXXX",
"XXXXX..XXX..XXXX",
"XXX ..XXXX ..XXX",
"X  ..     XX..XX",
"XX.. XXXXX  X..X",
"X..XXXXXXXXXXX.X",
"XXXXXXXXXXXXXXXX"
]

remove = [
"16 16 3 1",
"O c #ffc0c0",
"+ c None",
"X c red",
"++++++++++++++++",
"+XX++++++++++XX+",
"++XX+++++++OXX++",
"+++XX+++++OXX+++",
"++++XXO++OXX++++",
"+++++XX.OXX+++++",
"++++++XXXX++++++",
"++++++OXX+++++++",
"+++++OXXXX++++++",
"++++OXX+OXX+++++",
"+++OXX+++OXX++++",
"+++XX+++++OXX+++",
"++XX+++++++OXX++",
"+XX++++++++++XX+",
"++++++++++++++++",
"++++++++++++++++"
]

sigma=[
"16 16 2 1",
"  c blue",
". c None",
"................",
"....          ..",
"....  ..........",
".....  .........",
"......  ........",
".......  .......",
"........  ......",
".......  .......",
"......  ........",
".....  .........",
"....  ..........",
"...  ...........",
"..  ............",
".  .............",
".             ..",
"................"
]


normalize16=[
"16 16 2 1",
"  c none",
". c blue",
"                ",
" ...            ",
"  .    .     .  ",
"  .   .  . .  . ",
"  .   .   .   . ",
"  .   .  . .  . ",
" ...   .     .  ",
"                ",
" .............. ",
"                ",
"     .   .      ",
"     ..  .      ",
"     . . .      ",
"     .  ..      ",
"     .   .      ",
"                "
]

#grid
grid16 = [
"16 16 2 1",
"   c none",
".  c blue",
"                ",
"  .    .    .   ",
" .............  ",
"  .    .    .   ",
"  .    .    .   ",
"  .    .    .   ",
"  .    .    .   ",
" .............  ",
"  .    .    .   ",
"  .    .    .   ",
"  .    .    .   ",
"  .    .    .   ",
" .............  ",
"  .    .    .   ",
"                ",
"                "
]

rgb = [
"23 23 65 1 ",
"  c #FE0201",
". c #FE0D1A",
"X c #FE2323",
"o c #FE5801",
"O c #FE4000",
"+ c #FE6403",
"@ c #FE006C",
"# c #FE5959",
"$ c #FE7575",
"% c #FE6666",
"& c #02FE02",
"* c #08FC10",
"= c #17FE17",
"- c #29FE29",
"; c #77FD01",
": c #4BFF37",
"> c #00FE55",
", c #05FE6A",
"< c #6DFE6D",
"1 c #54FE54",
"2 c #B6FD00",
"3 c #FEDC00",
"4 c #C2FE03",
"5 c #FDFD01",
"6 c #EEFF01",
"7 c #FFFD36",
"8 c #FEA348",
"9 c #BBFE73",
"0 c #0101FE",
"q c #100FFD",
"w c #2D01FE",
"e c #3131FD",
"r c #6B00FA",
"t c #0054FE",
"y c #056BFE",
"u c #4646FE",
"i c #7A7AFE",
"p c #FE029A",
"a c #E800FE",
"s c #FD01FD",
"d c #FE1AFE",
"f c #FE01EC",
"g c #A756EA",
"h c #01FDFD",
"j c #00F3F3",
"k c #23FCFC",
"l c #FE9999",
"z c #FF938B",
"x c #FDB0B0",
"c c #AFFEAF",
"v c #B4FEB5",
"b c #8CFE8C",
"n c #C3FEB2",
"m c #8D8CFE",
"M c #BABAFE",
"N c #FDA5FE",
"B c #CBB9FE",
"V c #FED5D5",
"C c #DAFEDA",
"Z c #CBFECB",
"A c #FDFFD6",
"S c #CCCEFE",
"D c #E5FEE5",
"F c #FEFDFE",
"G c #FEEFF0",
"FFFFFFFFFFFGGFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFFFF",
"FFFFFFFFFFVl$lVFFFFFFFF",
"FFFFFFFFF$.   .$FFFFFFF",
"FFFFFFFF#       %FFFFFF",
"FFFFFFFz         lFGFFF",
"FFFFFFGX         XFFFFF",
"FFFFFFx           VFFFF",
"FFFFGFz           lFFFF",
"FFFFFSgpp@.    O+oxFFFF",
"FFFFm00assf@ o3556:cFFF",
"FFFm000rsssd855562&&bFF",
"FFS0000qassNA5552&&&&cF",
"FFi00000wadFF752&&&&&-F",
"FFe000000wgFF9;&&&&&&&C",
"FFe0000000ykk,&&&&&&&&c",
"FFu0000000yhh,&&&&&&&&v",
"FFm0000000thh>&&&&&&&&D",
"FFFq000000qjj*&&&&&*&1F",
"FFFMq000000y,&&&&&&&=CF",
"FFFFSe0000eBn*&&&&&=ZFF",
"FFFFFFMiiMFFFC<-*-<DFFF",
"FFFFFFFFFFFFFFFFDFFFFFF"
]

rgb16 = [
"16 16 76 1",
"  c #01560165fef64048",
". c #0ed70f25fe590000",
"X c #28e128e1fefe0000",
"o c #06ae619cfbe30000",
"O c #00007fc6fab60000",
"+ c #69dc005cfbfa0000",
"@ c #5346569ffef20000",
"# c #62275eccfe640000",
"$ c #6087607ffef40000",
"% c #69667d4dfabbffff",
"& c #0192fee801e7ffff",
"* c #1c5cfefe1c5c0000",
"= c #236cff72002b0000",
"- c #2655fefe26550000",
"; c #0614fbe761450000",
": c #0000fab67e310000",
"> c #4236fe2703600000",
", c #4277fe3f3f5c0000",
"< c #552dfef152f20000",
"1 c #5fd6fefe5fd6dfdf",
"2 c #6b9afefe6b9a0000",
"3 c #744ffd547d650000",
"4 c #06b6d838d82a0000",
"5 c #00b9ff72ff860000",
"6 c #717afa5a81ae4048",
"7 c #fef6014101a80000",
"8 c #ff2b09e5018f0000",
"9 c #fefe0af30af3abac",
"0 c #fefc0000378d2e42",
"q c #fdfa2a4300000000",
"w c #fe5826312b410000",
"e c #fefe2c822c820000",
"r c #ffff401b22c70000",
"t c #fefe309830980000",
"y c #ff43027d42080000",
"u c #ffff00b851150000",
"i c #ff36693400000000",
"p c #fefe540254020000",
"a c #fee37bc87a200000",
"s c #a94f0000fed80000",
"d c #fceb016cd5070000",
"f c #e15301d2ffff0000",
"g c #f8ac00c3ffff0000",
"h c #fef20103fd940000",
"j c #ffff3b7bfa680000",
"k c #afdefbc60bd90000",
"l c #faf1de1b03030000",
"z c #f11cfda800870000",
"x c #fffffecc012a0000",
"c c #f9e5ffff0c990000",
"v c #fffffbb553fc0000",
"b c #a092a092fefe0000",
"n c #a438a438fefe0000",
"m c #aa46aa46fefe0000",
"M c #b746b746fefe0000",
"N c #9065fefe906c0000",
"B c #9893fefe98930000",
"V c #b42bfefeb42a0000",
"C c #c08aff34c0690000",
"Z c #a7befe60fea20000",
"A c #fefeb5e0b5e00000",
"S c #d377918acd300000",
"D c #fb72a8f9de230000",
"F c #dc66dc69fefe0000",
"G c #d2fbfefed2fb0000",
"H c #d30ce56ee5220000",
"J c #ffffd295c67e0000",
"K c #fefedd48dd480000",
"L c #edd2edc2ff190000",
"P c #ee6ffefeee6f0000",
"I c #fefee6bee6be0000",
"U c #fefeec81ec810000",
"Y c #f88bf876ff300000",
"T c #f793fefef7930000",
"R c #fe6bf783fcf70000",
#"E c #fed4fe9efea70000",
"E c none",
"EEEEEEREEEREEEEE",
"EEEEEEEEKIEEEEEE",
"EEEEEEAt79pIEEEE",
"EEEEEA77777eUEEE",
"EEEERw777777aERE",
"EEEEJ7777777wTEE",
"EEEESuy7778qrREE",
"EEY@ fhd0ilxk3EE",
"YE$  +hgDcxz=&<E",
"EF    sjEvz>&&&V",
"Em     %Z6=&&&&2",
"EM     O5:&&&&&1",
"EL.    o5;&&&&&B",
"YEb     4&&&&&*P",
"EEEnX .#H,&&&-GE",
"EEEEEFLEEECNVTEE"
]

eraseselect = [
"24 24 90 1 ",
"  c #08720C",
". c #1B641D",
"X c #4B550B",
"o c #527000",
"O c #637701",
"+ c #69710E",
"@ c #67480B",
"# c #18344E",
"$ c #0D104B",
"% c #00726B",
"& c #0C6950",
"* c #2C220D",
"= c #A67E00",
"- c #2CB905",
"; c #0D9C1D",
": c #708F03",
"> c #4FB000",
", c #6EB700",
"< c #5E9C18",
"1 c #0ECF17",
"2 c #10FE16",
"3 c #2DFD0A",
"4 c #0DFA32",
"5 c #29F92C",
"6 c #1ACD17",
"7 c #4DFB0A",
"8 c #70FB0B",
"9 c #63DD1C",
"0 c #1A9A66",
"q c #59A064",
"w c #03CA4F",
"e c #09FA53",
"r c #37DB6B",
"t c #01FF77",
"y c #0EDE6A",
"u c #4FE856",
"i c #92B600",
"p c #B0A100",
"a c #99E10E",
"s c #B8B95B",
"d c #B5B46F",
"f c #939C7B",
"g c #88D07A",
"h c #CFCE6A",
"j c #E4E37A",
"k c #246EA6",
"l c #5C62B3",
"z c #3D06FE",
"x c #3518FE",
"c c #3114F3",
"v c #2B25FF",
"b c #3324F9",
"n c #2C36F7",
"m c #241FD1",
"M c #4100FE",
"N c #4D16EA",
"B c #542CD8",
"V c #1870D1",
"C c #276AD3",
"Z c #264EF2",
"A c #1573FC",
"S c #2357E5",
"D c #4228AC",
"F c #8774A4",
"G c #03A58C",
"H c #30AB94",
"J c #048DB0",
"K c #0BB3B2",
"L c #259B96",
"P c #66A09F",
"I c #01F8AF",
"U c #11DF90",
"Y c #44CDBB",
"T c #1C8BCC",
"R c #0C90FB",
"E c #04ABFC",
"W c #03B7FA",
"Q c #07ABE7",
"! c #19B4D0",
"~ c #02D0CD",
"^ c #05F8D5",
"/ c #04D0F7",
"( c #03EFED",
") c #34C4C4",
"_ c #B1AD91",
"` c #91A7A6",
"' c #8D9F8B",
"] c #C6CA82",
"[ c #F2F184",
"{ c #D1E283",
"MMMMMMMMMMMMbbxMMMMMMMMM",
"MMMMMMMMMMnSVVCZnxMMMMMM",
"MMMMMMMMbSTKyyUKVZxzMMMM",
"MMMMMMcZTHr5654eUTSNNNNN",
"MMzzzcCHru732244rP`FFlBB",
"MMzzcCHua8734eyrgh]]dfFB",
"MMMckL<ia9611wrgj[jhhslB",
"MzcD#.::O-;;;qg{[jjhsFBN",
"zcm$*@Oo.  &&f]j[jhsfBNM",
"Mnm#@p:>-;;0q'__]dsflNMM",
"znV#+pi>-1;q'____fPPSxMM",
"xSJ#+i,-1w0L'````P)RAxMM",
"vVG.oi,-1wGJkPYY))WEAxMM",
"vV0.Oi>-1wGJkK^~//WERbMM",
"vk0X+i>-1wGJJ~(///WEAxMM",
"clqXO,>-;w0GKKKKQWERZzMM",
"cCqXo<. ;;&&0%%kkEEAvzzz",
"clq++o.   &&%%%%kQRZxzzz",
"zmqiaa9614yyI~~~QWRZzMzz",
"znLaaa732etI^^((/WAnzMMM",
"MbCHaa832etII^((/RZxMMMM",
"MMbTHua734eUI^^(WZxMMMMM",
"MMNnTHuu535etI~QAbzMMMMM",
"MMMMnR)Ue735eU!ZbMMMMMMM"
]

additionalselect = [
"24 24 74 1 ",
"  c #ED1C24",
". c #1DFF0F",
"X c #08FF1B",
"o c #16FF1B",
"O c #27FF08",
"+ c #37FF09",
"@ c #2CFF16",
"# c #0AFF28",
"$ c #17FC26",
"% c #06FD38",
"& c #2AF92D",
"* c #49FF02",
"= c #5AFF01",
"- c #69FE01",
"; c #79FE00",
": c #79FD17",
"> c #75E139",
", c #6AB857",
"< c #51B372",
"1 c #01FF49",
"2 c #11F74E",
"3 c #02FF58",
"4 c #02FD67",
"5 c #01FE78",
"6 c #56E355",
"7 c #8FFD05",
"8 c #A8FA01",
"9 c #B4F605",
"0 c #93D330",
"q c #D0CF0F",
"w c #CFEE02",
"e c #C7F700",
"r c #E3E300",
"t c #88B851",
"y c #2F6CB9",
"u c #4562B9",
"i c #3D07FF",
"p c #291CFF",
"a c #3618FE",
"s c #3237E5",
"d c #2C25FF",
"f c #3325F9",
"g c #2C35FC",
"h c #4100FF",
"j c #3057CF",
"k c #1A71D1",
"l c #266BD4",
"z c #1C58FA",
"x c #2453EC",
"c c #244BFB",
"v c #1979EC",
"b c #34B08D",
"n c #32A6AE",
"m c #1FD38B",
"M c #00FF86",
"N c #00FB9A",
"B c #00DCBB",
"V c #01E3AB",
"C c #00FBA6",
"Z c #00FEB7",
"A c #1D91CD",
"S c #0E91FA",
"D c #10A5E0",
"F c #04AAFE",
"G c #01BBFD",
"H c #19C9CC",
"J c #00FAC8",
"K c #00F9D7",
"L c #00C8FE",
"P c #00D8FB",
"I c #00E8E9",
"U c #00F8E7",
"Y c #00E8F9",
"T c #00F6F3",
"hhhhhhhhhhhiddaihhhhhhih",
"hhhhhhhhiagxkkjxdphhhhhh",
"hhhihhhifx    mAAcahhhhh",
"hhhhhia          Dzahhhh",
"hhhhif             cihhh",
"hhiif     *OX2      ahhh",
"hhha    8-O#%4MN    fihh",
"hia    97*o%3MCVJ    ihh",
"hhg   w8=.#  CZJUY   ahh",
"hfl   w;+X1  ZJKTP    hh",
"hc   r8-@%5  KKUTPL   hh",
"hx   w7*        TYL   hh",
"fk   e7*        TYL   hh",
"dk   e;+$4B  PTTYPG   hh",
"fy,   -+$4V  YTTPL    hh",
"pu,   -+#3C  TTYPL   ahh",
"put    +X3MZJUTPL    iih",
"iu,q    X15CZKTP    aihh",
"ij<q      5CJK      ihhh",
"isy08              ghhhh",
"hfl<>7-          Scahhhh",
"hhslb>:=@      IFzfhhhhh",
"hhhcln66&@&25CHSzfhhhhhh",
"hhhhgvHN2@@&2VDxfhhhhhhh"
]

brushselect = [
"24 24 89 1 ",
"  c #002F35",
". c #0E2B10",
"X c #0B4F08",
"o c #3B4F00",
"O c #09700E",
"+ c #2B6D00",
"@ c #00582D",
"# c #017230",
"$ c #6C6A00",
"% c #043258",
"& c #005A56",
"* c #004C4B",
"= c #036947",
"- c #00516A",
"; c #007676",
": c #02736C",
"> c #897201",
", c #119508",
"< c #328C02",
"1 c #0DB619",
"2 c #0C8039",
"3 c #02B132",
"4 c #28B105",
"5 c #5E9D15",
"6 c #10CA1C",
"7 c #2EFF0F",
"8 c #0CFF30",
"9 c #1BF01F",
"0 c #59FC01",
"q c #6BDE11",
"w c #00904F",
"e c #01AF4C",
"r c #06896E",
"t c #00B471",
"y c #38BB69",
"u c #51B372",
"i c #66B657",
"p c #03CF53",
"a c #0BFA52",
"s c #04C87B",
"d c #03FF75",
"f c #27FE51",
"g c #5CE556",
"h c #A99E14",
"j c #A7F202",
"k c #9ED818",
"l c #D3CE0C",
"z c #D1EC03",
"x c #88B851",
"c c #C5B310",
"v c #025D97",
"b c #13759E",
"n c #4563B9",
"m c #3D07FE",
"M c #3519FE",
"N c #2C1DF5",
"B c #2B25FF",
"V c #3425FA",
"C c #2B37F5",
"Z c #222BD3",
"A c #4100FF",
"S c #1172CF",
"D c #276AD2",
"F c #1B59F7",
"G c #244CFA",
"H c #2453EF",
"J c #1573FA",
"K c #1C52CB",
"L c #142B89",
"P c #00AF8E",
"I c #028DAF",
"U c #02AEAF",
"Y c #32A7AF",
"T c #279894",
"R c #41AD8C",
"E c #06CB8E",
"W c #00FF8F",
"Q c #01D0AD",
"! c #01F3AD",
"~ c #33D88C",
"^ c #02B6CF",
"/ c #0C91F4",
"( c #06ABF3",
") c #1A89D7",
"_ c #03CCD1",
"` c #00FBD3",
"' c #00CEFA",
"] c #00F1F2",
"[ c #29C5C2",
"AAAAAAAAAAAMBVMAAAAAAAAA",
"AAAAAAAAAMCHSSDHVMAAAAAA",
"AAAAmmmmNCSYssPY)HMmAAAA",
"AAAAAmNGSb:#166aE^FNAAAA",
"AAAAmVDbr=@X,,,1p!(GmAAA",
"AAmmVDR5<+XXOO@#es^FMAAA",
"AAAMDukk5<,133w=@=bKVAAA",
"AmMDRgzkq<,33tPr:= LZmAA",
"AAGYilzjqX#etsPPr& %ZmAA",
"AVDuklzq<.@etEP:@ %vFmAA",
"AGDxch$+OOwtPQP&*:I/JMmA",
"AHYh>$.XO3tPI^U&;^'(JMmA",
"VDRh>o+<1ePbIUU&;^((/VAA",
"VDyh$o<46ePII^Q&*;I//VAA",
"Cnyh$o<46ptIIUU:  -SJAAA",
"Bnic>o+,6pt:**:I- -SFAAA",
"Bnxlc5oXOew=***-*%vFBmmm",
"Mnilzk+XX2w=r:&--vSFMmAm",
"mKulzjq,O##wPQ_^^(/GmmAA",
"mCTxjj0463es!`]]'(JCmAAA",
"AVDuqj0088dW!`]]'/GMAAAA",
"AAV)~gq078aW!!`](FVAAAAA",
"AAAGDYggf78fd!_)FVAAAAAA",
"AAAAC/[Wf709f!(HVAAAAAAA"
]

image = [
"24 24 85 1 ",
"  c #08FF1B",
". c #16FF1B",
"X c #1DFF0F",
"o c #27FF08",
"O c #37FF09",
"+ c #2CFF16",
"@ c #0AFF28",
"# c #06FD38",
"$ c #17FC26",
"% c #2AF92D",
"& c #49FF02",
"* c #5AFF01",
"= c #47FC1F",
"- c #69FE01",
"; c #79FE00",
": c #79FD17",
"> c #75E139",
", c #3FBF68",
"< c #51B372",
"1 c #6AB857",
"2 c #01FF49",
"3 c #02FF58",
"4 c #11F74E",
"5 c #02FD67",
"6 c #01FE78",
"7 c #1BDE6A",
"8 c #56E355",
"9 c #B3AF30",
"0 c #BDCB18",
"q c #8FFD05",
"w c #A8FA01",
"e c #B4F605",
"r c #93D330",
"t c #D0CF0F",
"y c #E7DC00",
"u c #E4CC0A",
"i c #C7F700",
"p c #CFEE02",
"a c #E3E300",
"s c #88B851",
"d c #4562B9",
"f c #3D07FF",
"g c #3618FE",
"h c #291CFF",
"j c #2C25FF",
"k c #3325F9",
"l c #2C35FC",
"z c #3237E5",
"x c #4100FF",
"c c #3057CF",
"v c #1A71D1",
"b c #266BD4",
"n c #1C58FA",
"m c #244BFB",
"M c #2453EC",
"N c #156AFE",
"B c #1575FE",
"V c #1979EC",
"C c #2F6CB9",
"Z c #34B08D",
"A c #32A6AE",
"S c #28A2A8",
"D c #00FF86",
"F c #00FB9A",
"G c #00DCBB",
"H c #00FBA6",
"J c #00FEB7",
"K c #01E3AB",
"L c #1FD38B",
"P c #0E91FA",
"I c #04AAFE",
"U c #01BBFD",
"Y c #10A5E0",
"T c #1D91CD",
"R c #00FAC8",
"E c #00F9D7",
"W c #00E0DB",
"Q c #00C8FE",
"! c #00D8FB",
"~ c #00D1E0",
"^ c #00E8E9",
"/ c #00F8E7",
"( c #00E8F9",
") c #00F6F3",
"_ c #19C9CC",
"xxxxxxxxxxxfjjgfxxxxxxfx",
"xxxxxxxxfglMvvcMjhxxxxxx",
"xxxfxxxfkMvS77LTTmgxxxxx",
"xxxxxfgMTZ7%$$@27Yngxxxx",
"xxxxfkcS88=O  ##5KYmfxxx",
"xxffkcZ>;;&o 4356F~Ngxxx",
"xxxgbZrew-o@#5DFFH^Pkfxx",
"xfgbZ>peq&.#3DHKRE(Plfxx",
"xxlA1tpw*X@36HJR/((Imgxx",
"xkb<0up;O 26FJRE)!!INgxx",
"xmTstaw-+#6KREE/)!QINgxx",
"xMA9ypq&.2FW!))))(QINgxx",
"kvZ9yiq&.5KQU!/))(QIPxxx",
"jv,tyi;O$5GUU!))(!UIPkxx",
"kC1tyi-O$5KQ!())!QUIBxxx",
"hd1tye-O@3HR^))(!QUPmgxx",
"hdsuae-O 3DJR/)!QQINlffx",
"fd1tpw-o 26HJE)!QUPngfxx",
"fc<tiw*o@26HRE)!QUPmfxxx",
"fzCrww*o 26FJE)(QIBlxxxx",
"xkb<>q-+ #5FJR/)!Pmgxxxx",
"xxzbZ>:*+$3DHJE^Inkxxxxx",
"xxxmbA88%+%46H_Pnkxxxxxx",
"xxxxlV_F4++%4KYMkxxxxxxx"
]

boxselect = [
"24 24 90 1 ",
"  c #113B1A",
". c #085208",
"X c #097109",
"o c #357100",
"O c #005533",
"+ c #007631",
"@ c #4F7200",
"# c #5D5E00",
"$ c #007C53",
"% c #00566D",
"& c #006D6E",
"* c #004C56",
"= c #003F65",
"- c #0B890D",
"; c #0BB013",
": c #008B2E",
"> c #02B53A",
", c #278600",
"< c #589106",
"1 c #10C613",
"2 c #11FD16",
"3 c #2EFE0D",
"4 c #06FB39",
"5 c #11FD25",
"6 c #2AF92E",
"7 c #13D21F",
"8 c #4DFB0C",
"9 c #71FB0B",
"0 c #6DCD38",
"q c #65DB12",
"w c #00B852",
"e c #019176",
"r c #00B776",
"t c #20AE5C",
"y c #5BB567",
"u c #01CB4F",
"i c #09F953",
"p c #03D077",
"a c #02FD6B",
"s c #2CED5C",
"d c #56E456",
"f c #AFB324",
"g c #D4B101",
"h c #9BD604",
"j c #B4D207",
"k c #9AE713",
"l c #E5D507",
"z c #D6DC06",
"x c #88B851",
"c c #01738B",
"v c #306DB9",
"b c #4762B9",
"n c #3D07FF",
"m c #3519FE",
"M c #2D1BFF",
"N c #2C25FF",
"B c #3424FA",
"V c #2B36FC",
"C c #3038E5",
"Z c #4100FF",
"A c #1673D3",
"S c #2769D4",
"D c #1C5BFC",
"F c #244BFB",
"G c #2453EF",
"H c #1373FA",
"J c #3353CF",
"K c #00968C",
"L c #01B38C",
"P c #33AE8F",
"I c #0097B1",
"U c #00B5B8",
"Y c #04ADAE",
"T c #33A0AC",
"R c #08D488",
"E c #01F791",
"W c #00C3B2",
"Q c #01F3AC",
"! c #33D78C",
"~ c #0892D1",
"^ c #03AAD3",
"/ c #1092F9",
"( c #05ABFE",
") c #04B4FF",
"_ c #328BCE",
"` c #02CAD4",
"' c #00D4EB",
"] c #00F0F0",
"[ c #0EEACA",
"{ c #45A692",
"ZZZZZZZZZZZnNBmZZZZZZZZZ",
"ZZZZZZZZZmBGAASGBmZZZZZZ",
"ZZZZZZZZBG~YppLT_FmZZZZZ",
"ZZZZZZmG_Ps6654iR^DmZZZZ",
"ZZZZnBSPdd833544aQ/FZZZZ",
"ZZZnBJP0998324iiaE`HmZZZ",
"ZZZmSP0jhq777upppE'/BZZZ",
"ZnmS{0<#@o--:+$$ee'/FZZZ",
"ZnFT0f# ...OOOOOO*^)DmZZ",
"ZBSyfg#o;;>wrrLL&%^)HmZZ",
"ZF_xlg@,17wrLWYYe&^(HmZZ",
"nGTflz@,;>rIIYYYcc^(HmZZ",
"mAPflj@X;>KIIIYL&%^(HmZZ",
"NAyjlj@-;wL~~YYY&%~)/BZZ",
"Mvyzlj@-;uLIYUWUc%^(HZZZ",
"Mbxllho-1upLYU`^cc~/DZZZ",
"Mbxllh@X-:weKKKK%*~HNnnn",
"Mbyzzho.XX+$e&&%*=ADMnZn",
"nJyjzk<XX++$$&&&%cHFnnZZ",
"nCvxkkq11>wprRUU^~HNnZZZ",
"nBSykk9324aEQ[]]'(FmZZZZ",
"ZnBA!d9825iEQQ[](DBZZZZZ",
"ZZnVSPdd635iEQ`/DBZZZZZZ",
"ZZZZV/[!s836aQ^GBZZZZZZZ"
]

brush = [
"16 16 73 1",
"  c #0B0B00",
". c #0F0F06",
"X c #101000",
"o c #111100",
"O c #121200",
"+ c #373737",
"@ c #51510D",
"# c #52520D",
"$ c #53530D",
"% c #4D4D37",
"& c #4E4E37",
"* c #4F4F39",
"= c #5A5A2B",
"- c #616104",
"; c #666611",
": c #727207",
"> c #616122",
", c #444445",
"< c #464646",
"1 c #4A4A4A",
"2 c #4D4D4D",
"3 c #515151",
"4 c #5C5C5C",
"5 c #676744",
"6 c #616162",
"7 c #6E6E6E",
"8 c #737373",
"9 c #757575",
"0 c #7C7C71",
"q c #7B7B7B",
"w c #9E9E00",
"e c #ADAD00",
"r c #B2B200",
"t c #B5B500",
"y c #888884",
"u c #8B8B8C",
"i c #8D8D8E",
"p c #8D8D8F",
"a c #8E8E90",
"s c #949498",
"d c #9A9A9A",
"f c #9C9C9C",
"g c #9F9F9F",
"h c #A2A2A3",
"j c #A6A6A7",
"k c #AAAAAF",
"l c #ADADB1",
"z c #AEAEB1",
"x c #B3B3B3",
"c c #B5B5B5",
"v c #B5B5B6",
"b c #B8B8B8",
"n c #B9B9B9",
"m c #BABABA",
"M c #B9B9BC",
"N c #BCBCBC",
"B c #C1C1C1",
"V c #C2C2C2",
"C c #C2C2C3",
"Z c #C4C4C4",
"A c #C4C4C5",
"S c #C5C5C5",
"D c #C5C5C6",
#"F c #C6C6C6",
"F c none",
"G c #C7C7C7",
"H c #C6C6C8",
"J c #C8C8C8",
"K c #C9C9C9",
"L c #CACACA",
"P c #CDCDCD",
"I c #D2D2D2",
"U c #D3D3D3",
"Y c #E1E1E1",
"FFFFFFFFFFFFFFFF",
"FFFFFFFKDFFFFFFF",
"FFFFFFBsvKFFFFFF",
"FFFFFF0-5MDFFFFF",
"FFFFFF*r$kFFFFFF",
"FFFFFF*e#kDFFFFF",
"FFFFFD*e#lKFFFFF",
"FFFFDj>t:yDFFFFF",
"FFFFl=wre;pKFFFF",
"FFFKh.ooo 7LFFFF",
"FFFGh,apa67LFFFF",
"FFFKd9LIYc7LFFFF",
"FFFKf9bBIc7LFFFF",
"FFFC4+123<qKFFFF",
"FFFFNbbbbbBFFFFF",
"FFFFFFFFFFFFFFFF"
]

gioconda16= [
"16 16 68 1 ",
"  c black",
". c #370C0E",
"X c #3D120C",
"o c #350B11",
"O c #3A1211",
"+ c #46180D",
"@ c #451A11",
"# c #521D10",
"$ c #57190B",
"% c #4C2413",
"& c #572314",
"* c #5C371B",
"= c #632C15",
"- c #6B3417",
"; c #7F3C14",
": c #644523",
"> c #7C582C",
", c #77492C",
"< c #005072",
"1 c #555555",
"2 c #803F1F",
"3 c #8B461C",
"4 c #A05117",
"5 c #B7621E",
"6 c #815134",
"7 c #925531",
"8 c #995028",
"9 c #90762F",
"0 c #8C7233",
"q c #977934",
"w c #916C36",
"e c #AA6A31",
"r c #BC7029",
"t c #D27516",
"y c #C67523",
"u c #A9704A",
"i c #B9784A",
"p c #A48B3D",
"a c #B4943B",
"s c #CA8436",
"d c #D49139",
"f c #E39A35",
"g c #E38C38",
"h c #9E8A44",
"j c #A68A42",
"k c #A69547",
"l c #B7974B",
"z c #AB9A51",
"x c #B3A254",
"c c #C59C4E",
"v c #D48E52",
"b c #C6A856",
"n c #C5A14A",
"m c #EAA359",
"M c #E5B352",
"N c #EBB662",
"B c #EAA663",
"V c #006286",
"C c #00709F",
"Z c #0097C3",
"A c #05AADA",
"S c #60B2D0",
"D c #96D7E9",
"F c #A2E0F1",
"G c #C3C3C3",
"H c #FFFEDD",
"J c #FFFEEA",
"K c #FEFEFB",
"                ",
" q9q0qjzpjkkhhk ",
" aapj,%O@:hzkkz ",
" acl*=-+oo%lxzx ",
" nbwyNNv#o.:xbb ",
" bn-mNNBu+oojxx ",
" Me=yft55#O.:xx ",
" c6&;e873$X.%kk ",
" -=-dftMgVVVVVV ",
" &##Bd4BiVKDFDS ",
" &++iy;v7VGuAZC ",
" *%##yy8#V11VV< ",
" >:@X+&++VKKKJJ ",
" 0:@+O66,VKJJJH ",
" *%@@=svs KKJJH ",
"                "
]

gioconda16mirror=[
"16 16 68 1 ",
"  c black",
". c #370C0E",
"X c #3D120C",
"o c #350B11",
"O c #3A1211",
"+ c #46180D",
"@ c #451A11",
"# c #521D10",
"$ c #57190B",
"% c #4C2413",
"& c #572314",
"* c #5C371B",
"= c #632C15",
"- c #6B3417",
"; c #7F3C14",
": c #644523",
"> c #7C582C",
", c #77492C",
"< c #005072",
"1 c #555555",
"2 c #803F1F",
"3 c #8B461C",
"4 c #A05117",
"5 c #B7621E",
"6 c #815134",
"7 c #925531",
"8 c #995028",
"9 c #90762F",
"0 c #8C7233",
"q c #977934",
"w c #916C36",
"e c #AA6A31",
"r c #BC7029",
"t c #D27516",
"y c #C67523",
"u c #A9704A",
"i c #B9784A",
"p c #A48B3D",
"a c #B4943B",
"s c #CA8436",
"d c #D49139",
"f c #E39A35",
"g c #E38C38",
"h c #9E8A44",
"j c #A68A42",
"k c #A69547",
"l c #B7974B",
"z c #AB9A51",
"x c #B3A254",
"c c #C59C4E",
"v c #D48E52",
"b c #C6A856",
"n c #C5A14A",
"m c #EAA359",
"M c #E5B352",
"N c #EBB662",
"B c #EAA663",
"V c #006286",
"C c #00709F",
"Z c #0097C3",
"A c #05AADA",
"S c #60B2D0",
"D c #96D7E9",
"F c #A2E0F1",
"G c #C3C3C3",
"H c #FFFEDD",
"J c #FFFEEA",
"K c #FEFEFB",
"                ",
" *%@@=svs KKJJH ",
" 9:++.66,VKKJJH ",
" >*+X$&++VKKKJJ ",
" *%+&sy8#V11VV< ",
" &++it2v7VGuAZC ",
" &+&md4miVKDFDS ",
" :*-dftMgVVVVVV ",
" c,&;e873$X.%kk ",
" Me=yft55#.o:xx ",
" bn=mNNBu+oojxx ",
" nbwrNNv#oo:bxb ",
" dcl*=-+oo%lxzx ",
" aapp,%O@:pzkkz ",
" q9q0qkzphkzhhk ",
"                "
]


energy = [
"16 16 3 1",
"  c blue",
". c white",
"X c None",
"XXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXX",
"XXXXX      XXXXX",
"XXXXX XXXXXXXXXX",
"XXXXX XXXXXXXXXX",
"XXXXX XXXXXXXXXX",
"XXXXX XXXXXXXXXX",
"XXXXX     XXXXXX",
"XXXXX XXXXXXXXXX",
"XXXXX XXXXXXXXXX",
"XXXXX XXXXXXXXXX",
"XXXXX XXXXXXXXXX",
"XXXXX      XXXXX",
"XXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXX"
]

colormap16=[
"16 16 22 1",
"  c #000000",
". c #303030",
"X c #004040",
"o c #404000",
"O c #000080",
"+ c #008000",
"@ c #00c000",
"# c #008080",
"$ c #00c0c0",
"% c #c00000",
"& c #c05800",
"* c #ffa858",
"= c #808080",
"- c #a0a0a0",
"; c #8080ff",
": c #ffdca8",
"> c #c3c3c3",
", c #dcdcdc",
"< c #c0c0ff",
"1 c #c0ffc0",
"2 c #c0ffff",
"3 c None",
#"3 c #ffffff",
#/* pixels */
"333  33333333333",
"33 3, 33333  333",
"3 3,, 3333 ,> 33",
" 3,3,3 33 ,,>> 3",
" ,,  > 33 ,>>, 3",
" , 33 , 3 >;;O> ",
" , 33 ,, ,>;<O> ",
" ,, o,,,,,>OOO> ",
" ,,,,,,,,,,>>>> ",
" ,,**&,,,,$$#> 3",
" ,,*:&>-->$2#> 3",
" >,&&%@@+-##X= 3",
"3  ,,>@1+=>-- 33",
"33 ,>>+++=,> 333",
"333. ,,>->   333",
"33333     333333"
]

MINEcolormap16 = [
"22 16 12 1",
"  c black",
". c navy",
"X c blue",
"o c #000080800000",
"O c green",
"+ c #000080808080",
"@ c #808000000000",
"# c red",
"$ c yellow",
"% c #808080808080",
"& c #C0C0C0C0C0C0",
#"* c gray100",
"* c None",
"**********************",
"***&&&*********&&&&***",
"**&*&&&********&&&&&**",
"*&& ***&&****&&&&&O&&*",
"*&* *** &&**&&&+OOO+&*",
"*&&& ** &&&&&&&oOOO+&*",
"*&&&& %&&&&&&&&&o++&&*",
"**&&&&&&&&&&&&&&&&&&&*",
"**&&&&%&&&&&&&&&XXX&&*",
"**&&&#@#&&&&&&&.XXX.&*",
"**&&@###&&%%%&&.XX.&**",
"***&@##@&%$$$%&.X..&**",
"***&%@@@&+$$$%&...&***",
"****&&@&&+$$+%&&&&&***",
"*****&&&&&ooo%&&&&****",
"******&&&&&&&&&&******"
]

colormap = colormap16

MINEcolormap = [
"16 16 157 2",
"   c black",
".  c #32a230b6261c0000",
"X  c #2dd072373a280000",
"o  c #1b7a5e8a7e3e0000",
"O  c #0869714c720a0000",
"+  c #44b0439e3f120000",
"@  c #4d9943ac32ec0000",
"#  c #43d6445646fe0000",
"$  c #4cd049da43d20000",
"%  c #4d8d4dca4d740000",
"&  c #50b84dd34c760000",
"*  c #5730550c4ba70000",
"=  c #572159e84b700000",
"-  c #5f1f5a5f46520000",
";  c #562e53ea50ee0000",
":  c #590f5766534b0000",
">  c #5e475c7b59330000",
",  c #5f745f9161d00000",
"<  c #62755e9d57b00000",
"1  c #67086468556f0000",
"2  c #643c636a5ce40000",
"3  c #6bed68bf5bd60000",
"4  c #728d6e1157d60000",
"5  c #7028705770b60000",
"6  c #737173a661300000",
"7  c #737276576d9e0000",
"8  c #7f857d106e1f0000",
"9  c #77c4780f79440000",
"0  c #7ce87cbd7b8f0000",
"q  c #05d573daadaa0000",
"w  c #54497b7b87e30000",
"e  c #39498f5045650000",
"r  c #500a9b725bac0000",
"t  c #5de187637ab20000",
"y  c #5cc2ac8864db0000",
"u  c #6e0f80fe6cd70000",
"i  c #6aa598bc62350000",
"p  c #6c7fb13f6fbb0000",
"a  c #1b70843fb5fd0000",
"s  c #33d39b4c9bdd0000",
"d  c #5990b350ac230000",
"f  c #61c7a2559a560000",
"g  c #74fea34891de0000",
"h  c #712bacd8bdfa0000",
"j  c #4c169fe6c1910000",
"k  c #7ffbb5dcc8ba0000",
"l  c #7631ce79cde30000",
"z  c #70c3cf69d1f90000",
"x  c #64cec217e82c0000",
"c  c #99d4133821f90000",
"v  c #87097e866f430000",
"b  c #a7b15b945a4e0000",
"n  c #c11e31ff3ea00000",
"m  c #cb363b2547800000",
"M  c #c2185dd763f70000",
"N  c #d89a60e866aa0000",
"B  c #e8ee5d0166230000",
"V  c #ed436e8875310000",
"C  c #86e381036d780000",
"Z  c #8a91814f70620000",
"A  c #887d859c73a20000",
"S  c #8e88843072ea0000",
"D  c #8d9b896e71b70000",
"F  c #8d1d959373fe0000",
"G  c #8ad89a61750c0000",
"H  c #940b83c06c6f0000",
"J  c #95478e1973fa0000",
"K  c #9fff80ad71230000",
"L  c #9551926a7af20000",
"P  c #9ce295857b390000",
"I  c #96fea16f78380000",
"U  c #b53d91177e3a0000",
"Y  c #8346833084190000",
"T  c #8ba28be48caf0000",
"R  c #9769946b8ba00000",
"E  c #9e9f9ae68c7e0000",
"W  c #94249411937e0000",
"Q  c #943ca01196c10000",
"!  c #9b7a9a0a96e00000",
"~  c #9e1d9cd99c310000",
"^  c #90c5acc6ab4e0000",
"/  c #a0f29e208ed20000",
"(  c #a809a5398b520000",
")  c #a632a2ab96640000",
"_  c #a990a4c393650000",
"`  c #ae38b78093ba0000",
"'  c #b8ebad728ccf0000",
"]  c #b8edc05f9e730000",
"[  c #ae65adfda2820000",
"{  c #ab45ab14af050000",
"}  c #b439b6e5aa700000",
"|  c #bbb7b6d2aac20000",
" . c #bd52bba3a6820000",
".. c #8ecec76694970000",
"X. c #96aac4b6971a0000",
"o. c #8b55c1c7ad490000",
"O. c #892ec4ccb7af0000",
"+. c #ac2cc2449bcc0000",
"@. c #bc27c4caa3c10000",
"#. c #b116c0e6b4190000",
"$. c #bac9ef72b5220000",
"%. c #83abd0e3f1770000",
"&. c #c634984784310000",
"*. c #db719fcb954a0000",
"=. c #c159a96a8e280000",
"-. c #c496b7829dac0000",
";. c #c5c4bbb7995f0000",
":. c #d8a5aa7e9c680000",
">. c #e4ffa5249a800000",
",. c #f6fdbc65b0b70000",
"<. c #ca38c6a49d940000",
"1. c #ce6bc815a7e80000",
"2. c #cf0dc834ae850000",
"3. c #c890c58ebf790000",
"4. c #c564cc1cb2730000",
"5. c #cfcfd972baff0000",
"6. c #d66eca1da5130000",
"7. c #da30cf78a97b0000",
"8. c #d19ece63b8ac0000",
"9. c #df6bd3e3af430000",
"0. c #d754d705c0800000",
"q. c #dabbd7b6c0540000",
"w. c #e354cdd1a97f0000",
"e. c #eaadd985afbb0000",
"r. c #e517d6feba720000",
"t. c #e3ecd8febb540000",
"y. c #ed62d85ac08f0000",
"u. c #c498c4c4c7500000",
"i. c #cd3acdc3cf4a0000",
"p. c #d7e8d692cc140000",
"a. c #d511de75c37b0000",
"s. c #df34d9e6c5190000",
"d. c #e0aae0d5ca4a0000",
"f. c #d629d578d6c00000",
"g. c #dd7adce6dd6b0000",
"h. c #e069e0e3e30e0000",
"j. c #e3a6dc2dc7160000",
"k. c #e7b1dd12cada0000",
"l. c #eed2e041cf3f0000",
"z. c #e3e1e2dbcc030000",
"x. c #e743e4a7d8b20000",
"c. c #eaa4e350d3e60000",
"v. c #eb49e9a4d33b0000",
"b. c #f968eb0cc8730000",
"n. c #f622ecbbd45e0000",
"m. c #f6edf0d3dd2c0000",
"M. c #f7b2f2bddce30000",
"N. c #fbf0f55cdb450000",
"B. c #e7ace818e9910000",
"V. c #e83fe902ea1a0000",
"C. c #efffeba9e2bc0000",
"Z. c #ec97ed28ed8b0000",
"A. c #fa34f631eddf0000",
"S. c #f6d9f74df80b0000",
"D. c #f8e3f98ffa600000",
"F. c #fefafef9fef30000",
"G. c None",
"G.F.D.G.F.G.D.F.G.F.G.D.F.G.D.F.",
"G.F.G.T % W G.F.F.G.F.F.B.h.S.F.",
"F.G.5 ! A.[ ! G.F.F.G.u.+ . 0 G.",
"G.W ~ F.C.F.% g.F.G.i.: t.b.4 Y ",
"Z., x.3 + 2.p.% G.G.T S d. .w.% ",
"  3.R T G.* 8.2 i.V.$ v.k j #.C ",
"  | E 9 G.Y A N.< % -.h %.x a L ",
"  ) N.1 { Y E M.q. .n.^ a q o D ",
"  / M.c.7 } M.s.d.z.q.r.Q w ( J ",
"  _ n.z.,.>.d.k.l.k.j.0.o.@.e.J ",
"# 8 v.:.N m *.a.+.4.y.O.z d ] S ",
"G.& 5.M V B b X...p ` f l s u < ",
"G.g.6 &.n c K r $.y I g O t @ i.",
"D.G.i.= =.U 1.i e X F 6.;.H ; D.",
"G.F.G.u.6 <.7.9.G G ;.' - ; Z.G.",
"F.G.F.G.f.> v J P J Z > i.S.F.F."]

yauto  =[
"16 16 3 1",
"  c black",
". c #0000ff",
"X c none",
"XXXXXXXXXXXXXXXX",
"XX.XXXXXXXXXXXXX",
"X...XXXXXXXXXXXX",
".....XXXXXXXXXXX",
"XX.XXXXXXXXXXXXX",
"XX.XXX XXXXX XXX",
"XX.XXXX XXX XXXX",
"XX.XXXXX X XXXXX",
"XX.XXXXXX XXXXXX",
"XX.XXXXX XXXXXXX",
"XX.XXXX XXXXXXXX",
"XX.XXX XXXXXXXXX",
".....XXXXXXXXXXX",
"X...XXXXXXXXXXXX",
"XX.XXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXX"
]

xauto  =[
"16 16 3 1",
"  c black",
". c #0000ff",
"X c none",

"XXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXX",
"XXXXX XXXXX XXXX",
"XXXXXX XXX XXXXX",
"XXXXXXX X XXXXXX",
"XXXXXXXX XXXXXXX",
"XXXXXXX X XXXXXX",
"XXXXXX XXX XXXXX",
"XXXXX XXXXX XXXX",
"XXXXXXXXXXXXXXXX",
"XXX.XXXXXXXX.XXX",
"XX..XXXXXXXX..XX",
"X..............X",
"XX..XXXXXXXX..XX",
"XXX.XXXXXXXX.XXX"
]

close = [
"16 16 18 1",
". c None",
"d c #000000",
"c c #080808",
"k c #080c08",
"b c #181818",
"a c #212021",
"# c #212421",
"j c #292829",
"e c #313031",
"f c #393839",
"i c #424542",
"m c #525152",
"h c #525552",
"g c #5a595a",
"l c #636163",
"p c #6b696b",
"n c #7b797b",
"o c #ffffff",
"................",
"................",
"......#abcd.....",
"....efghijkdd...",
"...elmgnliaddd..",
"...fmoopnhoodd..",
"..#ggooogoooddd.",
"..ahnpooooocddd.",
"..bilngoooadddd.",
"..cjihooooodddd.",
"..dkaoooaoooddd.",
"...ddoocddoodd..",
"...ddddddddddd..",
"....ddddddddd...",
"......ddddd.....",
"................"
]


fileclose = [
"16 16 14 1",
"  c black",
". c #0b0b0b",
"X c #181818",
"o c #222222",
"O c gray17",
"+ c gray19",
"@ c gray23",
"# c #444444",
"$ c #535353",
"% c None",
"& c gray38",
"* c #686868",
"= c gray47",
"- c white",
"%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%",
"%%%%%%ooX. %%%%%",
"%%%%+@%$#O.  %%%",
"%%%+&$%=&#o   %%",
"%%%@$--*=$--  %%",
"%%o%%---%---   %",
"%%o$=*-----.   %",
"%%X#&=%---o    %",
#"%%.O#$---  %",
"%%.O#$---      %",
"%% .o---o---   %",
"%%%  --.  --  %%",
"%%%           %%",
"%%%%         %%%",
"%%%%%%     %%%%%",
"%%%%%%%%%%%%%%%%"
]

fileopen = [
"16 16 39 1",
"  c black",
". c gray4",
"X c gray7",
"o c #1f1f1e",
"O c #222222",
"+ c #323231",
"@ c #4b3119",
"# c #434343",
"$ c #4a4a49",
"% c #524f4c",
"& c #54514e",
"* c #565350",
"= c #5c5a57",
"- c #686867",
"; c #6f6f6e",
": c #b77d44",
"> c #c4864e",
", c #e5a566",
"< c #f8ac62",
"1 c #8d8d8b",
"2 c #949493",
"3 c #9c9c9b",
"4 c #a0a09f",
"5 c #a4a4a3",
"6 c #adadab",
"7 c #b5b5b5",
"8 c #bcbcbc",
"9 c #fec383",
"0 c #fec88a",
"q c #fed39a",
"w c #c4c4c3",
"e c #cccccc",
"r c #d4d4d3",
"t c #dddddc",
"y c #e4e4e3",
"u c #e8e8e7",
"i c #ececec",
"p c gray96",
"a c None",
"aaaaaa    aaaaaa",
"aaaaa  a    a aa",
"aaaa aaaaa    aa",
"aaaaaaaaaaa   aa",
"aaaaaaaaaa    aa",
"a    aaaaaaaaaaa",
" ,q9,       aaaa",
" q99<<<<<<<< aaa",
" 09@&&&=&&**&   ",
" 9>%ppiytrew877+",
" 9@ttuytrw8642$a",
" :&ttytrew764-Oa",
" @eerrrew8652$aa",
" *e8www87653;Xaa",
".85666655321$aaa",
"O$$$$$$$###+oaaa"
]

fileprint = [
"16 16 37 1",
"  c black",
". c gray19",
"X c gray22",
"o c #4f4928",
"O c #574934",
"+ c #444444",
"@ c #585858",
"# c #646464",
"$ c gray",
"% c lime",
"& c #b7996e",
"* c #b9b24a",
"= c #838383",
"- c #8c8c8c",
"; c #939393",
": c #9d9d9d",
"> c #a1a1a1",
", c #b7b7b7",
"< c #dfc097",
"1 c #e8c08d",
"2 c #e4cba9",
"3 c #e7d3b9",
"4 c #c3c3c3",
"5 c #cacaca",
"6 c gainsboro",
"7 c #e9d9c5",
"8 c #ecdfcc",
"9 c #eee4d5",
"0 c #f0e6d8",
"q c gray89",
"w c #f3ede4",
"e c #f4eee8",
"r c #f5f1eb",
"t c #f7f6f4",
"y c #f8f7f6",
"u c #fdfdfd",
"i c None",
"iiiiiiiiO  iiiii",
"iiiiiiiOuu4O iii",
"iiiiii wtytu8O i",
"iiiiiiOtyytrw8< ",
"iiii  wtytrw98& ",
"iii :O9weew08< i",
"ii :@&1299873@oi",
"i :>># &123<< *o",
" :::::># #&&.*oi",
"+6uq:::::># #o$ ",
"+55q6uq;--==$$@ ",
" >,455q6uq$$$@+ ",
"i  @>,455q6u@+X ",
"iiii  @>,4%4+X i",
"iiiiiii  @>,X ii",
"iiiiiiiiii   iii"
]

filesave = [
"16 16 26 1",
"  c #000000",
". c #0c0c0c",
"X c gray21",
"o c #3e3e3e",
"O c #444444",
"+ c #4c4c4c",
"@ c #535353",
"# c #5d5d5d",
"$ c #636363",
"% c #6a6a6a",
"& c #747474",
"* c #7c7c7c",
"= c #838383",
"- c #8c8c8c",
"; c #939393",
": c #9a9a9a",
"> c #a4a4a4",
", c gray68",
"< c gray71",
"1 c #c1c1c1",
"2 c gray81",
"3 c gray85",
"4 c #e6e6e6",
"5 c #efefef",
"6 c #ffffff",
"7 c None",
"7777   777777777",
"777@1,6   777777",
"777@1:6666   777",
"777@166666666   ",
"77@1>66666666>> ",
"77@1-66666666;> ",
"77@<56666666== 7",
"7@,>;-666666&- 7",
"7@:---==*662$; 7",
"7@:--=$#$&*2$; 7",
#"7@ =$#$&$#.7",
"@=$444+O+@@@* 77",
"@%+444443O@@- 77",
"   44444o+@$ 777",
"777   44X@@& 777",
"777777   @@; 777",
"777777777  .7777"
]

fit = [
"16 16 7 1",
"  c #303030",
". c #585858",
"X c #c00000",
"o c #808080",
"O c #dcdcdc",
"+ c #ffffff",
"@ c None",
"@@@@@oo@@@@@@@@@",
"@@@@@oo@@@@@@@@@",
"@@@@oXXo@@@@@@@@",
"@@@@o++X@@@@@@@@",
"@@@Xo++oX@oX@@@@",
"@@@o+++oX@XoX@@@",
"@@Xo++++.X++o@@@",
"@Xo+++++oo++oX@@",
"@     +  +    @@",
"@     +  +    X@",
"o  ++++  ++  oX@",
"X    ++  ++  oX@",
"+    ++  ++  oo@",
"+  ++++  ++  +oX",
"+  ++++  ++  ++o",
"@@@@@@@@@@@@@@@@"
]

logx = [
"16 16 4 1",
"  c #000040",
". c #0000ff",
"X c #dcdcdc",
"o c None",
"oooooooooooooooo",
"ooo oooooooooooo",
"ooo oooooooooooo",
"ooo oooooooooooo",
"ooo ooo ooo oooo",
"ooo oo o o o ooo",
"ooo oo o o o ooo",
"ooo   o ooo  ooo",
"oooooooooooo ooo",
"oooooooooo  oooo",
"oo.oooooooooo.oo",
"o..oooooooooo..o",
"................",
"o..oooooooooo..o",
"oo.oooooooooo.oo",
"oooooooooooooooo"
]

logy = [
"16 16 4 1",
"  c #000040",
". c #0000ff",
"X c #dcdcdc",
"o c None",
"oooooooooooooooo",
"oo.ooooooooooooo",
"o...oooooooooooo",
".....ooooooooooo",
"oo.ooooooooooooo",
"oo.ooo ooooooooo",
"oo.ooo ooooooooo",
"oo.ooo ooooooooo",
"oo.ooo ooo ooo o",
"oo.ooo oo o o o ",
"oo.ooo oo o o o ",
"oo.ooo   o ooo  ",
".....oooooooooo ",
"o...ooooooooo  o",
"oo.ooooooooooooo",
"oooooooooooooooo"
]

normal = [
"16 16 4 1",
"  c #303030",
". c #dcdcdc",
"X c #ffffff",
"o c None",
"oooooooooooooooo",
"o   oooooooooooo",
"o      ooooooooo",
"o         oooooo",
"oX       ooooooo",
"oX      oooooooo",
"oX      oooooooo",
"oXX      ooooooo",
"ooX  XX   oooooo",
"ooX XooX   ooooo",
"ooXXooooX   oooo",
"oooooooooX   ooo",
"ooooooooooX  ooo",
"oooooooooooooooo",
"oooooooooooooooo",
"oooooooooooooooo"
]

peak = [
"16 16 4 1",
"  c #303030",
". c #0080ff",
"X c #dcdcdc",
"o c None",
"oooooo   ooooooo",
"ooooo  . ooooooo",
"ooooo ...ooooooo",
"ooooo.....oooooo",
"ooooo o.o oooooo",
"ooooo o.o oooooo",
"oooo oo.o oooooo",
"oooo oo.o oooooo",
"oo o oo.o oooooo",
"oo o oo.o  ooo o",
"o    oo.oo oo   ",
"o o  oo.oo oo oo",
"o ooooo.oo    oo",
"  ooo.....oo ooo",
"oooooo...ooooooo",
"ooooooo.oooooooo"
]

peakreset = [
"16 16 6 1",
"  c #303030",
". c #0080ff",
"X c #ff0000",
"o c #dcdcdc",
"O c #ffc0c0",
"+ c None",
"XX++++   +++++XX",
"+XXO+  . ++++XX+",
"++XXO ...++OXX++",
"+++XX.....OXX+++",
"++++XXO.+OXX++++",
"+++++XX.OXX+++++",
"++++ +XXXX++++++",
"++++ +OXX ++++++",
"++ + OXXXX++++++",
"++ +OXX.OXX+++ +",
"+  OXX+.+OXX+   ",
"+ +XX++.++OXX ++",
"+ XX+++.++ OXX++",
" XX++.....++ XX+",
"+X++++...+++++X+",
"X++++++.+++++++X"
]

peaksearch = [
"16 16 6 1",
"  c #303030",
". c #585858",
"X c #0000c0",
"o c #dcdcdc",
"O c #ffffff",
"+ c None",
"++..++++++++++++",
"++.X.+++++++++++",
"++XXX+++++++++++",
"++.X.++++..+++++",
"+..X.+++.X..++++",
"+.OX..++XXX.++++",
"+.OXO..+.XO..+++",
"..OXOO..OXOO.+++",
"OOOXOOOOOXOO..OO",
"   ++++++++++...",
" ++ ++++++++++++",
" ++ +  ++  + + +",
"   + + + + + + +",
" +++  ++ + +  ++",
" +++ +++ + + + +",
" ++++  ++  + + +"
]

reload_ = [
"16 16 51 1",
"  c #000000",
". c #040d00",
"X c gray5",
"o c #111111",
"O c #1b1b1b",
"+ c #0c2600",
"@ c #113800",
"# c #153c17",
"$ c #242424",
"% c #2d2d2d",
"& c #343434",
"* c gray24",
"= c #154400",
"- c #124515",
"; c #1c4e1f",
": c #1b531c",
"> c #1e5421",
", c #244926",
"< c #235326",
"1 c #215824",
"2 c #265c28",
"3 c #295f2c",
"4 c #2f783f",
"5 c #2f7a41",
"6 c gray27",
"7 c #4c4c4c",
"8 c #525252",
"9 c #5a5a5a",
"0 c #7b7b7b",
"q c #208a17",
"w c #249215",
"e c #289b19",
"r c #2fa522",
"t c #3fbe31",
"y c #56a64f",
"u c #6ebc66",
"i c #44cd35",
"p c #818181",
"a c #929292",
"s c #9f9f9f",
"d c darkgray",
"f c #b2b2b2",
"g c #b9b9b9",
"h c #a9d7ad",
"j c #b5d7b3",
"k c #b3d8b2",
"l c #c6e0c4",
"z c #dbecda",
"x c #e4e4e4",
"c c white",
"v c None",
"vvvvc2>>>>=vvvvv",
"vvvc3kqr=@+==vvv",
"vvv1zqr=vvv .=vv",
"vvv<hr=vvvvvv =v",
"vvv;ut=vvvvvvvvv",
":::;yt====vvxvvv",
"v:juew4i#vcovcvv",
"vv,lw5i#vv$g vvv",
"v v-ji#vv g88 vv",
#"vvvv##vd98 ",
"vvvv##vd98888 vv",
"vvvvvvvoo 0&0ooo",
"vvvvvvvvv&s& vvv",
"v  vvvvvv p7Ovvv",
"vv   vvc f96 vvv",
"vvvoO  8a9*Xvvvv",
"vvvvvo$  O vvvvv"
]

roi = [
"16 16 6 1",
"  c #000000",
". c #0080ff",
"X c #c3c3c3",
"o c #dcdcdc",
"O c #ffffff",
"+ c None",
"++.XXX XX.++++++",
"++.XX   X.++++++",
"++.XX O X.++++++",
"++.X  O X.++++++",
"++.X OO X.++++++",
"++.X OO X.++++++",
"++.X OO X.++++++",
"++.  OO X.+  +++",
"++. OOO X.+  +++",
"++. OOO X.+  +++",
"++. OOO  .+ + ++",
"++. OOOO .+ + ++",
"  .OOOOOO. ++   ",
"++.OOOOOO.+++++ ",
"++.OOOOOO.++++++",
"++.OOOOOO.++++++"
]

roireset = [
"16 16 8 1",
"  c #000000",
". c #0080ff",
"X c #ff0000",
"o c #c3c3c3",
"O c #dcdcdc",
"+ c #ffc0c0",
"@ c #ffffff",
"# c None",
"XX.ooo oo.####XX",
"#XXoo   o.###XX#",
"##XXo @ o.#+XX##",
"##.XX @ o.+XX###",
"##.+XX@ o+XX####",
"##.o+XX +XX#####",
"##.o +XXXX######",
"##.  @+XX.#  ###",
"##. @+XXXX#  ###",
"##. +XX +XX  ###",
"##.+XX@  +XX# ##",
"##+XX@@@ .+XX ##",
"  XX@@@@@. +XX  ",
"#XX@@@@@@.###XX ",
"#X.@@@@@@.####X#",
"X#.@@@@@@.#####X"
]

rotate_left = [
"24 24 2 1",
"  c None",
". c #000000",
"            .           ",
"           ..           ",
"          ...           ",
"         ......         ",
"        ..........      ",
"        ...........     ",
"         ...........    ",
"          ...  .....    ",
"           ..   .....   ",
"            .    ....   ",
"                 ....   ",
"                  ....  ",
"                  ....  ",
"                  ....  ",
"  ....           ....   ",
"  ....           ....   ",
"  .....         .....   ",
"   .....       .....    ",
"   .......   .......    ",
"    ...............     ",
"     .............      ",
"       .........        ",
"          ...           ",
"                        "]


rotate_right = [
"24 24 2 1",
"  c None",
". c #000000",
"           .            ",
"           ..           ",
"           ...          ",
"         ......         ",
"      ..........        ",
"     ...........        ",
"    ...........         ",
"    .....  ...          ",
"   .....   ..           ",
"   ....    .            ",
"   ....                 ",
"  ....                  ",
"  ....                  ",
"  ....                  ",
"   ....           ....  ",
"   ....           ....  ",
"   .....         .....  ",
"    .....       .....   ",
"    .......   .......   ",
"     ...............    ",
"      .............     ",
"        .........       ",
"           ...          ",
"                        "]

selected = [
"16 16 10 1",
"  c black",
". c #000040",
"X c #004000",
"o c #400000",
"O c green",
"+ c #00c000",
"@ c fractal",
"# c gainsboro",
"$ c #c0ffc0",
"% c None",
"%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%$",
"%%@@@@@@@@@@@@$+",
"%%@%%%%%%%%%%$+O",
"%%@%%%%%%%%%$+OX",
"%%@%%%%%%%%$+OX ",
"%%@O%%%%%%$+OX %",
"%$++O%%%%$+OX.%%",
" XO++O%%$+OX @%%",
"% XO++O$+OXo%@%%",
"%%.XO+++OXo%%@%%",
"%%@ XO+OX %%%@%%",
"%%@% XOX %%%%@%%",
"%%@@@@@@@@@@@@%%",
"%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%"
]

unselected = [
"16 16 3 1",
"  c #808080",
". c #dcdcdc",
"X c None",
"XXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXX",
"XX            XX",
"XX XXXXXXXXXX XX",
"XX XXXXXXXXXX XX",
"XX XXXXXXXXXX XX",
"XX XXXXXXXXXX XX",
"XX XXXXXXXXXX XX",
"XX XXXXXXXXXX XX",
"XX XXXXXXXXXX XX",
"XX XXXXXXXXXX XX",
"XX XXXXXXXXXX XX",
"XX XXXXXXXXXX XX",
"XX            XX",
"XXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXX"
]

bliss = [
"24 24 47 1 ",
"  c None",
". c #272A7C",
"X c #2F317F",
"o c #31347F",
"O c #46AC32",
"+ c #3E914C",
"@ c #52AF42",
"# c #56B047",
"$ c #64B45A",
"% c #6CB664",
"& c #72B76D",
"* c #77B478",
"= c #85C17E",
"- c #353882",
"; c #3D4085",
": c #454787",
"> c #4F508D",
", c #53578C",
"< c #595A91",
"1 c #5B638D",
"2 c #696A9C",
"3 c #6C7C93",
"4 c #727D98",
"5 c #6B6DA0",
"6 c #787AA9",
"7 c #6E8192",
"8 c #778698",
"9 c #7B9495",
"0 c #7CA98A",
"q c #7EB482",
"w c #7F81AF",
"e c #82979E",
"r c #80B088",
"t c #86A599",
"y c #93B79E",
"u c #8689AC",
"i c #8A8BB3",
"p c #8E90BB",
"a c #9597BD",
"s c #8CC485",
"d c #AEC4BA",
"f c #A8A9C4",
"g c #AFB0CA",
"h c #B4B4CD",
"j c #C6C6DB",
"k c #CFCFE2",
"l c #D3D3E4",
"        6ap:-5pi-.      ",
"        uaa5-6p:.<a     ",
"        -upi-6wihlll    ",
"        --6a:y#%e:--    ",
"        ;..6a@OO*2i,.   ",
"       fkgu;w#OO*o:ag   ",
"       hlllkhd&*7...i   ",
"       jllljf6,-....    ",
"       khi<X........    ",
"       -...,98o....     ",
"      ....3*+Ot4:.      ",
"      ...1&OO%98-.      ",
"      -.1*OOO0.....     ",
"      .3&OOOO9.....     ",
"     -9$OOOO@3......    ",
"     y#OOOOO0-......    ",
"     &OOOOOq1.......    ",
"     @OOOr9>.......     ",
"    $O@r8..........     ",
"   $O$9X...........     ",
"  $O$8............      ",
" %O$8............       ",
"=O% ...........         ",
"ss                      "
]


spec = [
"16 16 24 1",
"  c black",
". c #585858",
"X c #777777",
"o c #9f9f9f",
"O c #a5a5a5",
"+ c #acacac",
"@ c gray70",
"# c gray73",
"$ c #e6e6bc",
"% c #c3c3c3",
"& c #cecece",
"* c #d5d5d5",
"= c gainsboro",
"- c #e6e6c3",
"; c #e6e6cc",
": c #e6e6d5",
"> c #e6e6da",
", c #ffffdd",
"< c #e6e6e5",
"1 c #ffffe4",
"2 c #ffffeb",
"3 c #fffff4",
"4 c #fffffe",
"5 c None",
"5555555555555555",
"                ",
" 555*&%%#@+Oooo ",
" XXXXXXXXXXXXXX ",
" <444444444444> ",
" <44444444444,: ",
" %..4..%4%..%.. ",
" .444.4.3.3,.,; ",
" %.%4.3.3..2.1; ",
" <4.3..%2.,1.1; ",
" <4.4.222.1,.,: ",
" ..%2.211%..%.. ",
" >,,,,111,,,,,$ ",
" :::;;;;----$$$ ",
"                ",
"5555555555555555"
]

window_fullscreen = [
"16 16 23 1",
"  c black",
". c #777777",
"X c maroon",
"o c #9f9f9f",
"O c #a5a5a5",
"+ c #acacac",
"@ c gray70",
"# c gray73",
"$ c #e6e6bc",
"% c #c4c4c4",
"& c #cecece",
"* c #d5d5d5",
"= c gainsboro",
"- c #e6e6c3",
"; c #e6e6cc",
": c #e6e6d5",
"> c #e6e6db",
", c #ffffde",
"< c #e6e6e6",
"1 c #ffffe4",
"2 c #ffffec",
"3 c #fffff4",
"4 c #ffffff",
"4444444444444444",
"                ",
" ===*&%%#@+Oooo ",
" .............. ",
" <444444444444> ",
" <XXX444444XXX: ",
" <XX44444333XX: ",
" <X4X443333X2X; ",
" <444X33322211; ",
" <44333222X111; ",
" <X3X322211X,X- ",
" >XX222111,,XX- ",
" >XXX1111,,XXX$ ",
" :::;;;;----$$$ ",
"                ",
"4444444444444444"
]

window_new = [
"16 16 53 1",
"  c #000000",
". c #0f0000",
"X c #330100",
"o c #333940",
"O c #5e2479",
"+ c #555555",
"@ c #585858",
"# c gray40",
"$ c #0000d0",
"% c #0000d8",
"& c #3940e6",
"* c #642780",
"= c #6f2f90",
"- c #6e308b",
"; c #763796",
": c #793b9c",
"> c #7e3ea3",
", c #903339",
"< c #e60000",
"1 c #8242a7",
"2 c #894caf",
"3 c #8957a0",
"4 c #9056b5",
"5 c #925ab3",
"6 c #8d61a4",
"7 c #9065a8",
"8 c #9570ab",
"9 c #9873ae",
"0 c #c0c000",
"q c #c1c10a",
"w c yellow",
"e c #a480b9",
"r c #a881be",
"t c #ae86c5",
"y c #b894ce",
"u c #dedeb6",
"i c #dedebf",
"p c #ffff85",
"a c #c6c6c6",
"s c #dedec4",
"d c #dedecb",
"f c #deded2",
"g c #dededd",
"h c #ffffc0",
"j c #ffffdf",
"k c #e4e4e4",
"l c #eeeee6",
"z c #eeeeee",
"x c #ffffe4",
"c c #ffffec",
"v c #fffff4",
"b c #fffffe",
"n c None",
"@#+**********+++",
"@kayytre98763ga ",
"+aa45521>:;=-aa ",
"+@@OOOOOOOOOO@@ ",
"+zbbbbbbbbbbbvl ",
"+gbbbbbbbbvcccd ",
"+gbbbbbbbvcccxs ",
"+gbbbbbvcc@pxji ",
"+gbbbbv@pc@wj@p ",
"+gbbvccc@w0w0wu ",
"+gbvcccxxqhph0@ ",
"+gffdd@pwwpbpwwp",
"+        0hph0  ",
"nnnnnnnn w0w0wnn",
"nnnnnnn pn wn pn",
"nnnnnnnnnn pnnnn"
]

window_nofullscreen = [
"16 16 23 1",
"  c black",
". c #777777",
"X c maroon",
"o c #9f9f9f",
"O c #a5a5a5",
"+ c #acacac",
"@ c gray70",
"# c gray73",
"$ c #e6e6be",
"% c #c4c4c4",
"& c #cecece",
"* c #d5d5d5",
"= c gainsboro",
"- c #e6e6c4",
"; c #e6e6cc",
": c #e6e6d4",
"> c #e6e6db",
", c #ffffda",
"< c #e6e6e6",
"1 c #ffffe4",
"2 c #ffffec",
"3 c #fffff4",
"4 c #ffffff",
"4444444444444444",
"                ",
" ===*&%%#@+Oooo ",
" .............. ",
" X444444444444X ",
" <X4X444444X3X> ",
" <4XX444443XX2: ",
" <XXX444433XXX: ",
" <444443332221; ",
" <444433322211; ",
" <XXX332221XXX- ",
" <4XX322211XX,- ",
" >X3X22111,X,X$ ",
" X>:::;;;---$$X ",
"                ",
"4444444444444444"
]

zoom = [
"16 16 56 1",
"  c #000000",
". c #0b0b0b",
"X c #101010",
"o c #272727",
"O c #3f3f3f",
"+ c #3f3f40",
"@ c #404041",
"# c #707071",
"$ c #3eaab3",
"% c #00c0c0",
"& c aqua",
"* c #43b2bc",
"= c #7f8281",
"- c #53c9d4",
"; c #60c1cd",
": c #6ec4cd",
"> c #68c6d1",
", c #71c6ce",
"< c #7ac4cb",
"1 c #7cc9cd",
"2 c #76cbd5",
"3 c #79cad4",
"4 c #76d7e3",
"5 c #78d8e3",
"6 c #85ccd2",
"7 c #89c8d0",
"8 c #90d5db",
"9 c #90d9df",
"0 c #8bd7e0",
"q c #8adbe5",
"w c #8fdfe8",
"e c #95e1ea",
"r c #a8d1d5",
"t c #aed6db",
"y c #b6d9dd",
"u c #b9dade",
"i c #abdee4",
"p c #b9dbe0",
"a c #ade4e8",
"s c #afe9f0",
"d c #b0eaef",
"f c #baecef",
"g c #beedf1",
"h c #c3c3c3",
"j c #c1d4d6",
"k c #ced8d9",
"l c #c4eaed",
"z c #caeaed",
"x c #cdecf0",
"c c #d7e5e6",
"v c #d7e5e8",
"b c #d3f2f5",
"n c #def4f6",
"m c #e3f4f4",
"M c #eafbfa",
"N c None",
"NNNNoO.NNNNNNNNN",
"NN+ kvj +NNNNNNN",
"N+=mnlia=+NNNNNN",
"N mMng9:f NNNNNN",
"Xybnbsw,3p.NNNNN",
"oclgde4;6z.NNNNN",
".ri0q5-*1t NNNNN",
"N g2:>*$g NNNNNN",
"N+=g8<7g= &NNNNN",
"NN+ uzt @&  NNNN",
"NNNN . N% #h NNN",
"NNNNNNNNN @#h NN",
"NNNNNNNNNN @#h N",
"NNNNNNNNNNN @#h ",
"NNNNNNNNNNNN @# ",
"NNNNNNNNNNNNN  N"
]

zoomminus = [
"16 16 56 1",
"  c #000000",
". c #0b0b0b",
"X c #101010",
"o c #272727",
"O c #3f3f3f",
"+ c #3f3f40",
"@ c #404041",
"# c #707071",
"$ c #3eaab3",
"% c #00c0c0",
"& c aqua",
"* c #43b2bc",
"= c #7f8281",
"- c #53c9d4",
"; c #60c1cd",
": c #6ec4cd",
"> c #68c6d1",
", c #71c6ce",
"< c #7ac4cb",
"1 c #7cc9cd",
"2 c #76cbd5",
"3 c #79cad4",
"4 c #76d7e3",
"5 c #78d8e3",
"6 c #85ccd2",
"7 c #89c8d0",
"8 c #90d5db",
"9 c #90d9df",
"0 c #8bd7e0",
"q c #8adbe5",
"w c #8fdfe8",
"e c #95e1ea",
"r c #a8d1d5",
"t c #aed6db",
"y c #b6d9dd",
"u c #b9dade",
"i c #abdee4",
"p c #b9dbe0",
"a c #ade4e8",
"s c #afe9f0",
"d c #b0eaef",
"f c #baecef",
"g c #beedf1",
"h c #c3c3c3",
"j c #c1d4d6",
"k c #ced8d9",
"l c #c4eaed",
"z c #caeaed",
"x c #cdecf0",
"c c #d7e5e6",
"v c #d7e5e8",
"b c #d3f2f5",
"n c #def4f6",
"m c #e3f4f4",
"M c #eafbfa",
"N c None",
"NNNNoO.NNNNNNNNN",
"NN+ kvj +NNNNNNN",
"N+=mnlia=+NNNNNN",
"N mMng9:f NNNNNN",
"Xybnbsw,3p.NNNNN",
"oclgde4;6z.NNNNN",
".ri0q5-*1t NNNNN",
"N g2:>*$g NNNNNN",
"N+=g8<7g= &NNNNN",
"NN+ uzt +&  NNNN",
"NNNN . N% #h NNN",
"NNNNNNNNN @#h NN",
"NNNNNNNNNN @#h N",
"     NNNNNN @#h ",
"NNNNNNNNNNNN @# ",
"NNNNNNNNNNNNN  N"
]

zoomplus = [
"16 16 56 1",
"  c #000000",
". c #0b0b0b",
"X c #101010",
"o c #272727",
"O c #3f3f3f",
"+ c #3f3f40",
"@ c #404041",
"# c #707071",
"$ c #3eaab3",
"% c #00c0c0",
"& c aqua",
"* c #43b2bc",
"= c #7f8281",
"- c #53c9d4",
"; c #60c1cd",
": c #6ec4cd",
"> c #68c6d1",
", c #71c6ce",
"< c #7ac4cb",
"1 c #7cc9cd",
"2 c #76cbd5",
"3 c #79cad4",
"4 c #76d7e3",
"5 c #78d8e3",
"6 c #85ccd2",
"7 c #89c8d0",
"8 c #90d5db",
"9 c #90d9df",
"0 c #8bd7e0",
"q c #8adbe5",
"w c #8fdfe8",
"e c #95e1ea",
"r c #a8d1d5",
"t c #aed6db",
"y c #b6d9dd",
"u c #b9dade",
"i c #abdee4",
"p c #b9dbe0",
"a c #ade4e8",
"s c #afe9f0",
"d c #b0eaef",
"f c #baecef",
"g c #beedf1",
"h c #c3c3c3",
"j c #c1d4d6",
"k c #ced8d9",
"l c #c4eaed",
"z c #caeaed",
"x c #cdecf0",
"c c #d7e5e6",
"v c #d7e5e8",
"b c #d3f2f5",
"n c #def4f6",
"m c #e3f4f4",
"M c #eafbfa",
"N c None",
"NNNNoO.NNNNNNNNN",
"NN+ kvj +NNNNNNN",
"N+=mnlia=+NNNNNN",
"N mMng9:f NNNNNN",
"Xybnbsw,3p.NNNNN",
"oclgde4;6z.NNNNN",
".ri0q5-*1t NNNNN",
"N g2:>*$g NNNNNN",
"N+=g8<7g= &NNNNN",
"NN+ uzt +&  NNNN",
"NNNN . N% #h NNN",
"NN NNNNNN @#h NN",
"NN NNNNNNN @#h N",
"     NNNNNN @#h ",
"NN NNNNNNNNN @# ",
"NN NNNNNNNNNN  N"
]

zoomreset = [
"16 16 38 1",
"  c #000000",
". c #0c0c0c",
"X c #101010",
"o c #272727",
"O c #3f3f3f",
"+ c #3f3f40",
"@ c #404041",
"# c #00c0c0",
"$ c aqua",
"% c #7f8281",
"& c #60c1cd",
"* c #6ec4cd",
"= c #68c6d1",
"- c #71c6ce",
"; c #76cbd5",
": c #79cad4",
"> c red",
", c #90d5db",
"< c #90d9df",
"1 c #8bd7e0",
"2 c #8adbe5",
"3 c #8fdfe8",
"4 c #a8d1d5",
"5 c #b6d9dd",
"6 c #abdee4",
"7 c #ade4e8",
"8 c #baecef",
"9 c #beedf1",
"0 c #c1d4d6",
"q c #ced8d9",
"w c gainsboro",
"e c #c4eaed",
"r c #d7e5e6",
"t c #d7e5e8",
"y c #d5f2f4",
"u c #dcf2f3",
"i c #ffc0c0",
"p c None",
">>ppoO.ppppppp>>",
"p>> qt0 +pppp>>p",
"p+>>ue67%+pi>>pp",
"p i>>9<*8 i>>ppp",
"X5yi>>3-:i>>pppp",
"ore9i>>&i>>ppppp",
".4612i>>>> ppppp",
"p 9;*=i>> pppppp",
"p+%9,i>>>>$ppppp",
"pp+ i>> i>> pppp",
"pppi>> p#i>> ppp",
"ppi>>pppp i>> pp",
"pp>>pppppp i>> p",
"p>>pppppppp i>> ",
"p>pppppppppp @> ",
">pppppppppppp  >"
]

# Object3DIcons

image_print_data = [
"22 22 51 1 ",
"  c None",
". c black",
"X c #100810",
"o c #151317",
"O c #181821",
"+ c #211821",
"@ c #252328",
"# c #292931",
"$ c #312931",
"% c #333236",
"& c #393942",
"* c #423942",
"= c gray26",
"- c #524E56",
"; c #5A5A63",
": c #6B656B",
"> c #6B6B73",
", c #736B73",
"< c #7B737B",
"1 c #08FF08",
"2 c #29FF29",
"3 c #31FF31",
"4 c #5ACE5A",
"5 c #6BFF63",
"6 c #7BFF7B",
"7 c #7B7384",
"8 c #847B88",
"9 c #8C7B94",
"0 c #8A858C",
"q c #8C8994",
"w c #948C95",
"e c #99969A",
"r c #9C98A5",
"t c #A59CA9",
"y c #A9A8AB",
"u c #ADADB5",
"i c #BBBBBB",
"p c #B5ADB5",
"a c #94C694",
"s c #9CCEA5",
"d c #BDD6BD",
"f c gray79",
"g c #CECED6",
"h c #D6CED9",
"j c #DAD9DC",
"k c #D6FFD6",
"l c #DEDCE7",
"z c #E7DEE7",
"x c #EAEAEB",
"c c #E7FFE7",
"v c white",
"      pigffgffiiui    ",
"      dxxxxxxxxxji    ",
"      ifffffffffif    ",
"      piiiipiipiyd    ",
"     fyfifffiiifi     ",
"     iipiiiiiiffp     ",
"     ipfiifiififu     ",
"     fidiiiiiiiip     ",
"     ufxzjjjjjjjyyu   ",
"   ie,pggjfjgjjjw-=:p ",
"  dw07<<<<<<<0ww>&@O=y",
" iejxljjjjjhhs4at=O+o&",
"irxvvvvvvvvvk212g9$Oo+",
"yvvvvvvvvvvvc536vl<O.O",
"tlgfghjjjzljljdhgfqo.O",
"wpuyytytttytttteeq:o.+",
"wuutytttrtrrrrreeq:o.o",
"wtttrtrrrrereeerw0:o.-",
"wyttreretereteewq0>ooy",
"w00q0q0qq0qqwqwwqq:oe ",
"i,@O@@@+@#$$%%%%%$%e  ",
"  u;**%%%%%@$@ooX=e   "
]

image_cut_data = [
"22 22 3 1",
". c None",
"# c #000000",
"a c #000082",
"......................",
".......#.....#........",
".......#.....#........",
".......#.....#........",
".......#....##........",
".......##...#.........",
"........#...#.........",
"........##.##.........",
".........###..........",
".........###..........",
"..........#...........",
".........a#a..........",
"........aa.aaa........",
".......a.a.a..a.......",
"......a..a.a...a......",
".....a...a.a....a.....",
"....a....a.a....a.....",
"....a....a..a...a.....",
"....a....a..a..a......",
"....a...a....aa.......",
".....aaa..............",
"......................"
]

image_copy_data = [
"22 22 6 1",
". c None",
"# c #000000",
"b c #000082",
"c c #3c3cfd",
"d c #8b8bfd",
"a c #ffffff",
"......................",
"......................",
"########..............",
"#aaaaaa##.............",
"#a####a#a#............",
"#aaaaaa#aa#...........",
"#a####a#bbbbbbbb......",
"#aaaaaa#baaaaaabb.....",
"#a#####aba####abcb....",
"#aaaaaaabaaaaaabdcb...",
"#a#####aba####abadcb..",
"#aaaaaaabaaaaaabbbbbb.",
"#a#####aba####aaaaaab.",
"#aaaaaaabaaaaaaaaaaab.",
"#a#####aba#########ab.",
"#aaaaaaabaaaaaaaaaaab.",
"########ba#########ab.",
"........baaaaaaaaaaab.",
"........ba#########ab.",
"........baaaaaaaaaaab.",
"........bbbbbbbbbbbbb.",
"......................"
]

image_delete_data = [
"22 22 2 1",
". c None",
"# c #ff0000",
"......................",
"......................",
".................###..",
"...............####...",
".###..........###.....",
"..####.......###......",
"....####....###.......",
"......####.###........",
".......######.........",
"........######........",
"........#######.......",
".......#########......",
".......###..#####.....",
"......####...#####....",
".....####.....#####...",
"....#####.....#####...",
"...#####.......###....",
"...#####.......##.....",
"...####...............",
"....##................",
"......................",
"......................"
]


image_paste_data = [
"22 22 8 1",
". c None",
"# c #000000",
"e c #000084",
"c c #848200",
"b c #848284",
"d c #c6c3c6",
"a c #ffff00",
"f c #ffffff",
"......................",
".......#####..........",
"..######aaa######.....",
".######aaaaa######....",
"##bcb##a###a##bcb##...",
"#bcb#ddddddddd#bcb#...",
"#cbc#ddddddddd#cbc#...",
"#bcb###########bcb#...",
"#cbcbcbcbcbcbcbcbc#...",
"#bcbcbcbcbcbcbcbcb#...",
"#cbcbcbceeeeeeeeee#...",
"#bcbcbcbefffffffefe...",
"#cbcbcbcefeeeeefeffe..",
"#bcbcbcbefffffffefffe.",
"#cbcbcbcefeeeeefeffffe",
"#bcbcbcbefffffffeeeeee",
"#cbcbcbcefeeeeeffffffe",
"#bcbcbcbeffffffffffffe",
"#cbcbcbcefeeeeeeeeeefe",
".#######effffffffffffe",
"........eeeeeeeeeeeeee",
"......................"
]

file_open = ["22 22 5 1",
". c None",
"# c #000000",
"c c #848200",
"a c #ffff00",
"b c #ffffff",
"......................",
"......................",
"......................",
"............####....#.",
"...........#....##.##.",
"..................###.",
".................####.",
".####...........#####.",
"#abab##########.......",
"#babababababab#.......",
"#ababababababa#.......",
"#babababababab#.......",
"#ababab###############",
"#babab##cccccccccccc##",
"#abab##cccccccccccc##.",
"#bab##cccccccccccc##..",
"#ab##cccccccccccc##...",
"#b##cccccccccccc##....",
"###cccccccccccc##.....",
"##cccccccccccc##......",
"###############.......",
"......................"]

file_save = ["22 22 5 1",
". c None",
"# c #000000",
"a c #848200",
"b c #c1c1c1",
"c c #cab5d1",
"......................",
".####################.",
".#aa#bbbbbbbbbbbb#bb#.",
".#aa#bbbbbbbbbbbb#bb#.",
".#aa#bbbbbbbbbcbb####.",
".#aa#bbbccbbbbbbb#aa#.",
".#aa#bbbccbbbbbbb#aa#.",
".#aa#bbbbbbbbbbbb#aa#.",
".#aa#bbbbbbbbbbbb#aa#.",
".#aa#bbbbbbbbbbbb#aa#.",
".#aa#bbbbbbbbbbbb#aa#.",
".#aaa############aaa#.",
".#aaaaaaaaaaaaaaaaaa#.",
".#aaaaaaaaaaaaaaaaaa#.",
".#aaa#############aa#.",
".#aaa#########bbb#aa#.",
".#aaa#########bbb#aa#.",
".#aaa#########bbb#aa#.",
".#aaa#########bbb#aa#.",
".#aaa#########bbb#aa#.",
"..##################..",
"......................"]



IconDict0 = {
    "derive": derive,
    "close": close,
    "clipboard": clipboard,
    "fileclose": fileclose,
    "fileopen": file_open,
    "filesave": file_save,
    "fileprint": image_print_data,
    "spec": spec,
    "bliss": bliss,
    "normal": normal,
    "normalize16": normalize16,
    "reload": reload_,
    "window_fullscreen": window_fullscreen,
    "window_new": window_new,
    "window_nofullscreen": window_nofullscreen,
    "zoomplus": zoomplus,
    "zoomminus": zoomminus,
    "zoomreset": zoomreset,
    "zoom": zoom,
    "logx": logx,
    "logy": logy,
    "peak": peak,
    "peakreset": peakreset,
    "peaksearch": peaksearch,
    "roi": roi,
    "roireset": roireset,
    "selected": selected,
    "unselected": unselected,
    "fit": fit,
    "energy": energy,
    "xauto": xauto,
    "yauto": yauto,
    "colormap": colormap,
    "colormap16": colormap16,
    "gioconda16": gioconda16,
    "gioconda16mirror": gioconda16mirror,
    "grid16": grid16,
    "image": image,
    "eraseselect": eraseselect,
    "boxselect": boxselect,
    "brush": brush,
    "brushselect": brushselect,
    "rgb16": rgb16,
    "rgb": rgb,
    "sliderson": sliderson,
    "slidersoff": slidersoff,
    "sigma": sigma,
    "swapsign": swapsign,
    "ymintozero": ymintozero,
    "average16": average16,
    "square": square16,
    "polygon": polygon16,
    "rectangle": rectangle16,
    "circle": circle16,
    "ellipse": ellipse16,
    "solidcircle": solid_circle16,
    "solidellipse": solid_ellipse16,
    "smooth": smooth,
    "subtract": subtract,
    "substract": substract,
    "togglepoints": togglepoints,
    "remove": remove,
    "additionalselect": additionalselect,
    "crop": crop,
    "plugin": plugin,
    "horizontal": horizontal,
    "vertical": vertical,
    "diagonal": diagonal,
    "rotate_left": rotate_left,
    "rotate_right": rotate_right
}

# corresponding silx icons
TRANSLATION_TABLE = {
    "clipboard": "edit-copy",
    "average16": "math-average",
    "derive": "math-derive",
    "close": "close",
    "crop": "crop",
    #"fileclose": fileclose,
    "fileopen": "document-open",
    "filesave": "document-save",
    #"fileprint": "document-print", PyMca icon is nicer
    "spec": "spec",
    "normal": "normal",
    "normalize16": "math-normalize",
    "reload": "view-refresh",
    "window_fullscreen": "view-fullscreen",
    #"window_new": window_new,
    "window_nofullscreen": "view-nofullscreen",
    "zoomplus": "zoom-in",
    "zoomminus": "zoom-out",
    "zoomreset": "zoom-original",
    "zoom": "zoom",
    "logx": "plot-xlog",
    "logy": "plot-ylog",
    "peak": "math-peak",
    "peakreset": "math-peak-reset",
    "peaksearch": "math-peak-search",
    #"roi": "plot-roi",
    "roireset": "plot-roi-reset",
    "selected": "selected",
    #"unselected": unselected,
    "fit": "math-fit",
    "energy": "math-energy",
    "xauto": "plot-xauto",
    "yauto": "plot-yauto",
    "colormap": "colormap",
    "colormap16": "colormap",
    #"gioconda16": gioconda16,
    #"gioconda16mirror": gioconda16mirror,
    "grid16": "plot-grid",
    #"image": image,
    #"eraseselect": eraseselect,
    #"boxselect": boxselect,
    "brush": "draw-brush",
    #"brushselect": brushselect,
    #"rgb16": rgb16,
    #"rgb": rgb,
    "sliderson": "sliders-on",
    "slidersoff": "sliders-off",
    "sigma": "math-sigma",
    "swapsign": "math-swap-sign",
    "ymintozero": "math-ymin-to-zero",
    "square": "shape-square",
    "polygon": "shape-polygon",
    "rectangle": "shape-rectangle",
    "circle": "shape-circle",
    "ellipse": "shape-ellipse",
    "solidcircle": "shape-circle-solid",
    "solidellipse": "shape-ellipse-solid",
    "smooth": "math-smooth",
    "subtract": "math-substract",
    "substract": "math-substract",
    "togglepoints": "plot-toggle-points",
    "remove": "remove",
    #"additionalselect": additionalselect,
    #"plugin": plugin,
    "horizontal": "shape-horizontal",
    "vertical": "shape-vertical",
    "diagonal": "shape-diagonal",
    #"rotate_left": rotate_left,
    #"rotate_right": rotate_right
    }


class _PatchedIconDict(MutableMapping):
    """IconDict that patches some legacy icons with new
    silx icons, when available.

    This object must be initialized with a legacy dictionary of icons.
    If silx is installed and a corresponding silx icon name is specified in
    TRANSLATION_TABLE, the silx icon is returned by __getitem__ rather
    than the legacy icon.

    This object allows modifying the icon dict via __setitem__ and
    deleting icons, like a real dict.
    """
    def __init__(self, *args, **kw):
        self._unpatched_icons = dict(*args, **kw)
        self.__initialized = False

    def __iter__(self):
        for key in self._unpatched_icons:
            yield key

    def __len__(self):
        # same length
        return len(self._unpatched_icons)

    def __getitem__(self, key):
        if not self.__initialized:
            from PyMca5.PyMcaGui import PyMcaQt as qt
            self._qt = qt
            try:
                from silx.gui import icons as silx_icons
                IconDict = {}
            except ImportError:
                _logger.debug("Could not import silx. Legacy icons will be used.")
                silx_icons = None
                from PyMca5.PyMcaGui.plotting.Silx_Icons import IconDict

            self._silx_icons = silx_icons
            # keep an internal copy:
            self._translation_table = TRANSLATION_TABLE.copy()
            self.__initialized = True
            self._fallBackDict = IconDict

        if key not in self._unpatched_icons:
            raise KeyError("Unknown icon '%s'" % key)

        if key not in TRANSLATION_TABLE:
            _logger.debug("Using legacy icon '%s' because there is no "
                          "corresponding icon.",
                          key)
            return self._unpatched_icons[key]

        if self._silx_icons is None:
            if TRANSLATION_TABLE[key] in self._fallBackDict:
                _logger.info("Using fallback translation '%s' for '%s'" %
                              (TRANSLATION_TABLE[key], key))
                return self._fallBackDict[TRANSLATION_TABLE[key]]
            _logger.debug("Using legacy icon '%s' because silx is not "
                          "available or because it has no corresponding icon.",
                          key)
            return self._unpatched_icons[key]

        if self._qt.QApplication.instance() is None:
            _logger.warning("Cannot fetch QPixmap without a QApplication."
                            " Using legacy PyMca icon as fallback.")
            return self._unpatched_icons[key]

        try:
            icon = self._silx_icons.getQPixmap(TRANSLATION_TABLE[key])
        except ValueError:
            _logger.warning("Icon '%s' not found in silx. "
                            "Using legacy PyMca icon '%s'.",
                            TRANSLATION_TABLE[key], key)
            icon = self._unpatched_icons[key]
        else:
            _logger.debug("Using silx icon '%s' instead of legacy icon '%s'.",
                          TRANSLATION_TABLE[key], key)
        finally:
            return icon

    def __delitem__(self, key):
        # deleting from legacy dict is enough
        del self._unpatched_icons[key]

    def __setitem__(self, key, item):
        self._unpatched_icons[key] = item
        if self._silx_icons is not None and key in self._translation_table:
            # we also need to remove the key from internal translation table
            del self._translation_table[key]


IconDict = _PatchedIconDict(IconDict0)


def change_icons(plot):
    """Replace some of the silx icons with PyMca icons.

    :param plot: Silx plot window, or SilxScanWindow, or SilxMcaWindow
    :return:
    """
    from PyMca5.PyMcaGui import PyMcaQt as qt
    plot.getRoiAction().setIcon(qt.QIcon(qt.QPixmap(IconDict["roi"])))
    if hasattr(plot, "printPreview"):
        plot.printPreview.setIcon(qt.QIcon(qt.QPixmap(IconDict["fileprint"])))


def showIcons():
    w = qt.QWidget()
    g = qt.QGridLayout(w)

    idx = 0
    keyList = list(IconDict.keys())
    keyList.sort()
    for key in keyList:
        print("name = ", key)
        name = key
        icon = IconDict[name]
        column = int(idx / 20)
        row = idx % 20
        lab = qt.QLabel(w)
        lab.setText(str(name))
        g.addWidget(lab, row, 2 * column + 1)
        lab = qt.QLabel(w)
        lab.setPixmap(qt.QPixmap(icon))
        g.addWidget(lab, row, 2 * column)
        idx += 1

    w.show()
    return w

if __name__ == '__main__':
    from PyMca5.PyMcaGui import PyMcaQt as qt
    app = qt.QApplication(sys.argv)
    app.lastWindowClosed.connect(app.quit)
    logging.basicConfig()
    _logger.setLevel(logging.DEBUG)
    w = showIcons()
    app.exec_()
    app = None
