/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.api;

import java.util.concurrent.atomic.AtomicBoolean;
import net.sourceforge.plantuml.api.MyRunnable;

public final class TimeoutExecutor {
    private final long ms;

    public TimeoutExecutor(long ms) {
        this.ms = ms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeNow(MyRunnable task) {
        MyThread mainThread = new MyThread(task);
        boolean done = false;
        try {
            mainThread.start();
            mainThread.join(this.ms);
        }
        catch (InterruptedException e) {
            System.err.println("TimeoutExecutorA " + e);
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            done = mainThread.done.get();
            if (!done) {
                task.cancelJob();
                mainThread.interrupt();
            }
        }
        return done;
    }

    class MyThread
    extends Thread {
        private final MyRunnable task;
        private final AtomicBoolean done = new AtomicBoolean(false);

        private MyThread(MyRunnable task) {
            this.task = task;
        }

        @Override
        public void run() {
            try {
                this.task.runJob();
                this.done.set(true);
            }
            catch (InterruptedException e) {
                System.err.println("TimeoutExecutorB " + e);
                e.printStackTrace();
            }
        }
    }
}

