# Demonstrate UF3 W potential

# # ============= Initialize simulation

variable        nsteps index 100
variable        nrep equal 4
variable        a equal 3.3005
units           metal

# generate the box and atom positions using a BCC lattice

variable        nx equal ${nrep}
variable        ny equal ${nrep}
variable        nz equal ${nrep}

boundary        p p p

lattice         bcc $a
region          box block 0 ${nx} 0 ${ny} 0 ${nz}
create_box      1 box
create_atoms    1 box

mass            1 92.906

# # ============= set pair style

pair_style      uf3 3
pair_coeff      * * Nb.uf3 Nb


# # ============= Setup output

thermo          10
thermo_modify   norm yes

# # ============= Set up NVE run

timestep        0.5e-3
neighbor        1.0 bin
neigh_modify    once no every 1 delay 0 check yes

# # ============= Run MD

velocity        all create 300.0 2367804 loop geom
fix             1 all nve
run             ${nsteps}
