#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2018 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Dropsy
# send your bug reports to bugs@dotslashplay.it
###

script_version=20241224.2

PLAYIT_COMPATIBILITY_LEVEL='2.31'

GAME_ID='dropsy'
GAME_NAME='Dropsy'

ARCHIVE_BASE_0_NAME='dropsy_1_5_linux_76112.sh'
ARCHIVE_BASE_0_MD5='b7003615929f2cf7261c54f3b145623c'
ARCHIVE_BASE_0_SIZE='1071861'
ARCHIVE_BASE_0_VERSION='1.5-gog76112'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/dropsy'

ARCHIVE_BASE_MULTIARCH_0_NAME='gog_dropsy_2.5.0.6.sh'
ARCHIVE_BASE_MULTIARCH_0_MD5='6739e9f516043ee90b033b55c3e3f35c'
ARCHIVE_BASE_MULTIARCH_0_SIZE='910000'
ARCHIVE_BASE_MULTIARCH_0_VERSION='1.4-gog2.5.0.6'

UNITY3D_NAME='Dropsy'
UNITY3D_PLUGINS_MULTIARCH='
ScreenSelector.so'

CONTENT_PATH_DEFAULT='data/noarch/game'

USER_PERSISTENT_DIRECTORIES='
Save'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'
PACKAGES_LIST_MULTIARCH='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN64_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN32_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libm.so.6
libpthread.so.0
librt.so.1
libz.so.1'
PKG_BIN_DEPENDENCIES_LIBRARIES_MULTIARCH='
libc.so.6
libdl.so.2
libgcc_s.so.1
libgdk_pixbuf-2.0.so.0
libglib-2.0.so.0
libGL.so.1
libgobject-2.0.so.0
libgtk-x11-2.0.so.0
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6
libX11.so.6
libXcursor.so.1
libXrandr.so.2'
PKG_BIN64_DEPENDENCIES_LIBRARIES_MULTIARCH="$PKG_BIN_DEPENDENCIES_LIBRARIES_MULTIARCH"
PKG_BIN32_DEPENDENCIES_LIBRARIES_MULTIARCH="$PKG_BIN_DEPENDENCIES_LIBRARIES_MULTIARCH"

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	# Prevent the inclusion of Steam libraries
	case "$(current_archive)" in
		('ARCHIVE_BASE_MULTIARCH_'*)
			# The multiarch archives rely on UNITY3D_PLUGINS to exclude unwanted libraries.
		;;
		(*)
			rm --recursive "$(unity3d_name)_Data/Plugins"
		;;
	esac
)

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

case "$(current_archive)" in
	('ARCHIVE_BASE_MULTIARCH_'*)
		launchers_generation 'PKG_BIN64'
		launchers_generation 'PKG_BIN32'
	;;
	(*)
		launchers_generation 'PKG_BIN'
	;;
esac

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
