!--------------------------------------------------------------------------
! Copyright (c) 2002-2011 SPMODEL Development Group. All rights reserved.!
!--------------------------------------------------------------------------
!
!ɽ  at_module ƥȥץ
!      Laplacian ղ
!
!  2007/11/19  ݹ  顼åɲ
!      2011/03/06  ʿ dc_test Ȥ褦˽
!
!
program et_test_LaplaInv

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use et_module
  implicit none

 !---- ֲ ----
  integer, parameter :: im=32, jm=32            ! ʻ(X,Y)
  integer, parameter :: km=10, lm=21              ! ȿ(X,Y)

 !---- ɸѿʤ ----
  real(8), parameter :: xmin = -1.0d0, xmax=1.0d0
  real(8), parameter :: ymin = 0.0d0, ymax=1.0d0

  real(8)            :: yx_A(0:jm,0:im-1)     ! ʻҥǡ
  real(8)            :: yx_A_sol(0:jm,0:im-1)  ! ʻҥǡ
  real(8)            :: et_A(-km:km,0:lm)     ! ڥȥǡ
  real(8)            :: values(-km:km,2)

  real(8), parameter :: pi=3.1415926535897932385D0
  integer            :: k=2

  ! Ƚ
  integer, parameter :: check_digits = 10
  integer, parameter :: ignore = -11



  call MessageNotify('M','et_test_LaplaInv', &
       'et_module Inverse Laplacian tests')

 !---------------- ɸͤ ---------------------
  call et_initial(im,jm,km,lm,xmin,xmax,ymin,ymax)    ! ڥȥ

  yx_A = sin(k*pi*yx_X)*sin(pi*yx_Y)
  yx_A_sol = -sin(k*pi*yx_X)*sin(pi*yx_Y)/((k*pi)**2 + pi**2)
  et_A = et_yx(yx_a)
  values = 0.0D0
  yx_A = yx_et(et_LaplaInv_et(et_A,values))

    call AssertEqual(                                           &
      message='Test of et_LaplaInv',                            &
      answer = yx_A_sol,                                        &
      check = yx_A,                                             &
      significant_digits = check_digits, ignore_digits = ignore &
      )
  call MessageNotify('M','Test of et_LaplaInv', &
    'et_module Inverse Laplacian tests OK!')

end program et_test_LaplaInv
