!----------------------------------------------------------------------
! COPYRIGHT (c) 2007-2010 SPMODEL Development Group. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  au_module ƥȥץ
!
!  2007/12/28  ݹ  
!      2010/12/21  ʿ dc_test Ѥ褦˽
!      
!
program au_test_weight

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use au_module
  implicit none
  integer, parameter :: im=32, km=32
  real(8), parameter :: ra=2.0D0

  ! Ƚ
  integer, parameter :: check_digits = 6
  integer, parameter :: ignore = -6

  real(8), dimension(0:im) :: g_z

  integer :: i
  
  call MessageNotify('M','au_test_weight', 'au_module weight function tests')

  do i=1,2
    
    call au_initial(im,km/i,ra,(/1/))

    g_z(:) = 1.0D0
    
    call AssertEqual(&
      message='Test1: z = 1, int_0^a z dr ',                        &
      answer = ra,                                                  &
      check = sum(g_z*g_R_weight),                                  &
      significant_digits = check_digits, ignore_digits = ignore     &
      )
    
    g_z(:) = g_R**2
    
    call AssertEqual(&
      message='Test2: z = R**2, int_0^a z dr ',                     &
      answer = ra**3/3.0D0,                                         &
      check = sum(g_z*g_R_weight),                                  &
      significant_digits = check_digits, ignore_digits = ignore     &
      )
    
    g_z(:) = g_R**3
    
    call AssertEqual(&
      message='Test3: z = R**3, int_0^a z dr ',                     &
      answer = ra**4/4.0D0,                                         &
      check = sum(g_z*g_R_weight),                                  &
      significant_digits = check_digits, ignore_digits = ignore     &
      )
    
  end do
  
  call MessageNotify('M','au_test_weight', &
    'au_module weight function tests succeeded!')
  
end program au_test_weight
