!-----------------------------------------------------------------------
!     Copyright (c) 2002 GFD Dennou Club. All Rights Reserved.
!-----------------------------------------------------------------------
program marker

  use dcl
  integer,parameter :: n=41
  real :: x(n), y(n)

    dt = 4.* 3.14159 / (n-1)
    do i=1,n
      y(i) = sin(dt*(i-1))*0.15
      x(i) = real(i-1)/real(n-1)
    end do

    call DclOpenGraphics
    call DclNewFrame
    call DclSetWindow( 0.0, 1.0, -0.8, 0.2)
    call DclSetViewPort( 0.1, 0.9,  0.1, 0.9)
    call DclSetTransNumber( 1)
    call DclSetTransFunction

    call DclSetParm( 'ENABLE_CLIPPING', .true.)
    call DclDrawViewPortFrame(1)

    call DclDrawMarker(x, y)                    ! <-- }[J[` (1)
    call DclDrawMarker(x, y-0.1, type=2)        ! <-- }[J[` (2)
    call DclDrawMarker(x, y-0.2, type=3)        ! <-- }[J[` (3)
    call DclDrawMarker(x, y-0.3, type=2,height=0.06)! <-- }[J[` (4)
    call DclDrawMarker(x, y-0.4, index=2)       ! <-- }[J[` (5)
    call DclDrawMarker(x, y-0.5, index=3,type=2)! <-- }[J[` (6)
    call DclDrawLine(x, y-0.5)                  ! <-- ܂`

    call DclCloseGraphics

end program
