!----------------------------------------------------------------------
!     Copyright (c) 2005 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!ɽ  wa_spectrum_module
!
!  2005/04/23  ݹ 
!      2005/05/16  ݹ ؿ̾û
!
module wa_spectrum_module
  use w_base_module, only : nm, l_nm

  implicit none

  private
 
  public nma_EnergyFromStreamfunc_wa      ! ͥ륮ڥȥ
                                          ! (ʿȿ n, Ӿȿ m )
  public na_EnergyFromStreamfunc_wa       ! ͥ륮ڥȥ
                                          ! (ʿȿ n )
  public nma_EnstrophyFromStreamfunc_wa   ! 󥹥ȥեڥȥ
                                          ! (ʿȿ n, Ӿȿ m )
  public na_EnstrophyFromStreamfunc_wa    ! 󥹥ȥեڥȥ
                                          !  (ʿȿ n )
  public wa_spectrum_VMiss                ! »

  real(8) :: wa_spectrum_VMiss = -999.000 ! »ͽ
  integer n,m                             ! DO ѿ

  contains

  !--------------- ͥ륮ڥȥ׻ -----------------
    function nma_EnergyFromStreamfunc_wa(wa_Strfunc)
      real(8), intent(in)   :: wa_Strfunc(:,:)    ! ήؿ(ڥȥǡ)
      real(8), dimension(0:nm,-nm:nm,size(wa_Strfunc,2)) &
           :: nma_EnergyFromStreamfunc_wa         ! ͥ륮ڥȥ

      nma_EnergyFromStreamfunc_wa = wa_spectrum_VMiss

      do n=0,nm
         do m=-n,n
            nma_EnergyFromStreamfunc_wa(n,m,:) &
                 = 0.5 * n*(n+1) * wa_Strfunc(l_nm(n,m),:)**2
         enddo
      enddo
    end function nma_EnergyFromStreamfunc_wa

    function na_EnergyFromStreamfunc_wa(wa_Strfunc)
      real(8), intent(in)   :: wa_Strfunc(:,:)   ! ήؿ(ڥȥǡ)
      real(8), dimension(0:nm,size(wa_Strfunc,2)) &
           :: na_EnergyFromStreamfunc_wa         ! ͥ륮ڥȥ

      do n=0,nm
         na_EnergyFromStreamfunc_wa(n,:)  &
              = 0.5 * n*(n+1) &
                * sum(wa_StrFunc(l_nm(n,(/(m,m=-n,n)/)),:)**2,1)
      enddo

    end function na_EnergyFromStreamfunc_wa

  !--------------- 󥹥ȥեڥȥ׻ -----------------

    function nma_EnstrophyFromStreamfunc_wa(wa_Strfunc)  ! 
      real(8), intent(in)   :: wa_Strfunc(:,:)     ! ήؿ(ڥȥǡ)
      real(8), dimension(0:nm,-nm:nm,size(wa_Strfunc,2)) &
           :: nma_EnstrophyFromStreamfunc_wa       ! 󥹥ȥեڥȥ

      nma_EnstrophyFromStreamfunc_wa = wa_spectrum_VMiss

      do n=0,nm
         do m=-n,n
            nma_EnstrophyFromStreamfunc_wa(n,m,:) &
                 = 0.5 * n**2 * (n+1)**2 &
                    * wa_Strfunc(l_nm(n,m),:)**2

         enddo
      enddo
    end function nma_EnstrophyFromStreamfunc_wa

    function na_EnstrophyFromStreamfunc_wa(wa_Strfunc)  ! 
      real(8), intent(in)   :: wa_Strfunc(:,:)   ! ήؿ(ڥȥǡ)
      real(8), dimension(0:nm,size(wa_Strfunc,2)) &
           :: na_EnstrophyFromStreamfunc_wa      ! 󥹥ȥեڥȥ

      do n=0,nm
         na_EnstrophyFromStreamfunc_wa(n,:)  &
              = 0.5 * n**2 * (n+1)**2 &
                * sum(wa_StrFunc(l_nm(n,(/(m,m=-n,n)/)),:)**2,1)
      enddo

    end function na_EnstrophyFromStreamfunc_wa

end module wa_spectrum_module
