!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!ɽ  wa_integral_module
!
!  2002/05/25  ݹ 
!
module wa_integral_module
  use w_base_module, only : im, jm, x_Lon_Weight, y_Lat_Weight

  implicit none

  private
 
  public a_IntLonLat_xya                      ! ٷʬ
  public ya_IntLon_xya, a_IntLon_xa           ! ʬ    
  public xa_IntLat_xya, a_IntLat_ya           ! ʬ    
  public a_AvrLonLat_xya                      ! ٷʿ
  public ya_AvrLon_xya, a_AvrLon_xa           ! ʿ    
  public xa_AvrLat_xya, a_AvrLat_ya           ! ʿ    

  contains

  !--------------- ʬ׻ -----------------
    function a_IntLonLat_xya(xya_data)        ! ٷʬ
      real(8), intent(in)   :: xya_data(:,:,:)           ! ʻ(im,jm,*)
      real(8) :: a_IntLonLat_xya(size(xya_data,3))       ! ʻ(*)

      a_IntLonLat_xya = a_IntLon_xa(xa_IntLat_xya(xya_data))
    end function a_IntLonLat_xya

    function xa_IntLat_xya(xya_data)          ! ʬ
      real(8), intent(in) :: xya_data(:,:,:)              ! ʻ(im,jm,*)
      real(8)             :: xa_IntLat_xya(im,size(xya_data,3)) ! ʻ(im,*)
      Integer :: j

      xa_IntLat_xya = 0
      do j=1,jm
         xa_IntLat_xya = xa_IntLat_xya + xya_data(:,j,:) * y_Lat_Weight(j)
      enddo

    end function xa_IntLat_xya

    function ya_IntLon_xya(xya_data)          ! ʬ
      real(8), intent(in) :: xya_data(:,:,:)               ! ʻ(im,jm,*)
      real(8)             :: ya_IntLon_xya(jm,size(xya_data,3)) ! ʻ(jm,*)
      integer :: i

      ya_IntLon_xya = 0
      do i=1,im
         ya_IntLon_xya = ya_IntLon_xya + xya_data(i,:,:) * x_Lon_Weight(i)
      enddo

    end function ya_IntLon_xya

    function a_IntLat_ya(ya_data)          ! ʬ
      real(8), intent(in) :: ya_data(:,:)                 ! ʻ(jm,*)
      real(8)             :: a_IntLat_ya(size(ya_data,2)) ! ʻ(*)
      integer :: j

      a_IntLat_ya = 0
      do j=1,jm
         a_IntLat_ya = a_IntLat_ya + ya_data(j,:) * y_Lat_Weight(j)
      enddo

    end function a_IntLat_ya

    function a_IntLon_xa(xa_data)          ! ʬ
      real(8), intent(in) :: xa_data(:,:)                 ! ʻ(im,*)
      real(8)             :: a_IntLon_xa(size(xa_data,2)) ! ʻ(*)
      integer :: i

      a_IntLon_xa = 0
      do i=1,im
         a_IntLon_xa = a_IntLon_xa + xa_data(i,:) * x_Lon_Weight(i)
      enddo

    end function a_IntLon_xa

  !--------------- ʿѷ׻ -----------------
    function a_AvrLonLat_xya(xya_data)        ! ٷʿ
      real(8), intent(in)   :: xya_data(:,:,:)         ! ʻ(im,jm,*)
      real(8) :: a_AvrLonLat_xya(size(xya_data,3))       ! ʻ(*)

      a_AvrLonLat_xya = a_AvrLon_xa(xa_AvrLat_xya(xya_data))
    end function a_AvrLonLat_xya

    function xa_AvrLat_xya(xya_data)          ! ʿ
      real(8), intent(in) :: xya_data(:,:,:)           ! ʻ(im,jm,*)
      real(8)             :: xa_AvrLat_xya(im,size(xya_data,3)) ! ʻ(im,*)

      xa_AvrLat_xya = xa_IntLat_xya(xya_data)/sum(y_Lat_Weight)

    end function xa_AvrLat_xya

    function ya_AvrLon_xya(xya_data)          ! ʿ
      real(8), intent(in) :: xya_data(:,:,:)               ! ʻ(im,jm,*)
      real(8)             :: ya_AvrLon_xya(jm,size(xya_data,3)) ! ʻ(jm,*)

      ya_AvrLon_xya = ya_IntLon_xya(xya_data)/sum(x_Lon_Weight)

    end function ya_AvrLon_xya

    function a_AvrLat_ya(ya_data)          ! ʿ
      real(8), intent(in) :: ya_data(:,:)                ! ʻ(jm,*)
      real(8)             :: a_AvrLat_ya(size(ya_data,2)) ! ʻ(*)

      a_AvrLat_ya = a_IntLat_ya(ya_data)/sum(y_Lat_Weight)

    end function a_AvrLat_ya

    function a_AvrLon_xa(xa_data)          ! ʿ
      real(8), intent(in) :: xa_data(:,:)                ! ʻ(im,*)
      real(8)             :: a_AvrLon_xa(size(xa_data,2)) ! ʻ(*)

      a_AvrLon_xa = a_IntLon_xa(xa_data)/sum(x_Lon_Weight)

    end function a_AvrLon_xa

  end module wa_integral_module
