!----------------------------------------------------------------------
!     Copyright (c) 2005 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!$BI=Bj(B  at_module $B%5%s%W%k%W%m%0%i%`(B : $B@~7A2r@O(B($B<B6u4V(B)
!
!      $B3H;6J}Dx<0(B d zeta/dt = kappa d^2 zeta/dx^2
!
!$BMzNr(B  2005/01/27  $BC]9-??0l(B
!
program at_diff_lanal

  use eigmatrix
  use lumatrix
  use at_module
  use gt4_history
  implicit none

 !---- $B6u4V2rA|EY@_Dj(B ----
  integer, parameter :: im=16               ! $B3J;RE@$N@_Dj(B
  integer, parameter :: km=16               ! $B@ZCGGH?t$N@_Dj(B
  integer, parameter :: nm=10               ! $B=PNO8GM-%b!<%I$N@_Dj(B

 !---- $B:BI8JQ?t$J$I(B ----
  real(8), parameter :: xmin=0.0D0, xmax=1.0D0   ! $BHO0O(B

 !---- $BJQ?t(B ----
  real(8), dimension(0:im)  :: g_zeta
  real(8), dimension(0:km)  :: t_zeta

  real(8), dimension(0:km)  :: t_dzetadt

 !---- $B@~7A2r@OMQJQ?t!<(B ----
  real(8), dimension(im-1,im-1)  :: matrix   ! $B78?t9TNs(B

  real(8), dimension(nm)       :: eigen_r     ! $B8GM-CM<BIt(B
  real(8), dimension(nm)       :: eigen_i     ! $B8GM-CM5uIt(B
  real(8), dimension(im-1,nm)  :: eigvec_r    ! $B8GM-%Y%/%H%k<BIt(B
  real(8), dimension(im-1,nm)  :: eigvec_i    ! $B8GM-%Y%/%H%k5uIt(B

 !---- $BJ*M}%Q%i%a%?!<(B ----
  real(8), parameter, dimension(2) :: zetabndry=(/0.0,0.0/)  ! $B6-3&CM(B
  real(8), parameter :: kappa=1.0               ! $B3H;678?t(B

  integer info, i, n

 !---------------- $B:BI8CM$N@_Dj(B ---------------------
  call at_initial(im,km,xmin,xmax)

 !---------------- $B78?t9TNs7W;;(B ---------------------
  do i=1,im-1
     g_zeta    = 0.0
     g_zeta(i) = 1.0
     call boundaries
     t_zeta = t_g(g_zeta)
     t_dzetadt = kappa * t_dx_t(t_dx_t(t_zeta) )

     g_zeta    = g_t(t_dzetadt)
     matrix(:,i) = g_zeta(1:im-1)
  enddo

 !------------------ $B8GM-CM7W;;(B ---------------------
  call eigen(matrix,eigen_r,eigen_i,eigvec_r,eigvec_i,info,&
             sort='R',reverse=.true.)

 !------------------- $B=PNO(B ----------------------
  call output_gtool4_init                            ! $B%R%9%H%j!<=i4|2=(B
  call output_gtool4
  call output_gtool4_close                           ! $B%R%9%H%j!<8e=hM}(B

  stop

  contains

    subroutine boundaries
      g_zeta(0) = zetabndry(1)
      g_zeta(im) = zetabndry(2)
    end subroutine boundaries

    subroutine output_gtool4_init
      call HistoryCreate( &                               ! $B%R%9%H%j!<:n@.(B
           file='at_diff_eigen_grid.nc', title='Linear analysis fo diffusion equation (Grid base)', &
           source='Sample program of gtool_history/gtool4', &
           institution='GFD_Dennou Club davis/spmodel project',&
           dims=(/'x   ','mode'/), dimsizes=(/im+1,0/), &
           longnames=(/'X-coordinate','mode number '/),    &
           units=(/'1','1'/),                              &
           origin=1.0, interval=1.0 ) 

      call HistoryPut('x',g_x)                            ! $BJQ?t=PNO(B

      call HistoryAddVariable( &                          ! $BJQ?tDj5A(B
           varname='eigen_r', dims=(/'mode'/), & 
           longname='Eigen value (Real part)', units='1', xtype='double')
      call HistoryAddVariable( &                          ! $BJQ?tDj5A(B
           varname='eigen_i', dims=(/'mode'/), & 
           longname='Eigen value (Imaginary part)', units='1', xtype='double')

      call HistoryAddVariable( &                          ! $BJQ?tDj5A(B
           varname='eigvec_r', dims=(/'x   ','mode'/), & 
           longname='Eigen vector (R)', units='1', xtype='double')
      call HistoryAddVariable( &                          ! $BJQ?tDj5A(B
           varname='eigvec_i', dims=(/'x   ','mode'/), & 
           longname='Eigen vector (I)', units='1', xtype='double')

    end subroutine output_gtool4_init

    subroutine output_gtool4
      do n=1,nm
         call HistoryPut('mode',real(n))
         call HistoryPut('eigen_r',eigen_r(n))
         call HistoryPut('eigen_i',eigen_i(n))

         g_zeta(1:im-1) = eigvec_r(:,n)
         call boundaries
         call HistoryPut('eigvec_r',g_zeta)
         g_zeta(1:im-1) = eigvec_i(:,n)
         call boundaries
         call HistoryPut('eigvec_i',g_zeta)
      enddo
    end subroutine output_gtool4
 
    subroutine output_gtool4_close
      call HistoryClose
    end subroutine output_gtool4_close

end program at_diff_lanal
