!----------------------------------------------------------------------
!     Copyright (c) 2005 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  at_ab_galerkin_ND_test2d
!
!      ӥաݥ顼ˡ
!      üΥޥüǥꥯ춭ѥ⥸塼ƥȥץ(2)
!          f'(:,i=0)=f(:,i=im)=0 [ f'(:,x=xmax)=f(:,x=xmin)=0 ]
!
!      1 : f(x) = sin(pi/2*x),    0<x<1
!      2 : f(x) = sin(3*pi/2*x),  0<x<1
!
!  2005/12/30  ݹ  
!      2006/01/23  ݹ  ⥸塼̾ѹȼ
!
program at_ab_galerkin_ND_test2d

  use at_ab_galerkin_ND
  use at_module

  implicit none

  integer, parameter :: jm=2                   ! 1 ܳʻ
  integer, parameter :: im=32                  ! ʻ              
  integer, parameter :: km=32                  ! ӥȿ  
  integer, parameter :: ks=2                   ! 顼㼡
  real(8), parameter :: xmin=0.0, xmax=1.0     ! ׻ΰ

  real(8) :: ag_data(jm,0:im)
  real(8) :: ag_data_orig(jm,0:im)

  real(8) :: ab_data(jm,ks:km)

  real(8) :: pi

  pi = atan(1.0D0)*4.0D0

  call at_Initial(im,km,xmin,xmax)
  call at_ab_galerkin_ND_Initial(im,km)           !--- ξüǥꥯ ---

  ag_data(1,:) = sin(pi/2*g_X)
  ag_data(2,:) = sin(3*pi/2*g_X)
  ag_data_orig = ag_data

  ab_data = ab_ag(ag_data)
  ag_data = ag_ab(ab_data)

  write(6,*) 
  write(6,*) '*** Max. Error of Grid -> Galerkin -> Grid conversion ***'
  write(6,*) 
  write(6,*) 'sin (pi/2*X)   :', maxval(abs(ag_data_orig(1,:)-ag_data(1,:)))
  write(6,*) 'sin (3*pi/2*X) :', maxval(abs(ag_data_orig(2,:)-ag_data(2,:)))

!  
!  ag_data = ag_ab(ab_Dx_ab(ab_Dx_ab(ab_data)))

!  褤 : ʬͤϥӥշݻ٤
  ab_data = ab_at(at_Dx_at(at_Dx_at(at_ab(ab_data))))
  ag_data = ag_ab(ab_data)

  write(6,*) 
  write(6,*) '*** Max. Error of of Grid -> Galerkin -> (Dx)^2 -> Grid conversion ***'
  write(6,*) 
  write(6,*) 'sin (pi/2*X)   :', &
       maxval(abs(-pi**2/4 * ag_data_orig(1,:)-ag_data(1,:)))
  write(6,*) 'sin (3*pi/2*X) :', &
       maxval(abs(-9*pi**2/4 * ag_data_orig(2,:)-ag_data(2,:)))

end program at_ab_galerkin_ND_test2d
