!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!ɽ  w_base_module
!
!  2001/12/08  ݹ
!      2001/12/26  ݹ  ؿ,ѿ̾ѹ
!      2002/02/07  ݹ  ؿ,ѿ̾ѹ
!      2002/03/30  ݹ  ؿ,ѿ̾ƺѹ
!      2002/05/25  ݹ  ʻɸ̤٤̿̾ˡѹ
!
!      
!         Ѵʻǡ, ڥȥǡ礭Ϸᤦ
!
module w_base_module
  implicit none

  integer               :: im=64, jm=32     ! ʻ(, )
  integer               :: nm=21            ! ȿ

  integer               :: it(6)            ! Ѵ
  real(8), allocatable  :: t(:)             ! Ѵ
  integer, allocatable  :: ip(:)            ! Ѵ
  real(8), allocatable  :: p(:), r(:)       ! Ѵ
  integer, allocatable  :: ia(:)            ! Ѵ
  real(8), allocatable  :: a(:)             ! Ѵ
  real(8), allocatable  :: y(:,:)           ! Ѵ

  real(8), allocatable  :: q(:)             ! 
  real(8), allocatable  :: ww(:), ws(:)     ! 

  real(8), allocatable  :: x_lon(:), y_lat(:)                ! ٷ
  real(8), allocatable  :: x_lon_weight(:), y_lat_weight(:)  ! ɸŤ
  real(8), allocatable  :: xy_lon(:,:), xy_lat(:,:)

  real(8), parameter    :: pi=3.1415926535897932385D0

  private

  public im, jm, nm                           ! ʻ, ȿ, Ⱦ
  public it, t, y, ip, p, r, ia, a            ! ѴѺ

  public w_base_initial                       ! ֥롼
  public x_lon, y_lat                         ! ʻҺɸ
  public x_lon_weight, y_lat_weight           ! ʻҺɸŤ
  public xy_lon, xy_lat                       ! ʻҺɸ(im,jm)
  public l_nm, nm_l                           ! ȿǼ
  public xy_w, w_xy                           ! Ѵؿ

  save im, jm, nm                             ! ʻ, ȿ, Ⱦ¤򵭲
  save it, t, y, ip, p, r, ia, a              ! Ѵ򵭲

  contains
  !---------------  -----------------
    subroutine w_base_initial(n_in,i_in,j_in)

      integer,intent(in) :: i_in, j_in        ! ʻ(, )
      integer,intent(in) :: n_in              ! ȿ

      integer :: iw, i, j

      im = i_in  ; jm = j_in  ; nm = n_in

      allocate(t(im*2))                       ! Ѵ
      allocate(ip(((nm+1)/2+nm+1)*2))         ! Ѵ
      allocate(p(((nm+1)/2+nm+1)*jm))         ! Ѵ
      allocate(r(((nm+1)/2*2+3)*(nm/2+1)))    ! Ѵ
      allocate(ia((nm+1)*(nm+1)*4))           ! Ѵ
      allocate(a((nm+1)*(nm+1)*6))            ! Ѵ
      allocate(y(jm/2,4))                     ! Ѵ

      allocate(q(((nm+1)/2+nm+1)*jm))         ! 
      iw=(im+3*(nm+1))*jm
      allocate(ws(iw),ww(iw))                 ! 

      allocate(x_lon(im), y_lat(jm))              ! ʻɸǼ
      allocate(x_lon_weight(im),y_lat_weight(jm)) ! ʻɸǼ
      allocate(xy_lon(im,jm),xy_lat(im,jm))       ! ʻɸǼ

      call sninit(nm,im,jm,it,t,y,ip,p,r,ia,a)

      do i=1,im
         x_lon(i)  = 2*pi/im*(i-1)              ! ٺɸ
         x_lon_weight(i) = 2*pi/im              ! ٺɸŤ
      enddo

      do j=1,jm/2
         y_lat(jm/2+j)   =  asin(y(j,1))        ! ٺɸ
         y_lat(jm/2-j+1) = -asin(y(j,1))        ! ٺɸ
         y_lat_weight(jm/2+j)   = y(j,2)        ! ٽŤ(Gauss grid)
         y_lat_weight(jm/2-j+1) = y(j,2)        ! ٽŤ(Gauss grid)
      enddo

      do j=1,jm
         xy_lon(:,j) = x_lon
      enddo

      do i=1,im
         xy_lat(i,:) = y_lat
      enddo

    end subroutine w_base_initial

  !--------------- Ѵ -----------------

    function l_nm(n,m)                  ! ڥȥǡγǼ
      integer               :: l_nm     ! ڥȥǡ
      integer, intent(in)   :: n, m     ! ȿ, Ӿȿ

      call snnm2l(n,m,l_nm)
    end function l_nm

    function nm_l(l)                    ! ڥȥǼ֤ȿ
      integer               :: nm_l(2)  ! ȿ, Ӿȿ
      integer, intent(in)   :: l        ! ڥȥǡγǼ
      
      call snl2nm(l,nm_l(1),nm_l(2))
    end function nm_l

    function xy_w(ep,ipow,iflag)    ! Ĵ´ؿڥȥ -> ʻ
      real(8)               :: xy_w(im,jm)        ! ʻ
      real(8), intent(in)   :: ep((nm+1)*(nm+1))  ! ڥȥ
      integer, intent(in), optional  :: ipow      ! Ѥ 1/cos μ
      integer, intent(in), optional  :: iflag     ! Ѵμ

      integer, parameter  :: ipow_default  = 0
      integer, parameter  :: iflag_default = 0

      integer ipval, ifval

      if (present(ipow)) then
         ipval = ipow
      else
         ipval = ipow_default
      endif

      if (present(iflag)) then
         ifval = iflag
      else
         ifval = iflag_default
      endif

      call snts2g(nm,im,im,jm,jm,1,ep,xy_w,&
           it,t,y,ip,p,r,ia,a,q,ws,ww,ipval,ifval)

    end function xy_w

    function w_xy(xy,ipow,iflag) ! ʻ -> Ĵ´ؿڥȥ
      real(8)               :: w_xy((nm+1)*(nm+1)) ! ڥȥ
      real(8), intent(in)   :: xy(im,jm)           ! ʻ
      integer, intent(in), optional  :: ipow      ! Ѥ 1/cos μ
      integer, intent(in), optional  :: iflag     ! Ѵμ

      integer, parameter  :: ipow_default  = 0    ! åǥե
      integer, parameter  :: iflag_default = 0    ! åǥե

      integer ipval, ifval

      if (present(ipow)) then
         ipval = ipow
      else
         ipval = ipow_default
      endif

      if (present(iflag)) then
         ifval = iflag
      else
         ifval = iflag_default
      endif

      call sntg2s(nm,im,im,jm,jm,1,xy,w_xy,&
           it,t,y,ip,p,r,ia,a,q,ws,ww,ipval,ifval)
    end function w_xy

  end module w_base_module
